// settergetter.h

#ifndef SETTERGETTER_H
#define SETTERGETTER_H

#include "mxv_types.h"

template <class Type>
class SetterGetter {
public:
        virtual ~SetterGetter() {}
        virtual boolean set(Type) = 0;
        virtual Type get() const = 0;
};

template <class Type>
class PointerSetterGetter : public SetterGetter<Type> {
public:
        PointerSetterGetter(Type *val) : ptr(val) {}
	redefined boolean set(Type val) { *ptr = val; return true; }
	redefined Type get() const { return *ptr; }
private:
	Type* ptr;
};

template <class Type>
inline SetterGetter<Type>* createSetterGetter(Type* val) {
	return new PointerSetterGetter<Type>(val);
}

template <class Object, class Type>
class MethodVoidSetterGetter : public SetterGetter<Type> {
public:
        MethodVoidSetterGetter(Object* objptr,
			     void (Object::*setfunc)(Type),
			     Type (Object::*getfunc)() const)
		: obj(objptr), setter(setfunc), getter(getfunc) {}
	redefined boolean set(Type value) {
		(obj->*setter)(value); return true;
	}
	redefined Type get() const { return (obj->*getter)(); }
private:
	Object* obj;
	void (Object::*setter)(Type);
	Type (Object::*getter)() const;
};

#ifndef __GNUG__

template <class Object, class Type>
inline SetterGetter<Type>* createSetterGetter(
		Object* objptr,
		void (Object::*setfunc)(Type),
		Type (Object::*getfunc)() const) {
	return new MethodVoidSetterGetter<Object, Type>(objptr, setfunc, getfunc);
}

#endif

template <class Object, class Status, class Type>
class MethodSetterGetter : public SetterGetter<Type> {
public:
        MethodSetterGetter(Object* objptr,
			     Status (Object::*setfunc)(Type),
			     Type (Object::*getfunc)() const)
		: obj(objptr), setter(setfunc), getter(getfunc) {}
	redefined boolean set(Type value) {
		return boolean((obj->*setter)(value));
	}
	redefined Type get() const { return (obj->*getter)(); }
private:
	Object* obj;
	Status (Object::*setter)(Type);
	Type (Object::*getter)() const;
};

template <class Object, class Status, class Type>
inline SetterGetter<Type>* createSetterGetter(
		Object* objptr,
		Status (Object::*setfunc)(Type),
		Type (Object::*getfunc)() const) {
	return new MethodSetterGetter<Object, Status, Type>(objptr, setfunc, getfunc);
}

//********

template <class Status, class Type>
class FunctionSetterGetter : public SetterGetter<Type> {
public:
        FunctionSetterGetter(Status (*setfunc)(Type), Type (*getfunc)())
		: setter(setfunc), getter(getfunc) {}
	redefined boolean set(Type value) { (*setter)(value);  return true; }
	redefined Type get() const { return (*getter)(); }
private:
	Status (*setter)(Type);
	Type (*getter)();
};

template <class Status, class Type>
inline SetterGetter<Type>* createSetterGetter(
		Status (*setfunc)(Type),
		Type (*getfunc)()) {
	return new FunctionSetterGetter<Status, Type>(setfunc, getfunc);
}

#endif
