// framedwindow.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The outermost visual layer of every data display window.  It mostly deals
// with window manager events and menu storage and creation.

#ifndef FRAMEDWINDOW_H
#ifdef __GNUG__
#pragma interface
#endif
#define FRAMEDWINDOW_H

#include <InterViews/scene.h>

class Action;
class CommandState;
class Control;
class World;
class Handler;

class FramedWindow : public MonoScene {
public:
	FramedWindow(const char* title, int border = 1);
	virtual ~FramedWindow();
	void busy(boolean);
	void changeName(const char *);
	void display(World *);
	void unDisplay();
	void makeVisible();					// de-iconify if iconified
	boolean isMapped();
	World *getWorld();
	void closeAndDestroy();				// undisplay and destroy
	boolean checkForControlKeyEvent();
protected:
	redefined Interactor* Wrap(Interactor *);
	redefined void Reconfig();
	void setName(const char *);
	boolean busy() { return isBusy; }
	virtual Control* makeMenu(class Menu *, struct MenuInfo *);
	virtual Handler* getWMDeleteHandler() { return nil; }
private:
	void init();
	Coord viewXLocation();
	Coord viewYLocation();
	void incrementViewLocation();
	void storeName(const char *);
	virtual Interactor* makeMenuBar() = 0;
	virtual Action* makeMenuItemAction(const struct MenuInfo *) = 0;
	virtual CommandState *getCommandState() = 0;
private:
	char *windowname;
	Interactor *menus;
	unsigned borderWidth;
	boolean isBusy;
	static Coord currentViewX, currentViewY;
	static boolean placeWindows;
	static Bitmap* globalIconBitmap;
	static const int viewStartingX;
	static const int viewStartingY;
	static const int viewXIncrement;
	static const int viewYIncrement;
};

#endif

