// $Id: Sheet.java,v 1.1 2002/04/25 18:19:17 bill Exp $

package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import com.jclark.xsl.sax.SaxFilterMaker;

/**
 *  Represents a (compiled) XSLT stylesheet. Transforms an XML tree
 */
public interface Sheet
{
    /**
     * transform the document rooted at 
     *   <code>node</code> against this stylesheet
     * @param node the source document
     * @param parser a loader we can (re-)use
     * @param params the XSLT run-time parameters
     * @param result the destination for thetransformation results
     */
    Result process(Node node, XMLProcessor parser,
                   ParameterSet params, Result result) throws XSLException;

    /**
     * sets the experimental xrap processor for use during processing by
     * the ProcessContext
     */
    public void setSaxExtensionFilter(SaxFilterMaker xrap);

    /**
     * gets the xrap (extension) processor for use during processing
     */
    public SaxFilterMaker getSaxExtensionFilter();

    /**
     *
     */
    LoadContext getSourceLoadContext();
}
