#include <phidgets/rfid.h>
#include <stdio.h>

#include <string.h>
#include <unistd.h>

void fail_cleanup(PhidgetRFID* rfid, int r);
void clean(PhidgetRFID* rfid);

void usage(void) {
	fprintf(stderr, "Usage: test_libphidgets_rfid serial\n");
}

int main(int argc, char * argv[]) {
	PhidgetRFID *rfid;
	phidget_return ret;
	int i;
	
	if(argc != 2) {
		usage();
		return 1;
	}
	
	int serial = atoi(argv[1]);
	
	phidget_set_debug(PHIDGET_DEBUG_NONE);
	phidget_set_debug_stream(stderr);
	/*hid_set_debug(HID_DEBUG_ALL);
	hid_set_debug_stream(stderr);*/

	ret = phidget_init();
	if(ret != PHIDGET_RET_SUCCESS) {
		fprintf(stderr, "failed to init phidgets.\n");
		phidget_cleanup();
		return 1;
	}
	
	rfid = phidget_new_PhidgetRFID();

	ret = phidget_rfid_open(rfid, serial, 3);
	if(ret != PHIDGET_RET_SUCCESS)
	{
		fprintf(stderr, "failed to open RFID.\n");
		fail_cleanup(rfid, 1);
	}

	/* Turn everything off */
	ret = phidget_rfid_set_state(rfid, false, false, false, false);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to set default state.\n");
      fail_cleanup(rfid, 1);
   }

	
	/* Bring everything up one at a time */
	ret = phidget_rfid_set_toggle(rfid, PHIDGET_RFID_ENABLE, true);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to enable reader.\n");
      fail_cleanup(rfid, 1);
   }
	
	ret = phidget_rfid_set_toggle(rfid, PHIDGET_RFID_EXTERNAL_LED, true);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to turn on external LED.\n");
      fail_cleanup(rfid, 1);
   }

	ret = phidget_rfid_set_toggle(rfid, PHIDGET_RFID_ONBOARD_LED, true);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to enable onboard LED.\n");
      fail_cleanup(rfid, 1);
   }

	ret = phidget_rfid_set_toggle(rfid, PHIDGET_RFID_PLUS_FIVE, true);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to enable +5.\n");
      fail_cleanup(rfid, 1);
   }

	/* Turn everything off but the enable */
	ret = phidget_rfid_set_state(rfid, true, false, false, false);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to turn off everything but enable.\n");
      fail_cleanup(rfid, 1);
   }

	printf("Attempting to read 15 tags...\n");
	for(i = 0; i < 15; i++) {
		ret = phidget_rfid_get_tag(rfid, 6000);
		if (ret != PHIDGET_RET_SUCCESS) {
			if (ret == PHIDGET_RET_TIMEOUT) {
				fprintf(stderr, "Timed out: please wave rfid tag over reader\n");
				continue;
			}
			
			fprintf(stderr, "failed to get a tag %i.\n", ret);
			fail_cleanup(rfid, 1);
		}

		fprintf(stderr, "Read tag: %010llx at %lu seconds\n", 
			rfid->l_tag, rfid->time);
	}

	/* Disable reader */
	ret = phidget_rfid_set_state(rfid, false, false, false, false);
	if (ret != PHIDGET_RET_SUCCESS)
   {
      fprintf(stderr, "failed to disable reader LED.\n");
      fail_cleanup(rfid, 1);
   }

	cleanup(rfid);		
}

void fail_cleanup(PhidgetRFID* rfid, const int r)
{
	cleanup(rfid);
	exit(r);
}

void cleanup(PhidgetRFID* rfid) {
	phidget_rfid_close(rfid);
	phidget_delete_PhidgetRFID(&rfid);
	phidget_cleanup();
}

