if (Array.length Sys.argv <> 3) then (Printf.printf "\
   Usage:  populate conninfo table
   Connect to Postgres with [conninfo] (e.g. \"host=glouglou\"),
   and copy stdin to [table]
"; exit 1);;


let main() =
  let c = new Postgres.connection Sys.argv.(1) in
  let _ = c#exec_expect ("copy "^(Sys.argv.(2))^" from stdin") 
	    [Postgres.Result.Copy_in] in
  c#copy_in_channel stdin;
  c#close

let _ = 
  try main ()
  with 
    | Postgres.Error e -> prerr_endline (Postgres.string_of_error e)
    | e -> prerr_endline (Printexc.to_string e)
