#!/bin/sh
# configure script for zlib. This script is needed only if
# you wish to build a shared library and your system supports them,
# of if you need special compiler, flags or install directory.
# Otherwise, you can just use directly "make test; make install"
#
# To create a shared library, use "configure --shared"; by default a static
# library is created. If the primitive shared library support provided here
# does not work, use ftp://prep.ai.mit.edu/pub/gnu/libtool-*.tar.gz
#
# To impose specific compiler or flags or install directory, use for example:
#    prefix=$HOME CC=cc CFLAGS="-O4" ./configure
# or for csh/tcsh users:
#    (setenv prefix $HOME; setenv CC cc; setenv CFLAGS "-O4"; ./configure)
# LDSHARED is the command to be used to create a shared library

# Incorrect settings of CC or CFLAGS may prevent creating a shared library.
# If you have problems, try without defining CC and CFLAGS before reporting
# an error.

LIBS=libz.a
SHAREDLIB=libz.so
VER=`sed -n -e '/VERSION "/s/.*"\(.*\)".*/\1/p' < zlib.h`
AR=${AR-"ar rc"}
RANLIB=${RANLIB-"ranlib"}
prefix=${prefix-/usr/local}
exec_prefix=${exec_prefix-'${prefix}'}
libdir=${libdir-'${exec_prefix}/lib'}
includedir=${includedir-'${prefix}/include'}
shared_ext='.so'
shared=0
gcc=0
old_cc="$CC"
old_cflags="$CFLAGS"

while test $# -ge 1
do
case "$1" in
    -h* | --h*)
      echo 'usage:'
      echo '  configure [--shared] [--prefix=PREFIX]  [--exec_prefix=EXPREFIX]'
      echo '     [--libdir=LIBDIR] [--includedir=INCLUDEDIR]'
        exit 0;;
    -p*=* | --p*=*) prefix=`echo $1 | sed 's/[-a-z_]*=//'`; shift;;
    -e*=* | --e*=*) exec_prefix=`echo $1 | sed 's/[-a-z_]*=//'`; shift;;
    -l*=* | --libdir=*) libdir=`echo $1 | sed 's/[-a-z_]*=//'`; shift;;
    -i*=* | --includedir=*) includedir=`echo $1 | sed 's/[-a-z_]*=//'`;shift;;
    -p* | --p*) prefix="$2"; shift; shift;;
    -e* | --e*) exec_prefix="$2"; shift; shift;;
    -l* | --l*) libdir="$2"; shift; shift;;
    -i* | --i*) includedir="$2"; shift; shift;;
    -s* | --s*) shared=1; shift;;
    esac
done

test=ztest$$
cat > $test.c <<EOF
extern int getchar();
int hello() {return getchar();}
EOF

test -z "$CC" && echo Checking for gcc...
cc=${CC-gcc}
cflags=${CFLAGS-"-O3"}
# to force the asm version use: CFLAGS="-O3 -DASMV" ./configure
case "$cc" in
  *gcc*) gcc=1;;
esac

if test "$gcc" -eq 1 && ($cc -c $cflags $test.c) 2>/dev/null; then
  CC="$cc"
  SFLAGS=${CFLAGS-"-fPIC -O3"}
  CFLAGS="$cflags"
  case `(uname -s || echo unknown) 2>/dev/null` in
  Linux | linux) LDSHARED=${LDSHARED-"gcc -shared -Wl,-soname,libz.so.1"};;
  *)             LDSHARED=${LDSHARED-"gcc -shared"};;
  esac
else
  # find system name and corresponding cc options
  CC=${CC-cc}
  case `(uname -sr || echo unknown) 2>/dev/null` in
  HP-UX*)    SFLAGS=${CFLAGS-"-O +z"}
	     CFLAGS=${CFLAGS-"-O"}
#	     LDSHARED=${LDSHARED-"ld -b +vnocompatwarnings"}
	     LDSHARED=${LDSHARED-"ld -b"}
	     shared_ext='.sl'
	     SHAREDLIB='libz.sl';;
  IRIX*)     SFLAGS=${CFLAGS-"-ansi -O2 -rpath ."}
	     CFLAGS=${CFLAGS-"-ansi -O2"}
	     LDSHARED=${LDSHARED-"cc -shared"};;
  OSF1\ V4*) SFLAGS=${CFLAGS-"-O -std1"}
	     CFLAGS=${CFLAGS-"-O -std1"}
	     LDSHARED=${LDSHARED-"cc -shared  -Wl,-soname,$SHAREDLIB -Wl,-msym -Wl,-rpath,$(libdir) -Wl,-set_version,${VER}:1.0"};;
  OSF1*)     SFLAGS=${CFLAGS-"-O -std1"}
	     CFLAGS=${CFLAGS-"-O -std1"}
	     LDSHARED=${LDSHARED-"cc -shared"};;
  QNX*)      SFLAGS=${CFLAGS-"-4 -O"}
             CFLAGS=${CFLAGS-"-4 -O"}
	     LDSHARED=${LDSHARED-"cc"}
             RANLIB=${RANLIB-"true"}
             AR="cc -A";;
  SCO_SV\ 3.2*) SFLAGS=${CFLAGS-"-O3 -dy -KPIC "}
	     CFLAGS=${CFLAGS-"-O3"}
	     LDSHARED=${LDSHARED-"cc -dy -KPIC -G"};;
  SunOS\ 5*) SFLAGS=${CFLAGS-"-fast -xcg89 -KPIC -R."}
             CFLAGS=${CFLAGS-"-fast -xcg89"}
	     LDSHARED=${LDSHARED-"cc -G"};;
  SunOS\ 4*) SFLAGS=${CFLAGS-"-O2 -PIC"}
	     CFLAGS=${CFLAGS-"-O2"}
	     LDSHARED=${LDSHARED-"ld"};;
  UNIX_System_V\ 4.2.0) 
	     SFLAGS=${CFLAGS-"-KPIC -O"}
	     CFLAGS=${CFLAGS-"-O"}
	     LDSHARED=${LDSHARED-"cc -G"};;
  UNIX_SV\ 4.2MP)
	     SFLAGS=${CFLAGS-"-Kconform_pic -O"}
	     CFLAGS=${CFLAGS-"-O"}
	     LDSHARED=${LDSHARED-"cc -G"};;
  # send working options for other systems to support@gzip.org
  *)         SFLAGS=${CFLAGS-"-O"}
	     CFLAGS=${CFLAGS-"-O"}
	     LDSHARED=${LDSHARED-"cc -shared"};;
  esac
fi

if test $shared -eq 1; then
  echo Checking for shared library support...
  # we must test in two steps (cc then ld), required at least on SunOS 4.x
  if test "`($CC -c $SFLAGS $test.c) 2>&1`" = "" &&
     test "`($LDSHARED -o $test$shared_ext $test.o) 2>&1`" = ""; then
    CFLAGS="$SFLAGS"
    LIBS="$SHAREDLIB.$VER"
    echo Building shared library $SHAREDLIB.$VER with $CC.
  elif test -z "$old_cc" -a -z "$old_cflags"; then
    echo No shared library suppport.
    shared=0;
  else
    echo 'No shared library suppport; try without defining CC and CFLAGS'
    shared=0;
  fi
fi
if test $shared -eq 0; then
  LDSHARED="$CC"
  echo Building static library $LIBS version $VER with $CC.
fi

cat > $test.c <<EOF
#include <unistd.h>
int main() { return 0; }
EOF
if test "`($CC -c $CFLAGS $test.c) 2>&1`" = ""; then
  CFLAGS="$CFLAGS -DHAVE_UNISTD_H"
  echo "Checking for unistd.h... Yes."
else
  echo "Checking for unistd.h... No."
fi

cat > $test.c <<EOF
#include <errno.h>
int main() { return 0; }
EOF
if test "`($CC -c $CFLAGS $test.c) 2>&1`" = ""; then
  echo "Checking for errno.h...	 Yes."
else
  echo "Checking for errno.h...	 No."
  CFLAGS="$CFLAGS -DNO_ERRNO_H"
fi

cat > $test.c <<EOF
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
caddr_t hello() {
  return mmap((caddr_t)0, (off_t)0, PROT_READ, MAP_SHARED, 0, (off_t)0); 
}
EOF
if test "`($CC -c $CFLAGS $test.c) 2>&1`" = ""; then
  CFLAGS="$CFLAGS -DUSE_MMAP"
  echo Checking for mmap support... Yes.
else
  echo Checking for mmap support... No.
fi

CPP=${CPP-"$CC -E"}
case $CFLAGS in
  *ASMV*)
    if test "`nm $test.o | grep _hello`" = ""; then
      CPP="$CPP -DNO_UNDERLINE"
      echo Checking for underline in external names... No.
    else
      echo Checking for underline in external names... Yes.
    fi;;
esac

rm -f $test.[co] $test$shared_ext

# udpate Makefile
sed < Makefile.in "
/^CC *=/s%=.*%=$CC%
/^CFLAGS *=/s%=.*%=$CFLAGS%
/^CPP *=/s%=.*%=$CPP%
/^LDSHARED *=/s%=.*%=$LDSHARED%
/^LIBS *=/s%=.*%=$LIBS%
/^SHAREDLIB *=/s%=.*%=$SHAREDLIB%
/^AR *=/s%=.*%=$AR%
/^RANLIB *=/s%=.*%=$RANLIB%
/^VER *=/s%=.*%=$VER%
/^prefix *=/s%=.*%=$prefix%
/^exec_prefix *=/s%=.*%=$exec_prefix%
/^libdir *=/s%=.*%=$libdir%
/^includedir *=/s%=.*%=$includedir%
" > Makefile
