=begin
  locale.rb - Locale module

  Copyright (C) 2002,2003  Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale.rb,v 1.5 2004/02/14 12:59:11 mutoh Exp $
=end

if /cygwin|mingw|mswin32|bccwin32/ =~ RUBY_PLATFORM
  require 'gettext/locale_win32'
else
  require 'gettext/locale_default'
end

module Locale
  def get
    lc = __get
    ret = nil
    ["LC_ALL", "LC_CTYPE", "LC_MESSAGES", "LANG"].each do |env|
      ret = ENV[env]
      break if ret
    end
    ret ? ret : lc
  end

  alias :setlocale :set
  alias :charset :codeset

  module_function :get, :setlocale, :charset
end

if __FILE__ == $0
  p Locale.get
  p Locale.codeset
end
