//$Id: controlwidget.cc,v 1.4 2002/07/28 18:27:01 murrayc Exp $ -*- c++ -*-

/* bonobomm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "controlwidget.h"

#include <gtkmm/button.h>
#include <gtkmm/dialog.h>
#include <gtkmm/stock.h>

ControlWidget::ControlWidget()
{
    Gtk::Button *button = new Gtk::Button ("Click me");
    button->signal_clicked ().connect (SigC::slot (*this, &ControlWidget::button_cb));

    pack_start (*manage (new Gtk::Label ("Bonobomm demo control")), Gtk::PACK_SHRINK);
    pack_start (entry, Gtk::PACK_EXPAND_WIDGET);
    pack_start (*manage (button));
    
    show_all ();
}


void ControlWidget::button_cb () const
{
    static Gtk::Dialog *dialog = 0;

    if (dialog)
	return;
    
    dialog = new Gtk::Dialog ("Bonobomm demo control", false, true);
    Glib::ustring dialog_message = "The text entered is: " + entry.get_text ();
    
    dialog->get_vbox ()->pack_start (*manage (new Gtk::Label (dialog_message)));
    dialog->add_button (Gtk::StockID (Gtk::Stock::OK), 0);
    dialog->show_all ();

    dialog->run ();

    delete dialog;
    dialog = 0;
}
