
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <widgets/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "./dock.h"
#include "./dockband.h"
#include "./dockitem.h"
#include "./docklayout.h"
#include "./selector.h"
#include "./selectorwidget.h"
#include "./widget.h"
#include "./window.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType bonobo_dock_get_type(void);
GType bonobo_dock_get_type(void);
GType bonobo_dock_item_get_type(void);
GType bonobo_dock_layout_get_type(void);
GType bonobo_selector_get_type(void);
GType bonobo_selector_widget_get_type(void);
GType bonobo_widget_get_type(void);
GType bonobo_window_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Bonobo {  class Dock_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class DockBand_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class DockItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class DockLayout_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class Selector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class SelectorWidget_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class Widget_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Bonobo {  class Window_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Bonobo { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(bonobo_dock_get_type(), &Gnome::Bonobo::Dock_Class::wrap_new);
  Glib::wrap_register(bonobo_dock_get_type(), &Gnome::Bonobo::DockBand_Class::wrap_new);
  Glib::wrap_register(bonobo_dock_item_get_type(), &Gnome::Bonobo::DockItem_Class::wrap_new);
  Glib::wrap_register(bonobo_dock_layout_get_type(), &Gnome::Bonobo::DockLayout_Class::wrap_new);
  Glib::wrap_register(bonobo_selector_get_type(), &Gnome::Bonobo::Selector_Class::wrap_new);
  Glib::wrap_register(bonobo_selector_widget_get_type(), &Gnome::Bonobo::SelectorWidget_Class::wrap_new);
  Glib::wrap_register(bonobo_widget_get_type(), &Gnome::Bonobo::Widget_Class::wrap_new);
  Glib::wrap_register(bonobo_window_get_type(), &Gnome::Bonobo::Window_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Bonobo::Dock::get_type();
  Gnome::Bonobo::DockBand::get_type();
  Gnome::Bonobo::DockItem::get_type();
  Gnome::Bonobo::DockLayout::get_type();
  Gnome::Bonobo::Selector::get_type();
  Gnome::Bonobo::SelectorWidget::get_type();
  Gnome::Bonobo::Widget::get_type();
  Gnome::Bonobo::Window::get_type();

} // wrap_init()

} //Bonobo
} //Gnome


