#!/bin/sh -e

if [ -z "$2" ]; then
	echo "Usage: $0 <dir name> <src dir>"
	exit 1
fi

if [ -e "$1" ]; then
	echo "Directory $1 exists, please move it out of the way"
	exit 2
fi

find_and_copy_files()
{
	from="$1"
	to="$2"

	find "$from" -name "*.id" -maxdepth 2 | \
			sed -e 's/\.arch-ids\///' -e 's/\.id$//' | \
			while read x; do cp -a "$x" "$to"; done
}

mkdir -p "$1/examples/test"
mkdir -p "$1/examples/test2"
find_and_copy_files "$2" "$1"
find_and_copy_files "$2/examples" "$1/examples"
find_and_copy_files "$2/examples/test" "$1/examples/test"
find_and_copy_files "$2/examples/test2" "$1/examples/test2"
tla changelog -d "$2" > "$1/ChangeLog"
tar zvcf "$1.tar.gz" "$1"
rm -rf "$1"

