-- Based on the mtl Control.Monad.State, which is
-- 
-- Copyright   :  (c) Andy Gill 2001,
-- 		  (c) Oregon Graduate Institute of Science and Technology, 2001
-- License     :  BSD-style (see the file libraries/base/LICENSE)
-- 
-- We'd like to just use the library, but for nhc98 compatibility we can't

module StateM (
	StateM, evalStateM, get, put
  ) where

newtype StateM s a = StateM { runStateM :: s -> (a, s) }

evalStateM :: StateM s a -> s -> a
evalStateM m s = fst (runStateM m s)

instance Monad (StateM s) where
	return a = StateM $ \s -> (a, s)
	m >>= k  = StateM $ \s -> let
		(a, s') = runStateM m s
		in runStateM (k a) s'

get :: StateM s s
get = StateM $ \s -> (s, s)

put :: s -> StateM s ()
put s = StateM $ \_ -> ((), s)

