/* implements some basic callback concept used by various functions
 * to tell interested parts of the program about changes */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>

#include "updatehandlers.h"

/* uncomment for debugging */
/* #define DEBUG */

typedef struct
{
   updatehandlers_handler handler;
   gpointer data;
}
updatehandlers_handlerinfo;

/* calls all the handler functions */
void updatehandlers_call(GList *hl)
{
   GList *current=NULL;
   GList *next=NULL;
   updatehandlers_handlerinfo *hi;

#ifdef DEBUG
   printf ("updatehandlers_call: calling updatehandlers in List at %p\n",
	   hl);
#endif

   for(current=hl;
       current!=NULL;
       current=next)
     {
	/* save ->next field of GList entry as the	
	 * update handler might destroy the current	
	 * entry. (done e.g. within filetypes.c) */
	next=current->next;
	hi=(updatehandlers_handlerinfo*)current->data;
	if ((hi)&&(hi->handler))
	  hi->handler(hi->data);
     }
   ;
}
;

/* register a handler function */
void updatehandlers_register(GList **hl,updatehandlers_handler h,gpointer data)
{
   updatehandlers_handlerinfo *hi;

   hi=(updatehandlers_handlerinfo*)malloc(sizeof(updatehandlers_handlerinfo));
   hi->handler=h;
   hi->data=data;
   *hl=g_list_append(*hl,(gpointer)hi);

#ifdef DEBUG
   printf ("updatehandlers_register: registered handler at %p with data %p,infostructure at %p\n",
	   h,data,hi);
#endif
}
;

/* unregister a callback. you can specify the callback by either its handler
 * function of its data area. You can specify both or just one of those
 * parameters. Unused parameters should be set to NULL.
 * This function removes all handlers matching h and data. so if you
 * specify NULL for both of them,the whole list of callbacks will be
 * deleted. */
void updatehandlers_unregister(GList **hl,
			       updatehandlers_handler h,
			       gpointer data)
{
   updatehandlers_handlerinfo *hi;
   GList *current;

#ifdef DEBUG
   printf ("updatehandlers_unregister: unregistering handler at %p with data %p\n",
	   h,data);
#endif

	/* unregistering is a bit more complicated as because of the additional
	 * data field we cannot just store the callback pointer within
	 * the Glist entrys data field but have to to work with a selfmade
	 * structure updatehandlers_handlerinfo*/
   for (current=*hl;current!=NULL;)
     {
	hi=(updatehandlers_handlerinfo*)current->data;
	current=current->next;
	if (((h==NULL)||(hi->handler==h))&&
	    ((data==NULL)||(hi->data==data)))
	  {
#ifdef DEBUG
	     printf ("updatehandlers_unregister: removing infostructure at %p (handler=%p,data=%p)\n",
		     hi,hi->handler,hi->data);
#endif
	     *hl=g_list_remove(*hl,hi);
	     free(hi);

#ifdef DEBUG
	     printf ("updatehandlers_unregister: done.\n");
#endif

	  }
	;
     }
   ;
}
;

