/* This is an attempt to fix the problem with GtkTreeItems accepting
 * no signals from level 2 on ... */

#include <gtk/gtk.h>

#include "dndsetup.h"

void treedroppatch_drophandler(GtkWidget *w,
			       GdkDragContext *c,
			       gint x,
			       gint y,
			       GtkSelectionData *data,
			       guint inf,
			       guint time,
			       gpointer nothing)
{
	GtkTreeItem *treeitem;
	
	gdk_window_get_user_data(gdk_window_at_pointer(NULL,NULL),
				 (gpointer)&treeitem);
	if (GTK_IS_TREE_ITEM(treeitem))
	    gtk_signal_emit_by_name(GTK_OBJECT(treeitem),
				    "drag_data_received",
				    c,x,y,data,inf,time);
}
;


void treedroppatch_install(GtkWidget *w)
{
   dndsetup_drop_raw(w,treedroppatch_drophandler,NULL);
}
;
