/* Filelist Widget */

#ifndef SELECTLIST_H
#define SELECTLIST_H

#include <gtk/gtk.h>

#include "menusys.h"
#include "dndsetup.h"

#define SELECTLIST_MAXSELSIZE 65536

/* prototye for a selectlist_dropcallback handler,taking the dropped string
 * and the position within the widget as argument */
typedef dndsetup_dropcallback selectlist_dropcallback;

typedef enum     
{  
   None,    
   Control,    
   Shift
} SelectModifier;

typedef struct 
{
   GtkCList *self;                       /* points to the CList itself for referencing */
   char selection[SELECTLIST_MAXSELSIZE];/* currently selected entries,already in drag and drop compatible form */
   GList *selected_lines;                /* this is a GList storing the line numbers of the lines currently selected */
   char header[256];                     /* header to append to entry names (e.g. file:/pub/Linux/Software/) */
   int  significant_column;              /* this column is being passed by drag and drop */
   selectlist_dropcallback receiver;     /* highlevel callback when new files have arrived for current selectlist */
   int  send;
   int  is_drag_source;        /* becomes TRUE as long as this list has a pending drag_done event */
   menusys_menu *popup;
   gpointer doubleclick;
   gpointer callback_data;
   char **headings;            /* headers for the columns, array of char* */
   SelectModifier modifier;
   char kbsearchinfo[256];     /* searching entries by keyboard */
} selectlist_info;

typedef void (*selectlist_doubleclick_cb_t)(selectlist_info*,gpointer data);

/* unlike the normal clist call,where the clist itself knows how many heading
 * entries it needs,the char *headings[] list of header strings has to
 * be terminated with NULL here as it is copied into selectlist's own memory.
 * Also,gettext() translation is automatically performed on them in this
 * step,possible buffer overflows due to translating are being taken care of */
selectlist_info *selectlist_info_create(char *header,int significant_column,
					selectlist_dropcallback receiver,
					int send,menusys_menu *popup,
					selectlist_doubleclick_cb_t doubleclick,
					gpointer callback_data,
					const char *headings[]);
/* destroy selectlist info struct */
void selectlist_info_destroy(selectlist_info *info);
// create a selectlist
// a selectlist created by selectlist_create is far from being complete
// for the high level program selectlist_create roughly corresponds to the
// common gtk function gtk_clist_new. hence it still has to be inserted into
// a scrolling area,also there are no entries defined yet
GtkWidget *selectlist_create(selectlist_info *selectlist,int columns);
/* get a string containing the selected items of this clist.
 * don't access the selection string of the selectlist_info directly
 * as it is created on the fly by selectlist_getselection and thus may not
 * contain correct content. However,the pointer returned here points directly
 * to this structure,so it can be processed as always except that you don't
 * have to care about changes within the selection string any more */
char *selectlist_getselection(selectlist_info *info);
/* manipulate the select list - those wrapper functions are necessary
 * to keep the selection list valid even if elements are shifted within
 * the list */
void selectlist_insert(selectlist_info *info,gint row,gchar *text[]);
void selectlist_remove(selectlist_info *info,gint row);

/* this is a callback function that can be incorporated into any popup menu
 * attached to a selectlist. It will transparently provide file/track encoding
 * functionality */
void selectlist_encodetofile(GtkWidget *w,selectlist_info *info);

/* Set the focus to a specific row. This will surround passed row
 * with a rectangle indicating that this is the item to be selected
 * in keyboard operation mode */
void selectlist_setfocus(selectlist_info *info, gint row);

#endif // SELECTLIST_H
