/* this file implements gnometoasters preview function which can be used
 * to listen to audio tracks prior to writing them to a cd,be it to test
 * wether the track sounds properly or just to determine if it is the right
 * track at all. This widget primarily works as a drop destination where
 * tracks to be previewed are dropped. Additionally,it implements
 * a button to stop a tracks preview if it is no longer needed.
 * 
 * It is intended to support a variety of output devices with a driver-based
 * concept. That means,that well have to create a driver database for audio
 * output,supporting at least esd and dsp from the very beginning.
 * 
 * concerning docking position,we should possibly allow it to float around freely
 * if gnome support is enabled,perhaps giving it the layout of a proper
 * media player if dragged outside Gnometoasters main window */

#ifndef PREVIEW_H
#define PREVIEW_H

#include <gtk/gtk.h>

#include "main.h"
#include "tracks.h"
#include "audio.h"
#include "streamcopy.h"

typedef struct
{	
   GtkWidget *button;
   GtkWidget *iconholder;          /* holds the icons occurring in the preview player */
   tracks_trackinfo *currenttrack; /* track currently in process - NULL if none */
   audio_driver *driver;
   streamcopy_state *cs;
   
   tracks_trackinfo *nexttrack;
} preview_infostruct;

extern preview_infostruct preview_info;
extern int preview_player_active;

void preview_create();
void preview_playtrack(char *trackname,preview_infostruct *info);
void preview_destroy();

#endif // PREVIEW_H

