/* contains some litte helper functions used by parts of Gnometoaster */

#ifndef HELPINGS_H
# define HELPINGS_H

# include <gtk/gtk.h>
# include <string.h>
#include <stdio.h>

/* pad a value to alignment, *adding up* to the next alignment */
# define helpings_pad(size,alignment) \
     ((size%alignment>0)?((size/alignment)+1)*alignment:size)
/* cut CR+LF off a string */
# define helpings_cutcr(string) \
     if (strchr(string,13)!=NULL) \
	 *strchr(string,13)=0; \
     if (strchr(string,10)!=NULL) \
         *strchr(string,10)=0

# define helpings_readuint(buffername,position) \
     ((unsigned int)buffername[position]+\
     (((unsigned int)buffername[position+1])<<8)+\
     (((unsigned int)buffername[position+2])<<16)+\
     (((unsigned int)buffername[position+3])<<24))

/* build sum of all a numbers digits */
int helpings_dsum(int val);
GList *helpings_buildglist(char *stringlist[]);
char *helpings_getlinestart(char *s,int n);
/* get line number n,cut the rest so that this particular line is the only
 * thing remaining. Make a copy first,of course... */
char *helpings_getlineno(char *s,int n);
/* get the n-th value occurring in a string */
int helpings_getvalueinstring(char *s,int n);

void helpings_formatnumber(char *buf,int bufsize,long long unsigned int number);

/* set verbose to 1 if you want the meaning of the different numbers
 * to be spelled out like "01 hour(s) 23 minute(s) 23 sec." */
char *helpings_secs2hms(int secs,int verbose);

/* compare a word to a list of words separated by "sep" and return true if
 * it was found */
int helpings_listcomp(char *list,char *word,char *sep);

/* get valid location of a file out of a list of possible locations */
char *helpings_locate(char *paths[]);

/* make a legal filename out of a name.
 * This function essentially removes all '/'es */
void helpings_makelegalfilename(char *name);

/* combine path and filename and return result */
char *helpings_fileinpath(const char *path,const char *file);

/* get rightmost path component (file or directory) */
char *helpings_rpathcomponent(char *path);

/* get path only. cuts the righmost path component (file or directory) */
char *helpings_pathonly(const char *path);

/* returns 1 if the file is in the given path. Both must be absolute
 * path specifiers */
int helpings_isinpath(const char *file,const char *path);

int helpings_pathcompare(const char *p1,const char *p2);

/* this returns a GList containing all items in the dnd string passed to
 * this function */
GList *helpings_convertdndlist(const char *dndlist);

/* returns true if one of the GList entries starts with string */
int helpings_dndlistitemstartswith(GList *dndlist,
				   char *string);

/* translate a list of strings using gettext and store the results in the
 * new stringlist returned by this function */
char **helpings_translatestringlist(const char **list);

/* finds occurrence of a substring in a string while not matching the
 * parts of string located between quotation marks.
 * This is necessary for parsing terms containing string constants,
 * e.g. functions expecting a filename as their parameter or
 * the regexp parsing function */
char *helpings_strstr_quote(char *string,char *substring);

/* print a GList of strings stored in it's ->data field */
void helpings_printstringlist(GList *s);
/* delete a GList of strings and free those strings as well */
void helpings_freestringlist(GList *s);
/* convert special characters represented by %xx within a string
 * into normal characters */
char *helpings_convertspecialchars(char *source);
/* similar to the function above, will resolve escape sequences.
 * \t,\n,\r etc. are being resolved into their respective ASCII characters */
char *helpings_resolveescapedchars(const char *source);

/* cut a string to fit a certain number of pixels
 * This is for displaying large paths and will place a [...] in the
 * middle of the string if it was cut. */
char *helpings_cutstring(int nmb,const char *source,GdkFont *cfont);

/* get a string terminated by specified character. Doesn't have to
 * be 0, 13 or 10.
 * if ignorelistlength is >0 ignorelist is expected to be a pointer 
 * to a list of characters to be ignored when retrieving the string */
char *helpings_getterminatedstring(FILE *input, char terminator,
				   int ignorelistlength,
				   const char *ignorelist);

/* espace the characters in escapelist with escape_char.
 * This function will always escape escape_char as well */
char *helpings_escape(const char *input,
		      const char *escapelist,char escape_char);

/* remove specified character from a string.
 * Returns new string without specified character. Result must
 * be freed by caller */
char *helpings_removecharacters(const char *input, char candidate);

#endif // HELPINGS_H
