/* the widget displaying the fill state of the current cd */

#include "int.h"

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>

#include "main.h"
#include "preferences.h"
#include "trackedit.h"
#include "updatehandlers.h"
#include "colors.h"
#include "fillstate.h"
#include "varmanwidgets.h"
#include "varman.h"
#include "cddrives.h"

/* uncomment for debugging */
/* #define DEBUG */
 
struct fillstate_info *fillstate_bar;

/* redraws the specified portion of the widget */
void fillstate_draw(struct fillstate_info *info,
		    int x,int y,
		    int w,int h)
{
   GdkGC *gc;
   GdkRectangle r;
   GList *color=g_list_first(info->colors);
   gchar buffer[1024];
   int i=0;
   int amx=0;
   int cx,cy;
   unsigned long long totsize=0;
   r.x=x;
   r.y=y;
   r.width=w;
   r.height=h;
   gc=gdk_gc_new(info->widget->window);
   gdk_gc_copy(gc,info->widget->style->bg_gc[GTK_WIDGET_STATE(info->widget)]);
   gdk_gc_set_clip_rectangle(gc,&r);
   for (i=0;i<info->trackcount;i++)
     /* main drawing loop, for every track draw this */
    { 
       float percentage;
       int twidth;
       
       if (((float)info->totsiz)>0)
	 percentage=((float)info->siz[i])/((float)info->totsiz);
       else
	 percentage=0;
       
       twidth=info->xs*percentage;
       totsize+=info->siz[i];
       gdk_gc_set_foreground(gc,color->data);

       if ((info->themed)&&(info->widget->style))
	 gtk_paint_box (info->widget->style,
			info->widget->window,
			GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
			NULL, info->widget, "bar",
			amx,0,twidth,info->ys);
       else       
	 gdk_draw_rectangle(info->widget->window,
			    gc,
			    TRUE,
			    amx,
			    0,
			    twidth,
			    info->ys);

       if (color->next)
	 color=color->next;
       else
	 color=g_list_first(info->colors);
       amx+=twidth;
    }; 
   gdk_gc_unref(gc);
   gc=gdk_gc_new(info->widget->window);
   gdk_gc_copy(gc,info->widget->style->bg_gc[GTK_WIDGET_STATE(info->widget)]);
   gdk_gc_set_clip_rectangle(gc,&r);
   if (info->themed)
     gtk_paint_box (info->widget->style,
		    info->widget->window,
		    GTK_STATE_NORMAL, GTK_SHADOW_IN,
		    NULL, info->widget, "trough",
		    amx,0,info->xs-amx,info->ys);
   else
     gdk_draw_rectangle(info->widget->window,
			gc,
			TRUE,
			amx,
			0,
			info->xs-amx,
			info->ys);
   gdk_gc_unref(gc);
   gc=gdk_gc_new(info->widget->window);
   gdk_gc_copy(gc,info->widget->style->fg_gc[GTK_WIDGET_STATE(info->widget)]);
   gdk_gc_set_clip_rectangle(gc,&r);
   if (totsize>info->totsiz)
     gdk_gc_set_foreground(gc,&Red);
   sprintf(buffer,_("Fillstate %u MB/ %u MB ( %3.0f %% , %u:%02u/%u:%02u Minutes )"),
	   (unsigned int)(totsize/(1024*1024)),
	   (unsigned int )(info->totsiz/(1024*1024)),
	   ((float)totsize*100)/((float)info->totsiz),
	   (unsigned int)(totsize/(44100*4))/60,
	   (unsigned int)(totsize/(44100*4))%60,
	   (unsigned int)(info->totsiz/(44100*4))/60,
	   (unsigned int)(info->totsiz/(44100*4))%60
	   );
   cx=(info->xs-gdk_string_width(info->font,buffer))/2;
   cy=(info->ys+gdk_string_height(info->font,buffer))/2;
   gdk_draw_string(info->widget->window,
		   info->font,
		   gc,
		   0,gdk_string_height(info->font,buffer),
		   buffer);
   gdk_gc_unref(gc);
   
};

void fillstate_updatehandler(struct fillstate_info *info)
{
   int i;
   int rectracks=0;
   cddrives_cdinfo *recdev=NULL;

   info->trackcount=0;
   /* get recorder device */
   recdev=cddrives_getrecorder();
   /* if recorder device exists */
   if (recdev!=NULL)
     {	
	/* data already on cd */
	for (rectracks=0;rectracks<recdev->tracks;rectracks++)
	  info->siz[rectracks]=tracks_audiotracksize(recdev->track[rectracks]);
	info->trackcount+=recdev->tracks;
     };
   /* new tracks in trackedit */
   info->trackcount+=trackedit->entries;   
   for (i=rectracks;i<info->trackcount;i++)
     info->siz[i]=tracks_audiotracksize(tracklist_gettrack(trackedit,i-rectracks));
   fillstate_draw(info,0,0,info->xs,info->ys);
}
;
static gint fillstate_expose_event(GtkWidget *widget, GdkEventExpose *event,
				   struct fillstate_info *info)
{
  fillstate_draw(info,
		 event->area.x,event->area.y,
		 event->area.width,event->area.height);
  return FALSE;
};

static gint fillstate_configure_event (GtkWidget *widget, 
				       GdkEventConfigure *event,
				       struct fillstate_info *info)
{
#ifdef DEBUG
   printf ("fillstate_configure_event: got configure event\n");
#endif
  info->xs=widget->allocation.width;
  info->ys=widget->allocation.height;
  return TRUE;
};
struct fillstate_prefinfo
{
  GtkWidget *frame; /* frame enclosing all options*/
  GtkWidget *vbox;    /* vertical layout*/
  varmanwidgets_widget *themed; /* Checkbox for themed control */
  GtkWidget *ebox;   /* layout of colorlist selector*/
  GtkWidget *box; /* HBox holding the colors buttons */
  GtkWidget *add; /* Button to signal "ADD" a color at the end */
  GList *colors;
  struct fillstate_info *fillstate;
  GtkWidget *colorseldlg;
  int colorselforbutton; /* contains the # of the button the colorselection dialog handels at the moment */
};

int fillstate_pref_button_num(GtkWidget *button,
			      struct fillstate_prefinfo *info)
     /* returns -1 if not in list */
{
  GList *buttons;
  int i;
  buttons=g_list_first(gtk_container_children(GTK_CONTAINER(info->box)));
  i=g_list_index(buttons,button);
  if (i==-1) fprintf(stderr,"WARNING: fillstate_button_num(%p) == -1\n",button);
  return i;
};

/* the button needs to have a child (gtkpixmap) for this! 
   colour needs to be allocated and all
   so this won't work for initial creation :-/
 */
void fillstate_pref_dosetcolor(GtkWidget *button,
			       GdkColor *col)
{
  GdkPixmap* pix;
  GdkGC *gc;
  GtkPixmap*gpix;
  gc=gdk_gc_new(window->window);
  pix=gdk_pixmap_new(window->window,16,16,-1);
  gdk_gc_set_foreground(gc,col);
  gdk_draw_rectangle(pix,
		     gc,
		     TRUE,
		     0,0,
		     16,16);
  gpix=GTK_PIXMAP(GTK_BIN(button)->child);
  gtk_pixmap_set(gpix,pix,NULL);
  gdk_gc_unref(gc);
};

int fillstate_pref_doremovebutton(gpointer button)
{
  gtk_widget_destroy(GTK_WIDGET(button));
  return 0; /* called from timeout, only once! */
};

void fillstate_pref_removecolor(GtkWidget *pushedbutton,
				struct fillstate_prefinfo *info)
{
  int num;
  GList *coloritem;
  num=fillstate_pref_button_num(pushedbutton,
				info);
  coloritem=g_list_nth(info->colors,num);
  if ((num!=0)||(coloritem->next)) /* don't delete last color*/
    {
      info->colors=g_list_remove_link(info->colors,coloritem);
      g_timeout_add(0,
		    fillstate_pref_doremovebutton,
		    pushedbutton);
    };
};

void fillstate_pref_button_click(GtkWidget *button,
				 GdkEventButton *event,
				 struct fillstate_prefinfo *info)
{
  if (event->button==3)
      fillstate_pref_removecolor(button,info);
};

void fillstate_pref_setcolor(GtkWidget *pushedbutton,
			     struct fillstate_prefinfo *info)
{
  gdouble col[3];
  GdkColor *color;
  int num=fillstate_pref_button_num(pushedbutton,info);
  color=g_list_nth_data(g_list_first(info->colors),num);
  col[0]=((float)color->red)/65535.0;
  col[1]=((float)color->green)/65535.0;
  col[2]=((float)color->blue)/65535.0;
  gtk_color_selection_set_color(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(info->colorseldlg)->colorsel),
				col);
  info->colorselforbutton=num;
  gtk_widget_show(info->colorseldlg);
};

void fillstate_pref_colorsel_ok(GtkWidget *button,
				struct fillstate_prefinfo *info)
{
  GtkWidget *but;
  GdkColor *col;
  GdkColormap *cmap;
  gdouble colar[3];
  cmap=gdk_colormap_get_system();
  but=g_list_nth_data(g_list_first(gtk_container_children(GTK_CONTAINER(info->box))),info->colorselforbutton);
  col=g_list_nth_data(info->colors,info->colorselforbutton);
  gtk_color_selection_get_color(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(info->colorseldlg)->colorsel),colar);
  col->red=colar[0]*65535.0;
  col->green=colar[1]*65535.0;
  col->blue=colar[2]*65535.0;
  gdk_color_alloc(cmap,col);
  gtk_widget_hide(info->colorseldlg);
  fillstate_pref_dosetcolor(but,col);
};

void fillstate_pref_colorsel_cancel(GtkWidget *button,
				struct fillstate_prefinfo *info)
{
  gtk_widget_hide(info->colorseldlg);
};

int fillstate_pref_colorsel_delete(GtkWidget *colorseldlg,
				   GdkEvent *evnt,
				   struct fillstate_prefinfo *info)
{
  gtk_widget_hide(info->colorseldlg);
  return TRUE; /* wanna keep the window */
};


/* creates a button filled with the colour and assigned all the standard callbacks */
GtkWidget* fillstate_pref_button_new(GdkColor *col,
				     struct fillstate_prefinfo *info)
{
  GtkWidget *button;
  GtkWidget *gpix; /*GTKPIXMAP*/
  GdkPixmap *pix;
  pix=gdk_pixmap_new(window->window,16,16,-1);
  gpix=(gtk_pixmap_new(pix,NULL));
  button=(gtk_button_new());
  gtk_container_add(GTK_CONTAINER(button),GTK_WIDGET(gpix));
  fillstate_pref_dosetcolor(button,col);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",
		     (GtkSignalFunc)fillstate_pref_setcolor,info);
  gtk_widget_add_events(GTK_WIDGET(button),
			GDK_BUTTON_PRESS);
  gtk_signal_connect(GTK_OBJECT(button),"button-press-event",
		     (GtkSignalFunc)fillstate_pref_button_click,info);
  return GTK_WIDGET(button);
};

void fillstate_pref_addcolor(GtkWidget *addbutton,
			     struct fillstate_prefinfo *info)
{
  GtkWidget* button;
  GdkColor* color;
  GdkColormap *cmap;
  color=malloc(sizeof(GdkColor));
  color->red=65535;
  color->green=65535;
  color->blue=65535;
  cmap=gdk_colormap_get_system();
  gdk_color_alloc(cmap,color);
  info->colors=g_list_append(info->colors,color);
  button=fillstate_pref_button_new(color,info);
  gtk_box_pack_start(GTK_BOX(info->box),
		     GTK_WIDGET(button),
		     FALSE,FALSE,2);
  gtk_widget_show_all(GTK_WIDGET(button));
  fillstate_pref_setcolor(button,
			  info);
};
void fillstate_pref_parselist(char *colors,
			      struct fillstate_prefinfo *info)
/* Creates the colorlist from the specified string,
   overwrites old colorlist!*/
/* for  INIT & UNDO */
     /* r,g,b:r,g,b:r,g,b:r,g,b:... 
        COL1 : COL2:COL3 :COL4 */
{
  int r,g,b,n;
  GdkColormap *cmap;
  GdkColor *color;
  GtkWidget *button;
#ifdef DEBUG
  printf("Reading Colors...\n");
#endif
  /* empty the box first */
  while  ((gtk_container_children(GTK_CONTAINER(info->box)))
	  &&(gtk_container_children(GTK_CONTAINER(info->box))->data))
    gtk_container_remove(GTK_CONTAINER(info->box),
			 gtk_container_children(GTK_CONTAINER(info->box))->data);
  info->colors=g_list_first(info->colors);
  while (info->colors)
    {
      /*      if (info->colors->data)
	      gdk_color_free(info->colors->data);*/ /*this doesn't work??*/
      if (info->colors->data)
	free(info->colors->data);
      info->colors=g_list_remove_link(info->colors,info->colors);
    };
  do {
    n=sscanf(colors,"%i,%i,%i",&r,&g,&b);
    if (n==3)
      {
#ifdef DEBUG
	printf("Read Color %i/%i/%i\n",r,g,b);
#endif
	cmap=gdk_colormap_get_system();
	color=malloc(sizeof(GdkColor));
	color->red=r;
	color->green=g;
	color->blue=b;
	gdk_color_alloc(cmap,color);
	info->colors=g_list_append(info->colors,color);
	button=fillstate_pref_button_new(color,info);
	gtk_widget_show_all(button);
	gtk_box_pack_start(GTK_BOX(info->box),
			   GTK_WIDGET(button),
			   FALSE,FALSE,2);
      };
    while ((*colors!=0)&&(*colors!=':'))
      colors++;
    if (*colors==':') colors++;
  } while ((n==3)&&(*colors!=0));
};

void fillstate_pref_build_string(char *buf,struct fillstate_prefinfo *info)
{
  GList *colors;
  char sbuf[64];
#ifdef DEBUG
  printf("fillstate_pref_build_string %p,%p\n",buf,info);
#endif
  buf[0]=0;
  colors=info->colors;
  while (colors)
    {
#ifdef DEBUG
      printf("colors %p\n",colors);
#endif
      if (colors!=info->colors)
	strcat(buf,":");
      snprintf(sbuf,64,"%i,%i,%i",
	       ((GdkColor*)colors->data)->red,
	       ((GdkColor*)colors->data)->green,
	       ((GdkColor*)colors->data)->blue);
#ifdef DEBUG
      printf("-> !%s!",sbuf);
#endif
      strcat(buf,sbuf);
      colors=colors->next;
    };
#ifdef DEBUG
  printf("\n->%s\n",buf);
#endif
};

void fillstate_pref_apply(GtkWidget *widget,
			  struct fillstate_prefinfo *info)
{
  char buf[65535];
  GList *fcolors;
  GdkColor *cocopy;
#ifdef DEBUG
  printf("fillstate_pref_apply %p,%p\n",widget,info);
#endif
  fillstate_pref_build_string(buf,info);
  fcolors=info->fillstate->colors;
  while (fcolors)
    {
      free(fcolors->data);
          fcolors=g_list_remove_link(fcolors,fcolors);
    };
  info->fillstate->colors=NULL;
  fcolors=info->colors;
  while (fcolors)
    {
      cocopy=malloc(sizeof(GdkColor));
      memcpy(cocopy,fcolors->data,sizeof(GdkColor));
      info->fillstate->colors=g_list_append(info->fillstate->colors,
					    cocopy);
      fcolors=fcolors->next;
    };
  varman_setvar(global_defs,"fillstate_colors",buf);
  fillstate_updatehandler(info->fillstate);
};

void fillstate_pref_undo(GtkWidget *widget,
			 struct fillstate_prefinfo *info)
{
#ifdef DEBUG
  printf("fillstate_pref_undo : %p,%p,%s",widget,info,
	 varman_getvar(global_defs,"fillstate_colors"));
#endif
  fillstate_pref_parselist(varman_getvar(global_defs,"fillstate_colors"),
			   info);  
};

void fillstate_setup_preferences(struct fillstate_info *finfo)
{
  struct fillstate_prefinfo *info=malloc(sizeof(struct fillstate_prefinfo));
#ifdef DEBUG
  printf("fillstate_prefinfo @ %p\n",info);
#endif
  info->fillstate=finfo;
  info->frame=gtk_frame_new(_("Fillstate Setup"));
  info->vbox=gtk_vbox_new(FALSE,
			 2);
  info->themed=varmanwidgets_checkbox_new(_("Use Themes"),
					  "fillstate_themed",
					  global_defs,
					  APPLYMODE_BUTTON,
					  100,
					  "1",
					  "0");
  gtk_container_set_border_width(GTK_CONTAINER(info->frame),
				 2);
  gtk_container_add(GTK_CONTAINER(info->frame),info->vbox);
  gtk_box_pack_start(GTK_BOX(info->vbox),
		     info->themed->visual,
		     FALSE,FALSE,0);
  info->ebox=gtk_hbox_new(FALSE,2);
  gtk_box_pack_start(GTK_BOX(info->vbox),
		     info->ebox,
		     FALSE,FALSE,0);
  info->box=gtk_hbox_new(FALSE,2);
  gtk_box_pack_start(GTK_BOX(info->ebox),
		     info->box,
		     FALSE,FALSE,0);
  info->add=gtk_button_new_with_label(_("Add Color"));
  gtk_signal_connect(GTK_OBJECT(info->add),"clicked",
		     (GtkSignalFunc)fillstate_pref_addcolor,info);
  gtk_box_pack_start(GTK_BOX(info->ebox),
		     info->add,
		     FALSE,FALSE,0);
  info->colors=NULL;
  fillstate_pref_parselist(varman_getvar(global_defs,"fillstate_colors"),
			   info);  
  gtk_widget_show_all(info->frame);
  gtk_box_pack_start(GTK_BOX(preferences_common),
		     info->frame,
		     FALSE,FALSE,
		     0);
  info->colorseldlg=gtk_color_selection_dialog_new(_("Select Track Color"));
  gtk_widget_hide(GTK_WIDGET(GTK_COLOR_SELECTION_DIALOG(info->colorseldlg)->help_button));
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(info->colorseldlg)->ok_button),"clicked",
		     (GtkSignalFunc)fillstate_pref_colorsel_ok,info);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(info->colorseldlg)->cancel_button),"clicked",
		     (GtkSignalFunc)fillstate_pref_colorsel_cancel,info);     
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(info->colorseldlg)),"delete_event",
		     (GtkSignalFunc)fillstate_pref_colorsel_delete,info);     
  preferences_setapplyhandler(fillstate_pref_apply,info);
  preferences_setundohandler(fillstate_pref_undo,info);
  fillstate_pref_apply(NULL,info);
};

void fillstate_varchanged(VARMAN_VAR_ENTRY* var,
			  struct fillstate_info *info)
{
#ifdef DEBUG
  printf("fillstate_varchanged.\n");
#endif
  info->themed=varman_getvar_value(global_defs,"fillstate_themed");
  /*varman_getvar_value is rather expensive */
  fillstate_draw(info,
		 0,0,
		 info->xs,info->ys);
};

void fillstate_create()
{
  fillstate_bar=malloc(sizeof(struct fillstate_info));
  fillstate_bar->widget=gtk_drawing_area_new();
  fillstate_bar->xs=fillstate_bar->ys=-1;
  fillstate_bar->trackcount=0;

  fillstate_bar->themed=varman_getvar_value(global_defs,"fillstate_themed");
  /* the constant is coming from 74 Minutes at 44100*4 bytes per second */
  fillstate_bar->totsiz=FILLSTATE_BLANKSIZE;
  /* FIXME: get the cd size from record.c instead of assuming 
   * a standard blank */
  fillstate_bar->colors=NULL;
  fillstate_bar->font=fillstate_bar->widget->style->font;
   /* Attempt to load some other font if no font is provided by
    * the current widget style. Apparently, this helps some Japanese
    * folks whose fonts don't seem to be provided by some themes ?!? */
  if (!fillstate_bar->font)
     fillstate_bar->font=gdk_fontset_load("-misc-fixed-bold-r-normal-*-*-120-*-*-c-*-*");
  if (!fillstate_bar->font)
     fillstate_bar->font=gdk_fontset_load("fixed");
  gdk_font_ref(fillstate_bar->font);
  gtk_widget_show(fillstate_bar->widget);
  fillstate_bar->frame=gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(fillstate_bar->frame),
			    GTK_SHADOW_IN);
  gtk_container_set_border_width(GTK_CONTAINER(fillstate_bar->frame),
				 1);
  gtk_container_add(GTK_CONTAINER(fillstate_bar->frame),
		    fillstate_bar->widget);
  gtk_widget_show(fillstate_bar->frame);
  gtk_box_pack_start(GTK_BOX(downbox),
		     fillstate_bar->frame,
		     1,1,1);

  fillstate_setup_preferences(fillstate_bar);

  gtk_signal_connect(GTK_OBJECT(fillstate_bar->widget),"expose_event",
		     (GtkSignalFunc) fillstate_expose_event,fillstate_bar);
  gtk_signal_connect(GTK_OBJECT(fillstate_bar->widget),"configure_event",
		     (GtkSignalFunc) fillstate_configure_event,fillstate_bar);
  updatehandlers_register(&trackedit->updatehandlers,
			  (updatehandlers_handler)fillstate_updatehandler,
			  (gpointer)fillstate_bar);
  updatehandlers_register(&cddrives_drives.contentchange,
			  (updatehandlers_handler)fillstate_updatehandler,
			  (gpointer)fillstate_bar);
  varman_install_handler(global_defs,
			 "fillstate_themed",
			 (varman_varchanged)fillstate_varchanged,
			 (gpointer)fillstate_bar);
}
;
