/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "configure.h"
#include "diskfree.h"
#include "menus.h"
#include "interface.h"
#include "pixmap.h"

#include "icons/atr_window.xpm"

/* Signals */

gint capacity_resize_timeout = 0;

void
gui_capacity_column_resize_end (gpointer data)
{
	capacity_resize_timeout = 0;
	
	return;
}

gboolean
gui_capacity_column_resize_start (GtkTreeViewColumn *cl, gpointer data)
{
	if (!options->capacity_style[2])
		return FALSE;
	
	if (capacity_resize_timeout)
		gtk_timeout_remove(capacity_resize_timeout);
	capacity_resize_timeout = gtk_timeout_add_full(125,
						       (GtkFunction)gui_list_capacitys_redraw,
						       NULL,
						       NULL,
						       (GtkDestroyNotify)gui_capacity_column_resize_end);
	
	return FALSE;
}

gint
gui_list_column_get_position (GtkTreeViewColumn *column)
{
	gint i = 0;
	GList *columns_list = NULL;
	
	columns_list = gtk_tree_view_get_columns(GTK_TREE_VIEW(list_treeview));
	columns_list = g_list_first(columns_list);
	
	while (GTK_TREE_VIEW_COLUMN(columns_list->data) != column && i <= CAPACITY_COLUMN) {
		columns_list = columns_list->next;
		i++;
	}
	
	return i;
}

gint
gui_list_column_sort (GtkTreeModel *model, GtkTreeIter *a,
		      GtkTreeIter *b, gpointer data)
{
	gint ret = 1;
	gchar *str[2];
	
	
	gtk_tree_model_get(model, a, options->sort[0], &(str[0]), -1);
	gtk_tree_model_get(model, b, options->sort[0], &(str[1]), -1);
	
	if (strcmp(str[0], str[1]) > 0)
		ret = -1;
	
	g_free(str[0]);
	g_free(str[1]);
	
	return ret;
}

void
gui_list_column_clicked (GtkTreeViewColumn *column, gpointer user_data)
{
	options->sort[0] = gui_list_column_get_position(column);
	options->sort[1] = gtk_tree_view_column_get_sort_order(column);
	
	return;
}

void
gui_list_columns_disp_update (void)
{
	gint i = 0;
	GList *columns_list = NULL;
	
	columns_list = gtk_tree_view_get_columns(GTK_TREE_VIEW(list_treeview));
	columns_list = g_list_first(columns_list);
	
	while (columns_list != NULL && i < N_COLUMNS) {
		if (i > CAPACITY_COLUMN)
			gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(columns_list->data),
							 FALSE);
		else {
			if (options->show_columns[i] || options->show_columns_all)
				gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(columns_list->data),
								 TRUE);
			else
				gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(columns_list->data),
								 FALSE);
			if (options->clist_style[0])
				gtk_tree_view_column_set_sizing(GTK_TREE_VIEW_COLUMN(columns_list->data),
								GTK_TREE_VIEW_COLUMN_AUTOSIZE);
			else
				gtk_tree_view_column_set_sizing(GTK_TREE_VIEW_COLUMN(columns_list->data),
								GTK_TREE_VIEW_COLUMN_FIXED);
			if (options->clist_style[1])
				gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(columns_list->data),
								   TRUE);
			else
				gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(columns_list->data),
								   FALSE);
		}
		
		columns_list = columns_list->next;
		i++;
	}
	
	if (options->clist_style[2])
		gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(list_treeview), TRUE);
	else
		gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(list_treeview), FALSE);
	
	if (options->clist_style[3])
		gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(list_treeview), TRUE);
	else
		gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(list_treeview), FALSE);
	
	return;
}

void
gui_list_columns_init_sortway (void)
{
	GtkTreeViewColumn *column;
	
	column = gtk_tree_view_get_column(GTK_TREE_VIEW(list_treeview), options->sort[0]);
	gtk_tree_view_column_set_sort_indicator(column, TRUE);
	if (options->sort[1] == GTK_SORT_ASCENDING) {
		gtk_tree_view_column_set_sort_order(column, GTK_SORT_ASCENDING);
		gtk_tree_view_column_clicked(column);
	} else
		gtk_tree_view_column_set_sort_order(column, GTK_SORT_DESCENDING);
	gtk_tree_view_column_clicked(column);
	
	return;
}

void
gui_statusbar_timeout_update (GtkWidget *widget, order_t action)
{
	/* timeout is used by GTK+ to remember which function and when
           to call it, GTK+ use only > 0 values, here we use -1 value
           to know if there is a timeout. */
	static gint timeout = -1;
	static gfloat last_timeout = 0;
	
	switch (action) {
	case UPDATE:
		if (timeout < 0) {
			gui_list_main_update(GTK_TREE_VIEW(list_treeview));
			break;
		}
	case REFRESH:
		if (timeout > 0)
			gtk_timeout_remove(timeout);
		gui_list_main_update(GTK_TREE_VIEW(list_treeview));
		timeout = gtk_timeout_add((gint) (1000 * options->update_interval),
					  (GtkFunction)gui_list_main_update,
					  (gpointer)list_treeview);
		last_timeout = options->update_interval;
		gtk_statusbar_pop(GTK_STATUSBAR(status_bar_timeout), timeout_status);
		break;
	case STOP:
		gtk_timeout_remove(timeout);
		gtk_statusbar_pop(GTK_STATUSBAR(status_bar_timeout), timeout_status);
		gtk_statusbar_push(GTK_STATUSBAR(status_bar_timeout), timeout_status,
				   _(" Stopped..."));
		timeout = -1;
		break;
	default:
		break;
	}
	
	return;
}

gboolean
gui_statusbar_update_block (void)
{
	gtk_statusbar_pop(GTK_STATUSBAR(status_bar_block), block_size_status);
	
	switch (options->blocks[0]) {
	case GIGABYTE:
		gtk_statusbar_push(GTK_STATUSBAR(status_bar_block),
				   block_size_status, _(" Gigabytes"));    
		break;
	case MEGABYTE:
		gtk_statusbar_push(GTK_STATUSBAR(status_bar_block),
				   block_size_status, _(" Megabytes"));
		break;
	case KILOBYTE:
		gtk_statusbar_push(GTK_STATUSBAR(status_bar_block),
				   block_size_status, _(" Kilobytes"));
		break;
	default:
		options->blocks[0] = AUTOSIZE;
	case AUTOSIZE:
		gtk_statusbar_push(GTK_STATUSBAR(status_bar_block),
				   block_size_status, _(" Human readable"));
		break;
	}
	
	return TRUE;
}

void
gui_main_window_set_posize (void)
{
	if (gdk_screen_width() >= options->window_position[0] &&
	    gdk_screen_height() >= options->window_position[1] &&
	    (options->window_position[0] != -1 && options->window_position[1] != -1)) {
		gtk_window_move(GTK_WINDOW(mwindow_attr.mwindow),
				options->window_position[0],
				options->window_position[1]);
		gtk_window_resize(GTK_WINDOW(mwindow_attr.mwindow),
				  options->window_size[0],
				  options->window_size[1]);
	}
	
	return;
}

void
gui_main_window_disp_update (void)
{
	if (options->gui_style[0])
		gtk_widget_show(menu_handle_box);
	else 
		gtk_widget_hide(menu_handle_box);
	
	if (options->gui_style[1])
		gtk_widget_show(tool_handle_box);
	else
		gtk_widget_hide(tool_handle_box);
	
	if (options->gui_style[2])
		gtk_widget_show(status_hbox);
	else
		gtk_widget_hide(status_hbox);
	
	return;
}

void
gui_main_window_resize (void)
{
	if (!GTK_WIDGET_VISIBLE(mwindow_attr.mwindow))
		return;
	
	if (options->gui_style[3]) {
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(list_scroll),
					       GTK_POLICY_NEVER,
					       GTK_POLICY_NEVER);
		gtk_window_set_decorated(GTK_WINDOW(mwindow_attr.mwindow), TRUE);
		gtk_window_set_resizable(GTK_WINDOW(mwindow_attr.mwindow), FALSE);
	} else {
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(list_scroll),
					       GTK_POLICY_AUTOMATIC,
					       GTK_POLICY_AUTOMATIC);
		gtk_window_set_resizable(GTK_WINDOW(mwindow_attr.mwindow), TRUE);
	}
	
	return;
}

gboolean
gui_main_window_configure (GtkWidget *win, GdkEventConfigure *ev,
			   gpointer data)
{
	gint w = gdk_screen_width(), h = gdk_screen_height(), ret = FALSE;
	
	options->window_position[0] = ev->x;
	options->window_position[1] = ev->y;
	
	if (ev->width <= w)
		options->window_size[0] = ev->width;
	else {
		options->window_size[0] = w;
		ret = TRUE;
	}
	if (ev->height <= h)
		options->window_size[1] = ev->height;
	else {
		options->window_size[1] = h;
		ret = TRUE;
	}
	
	if (ret)
		gtk_window_resize(GTK_WINDOW(mwindow_attr.mwindow),
				  options->window_size[0],
				  options->window_size[1]);
	
	return FALSE;
}

void
gui_list_columns_create (GtkTreeView *list)
{
	gint i;
	gchar *titles[CAPACITY_COLUMN + 1] = {_("Filesystem"), _("Size"), _("Used space"),
					      _("Free space"), _("Used %"), _("Free %"),
					      _("Filesystem type"), _("Mount option's"),
					      _("Mount dir"), _("Capacity")};
	GtkCellRenderer *cell_renderer;
	GtkTreeViewColumn *column;
	
	/* We want to display text in our list, so cell will be
           text. */
	for (i = 0 ; i < CAPACITY_COLUMN ; i++) {
		cell_renderer = gtk_cell_renderer_text_new();
		column = gtk_tree_view_column_new_with_attributes(titles[i], cell_renderer,
								  "text", i, NULL);
		g_signal_connect(G_OBJECT(column), "clicked",
				 G_CALLBACK(gui_list_column_clicked), NULL);
		switch (i) {
		case SIZE_COLUMN:
			gtk_tree_view_column_set_sort_column_id(column, SIZEK_COLUMN);
			break;
		case USED_SPACE_COLUMN:
			gtk_tree_view_column_set_sort_column_id(column, USEDK_SPACE_COLUMN);
			break;
		case FREE_SPACE_COLUMN:
			gtk_tree_view_column_set_sort_column_id(column, FREEK_SPACE_COLUMN);
			break;
		case USED_PERCENT_COLUMN:
			gtk_tree_view_column_set_sort_column_id(column, USEDP_PERCENT_COLUMN);
			break;
		case FREE_PERCENT_COLUMN:
			gtk_tree_view_column_set_sort_column_id(column, FREEP_PERCENT_COLUMN);
			break;
		default:
			gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(list_treemodel), i,
							(GtkTreeIterCompareFunc)gui_list_column_sort,
							NULL, NULL);
			gtk_tree_view_column_set_sort_column_id(column, i);
			break;
		}
		gtk_tree_view_append_column(list, column);
	}
	
	/* Except last column which is a 'pixmap' or 'pixbuf'
	   column. */
	cell_renderer = gtk_cell_renderer_pixbuf_new();
	g_object_set(G_OBJECT(cell_renderer), "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes(titles[i], cell_renderer,
							  "pixbuf", i, NULL);
	gtk_tree_view_column_set_sort_column_id(column, USEDP_PERCENT_COLUMN);
	gtk_tree_view_append_column(list, column);
	g_signal_connect(G_OBJECT(column), "clicked",
			 G_CALLBACK(gui_list_column_clicked), NULL);
	g_signal_connect(G_OBJECT(column), "notify::width",
			 G_CALLBACK(gui_capacity_column_resize_start), NULL);
	
	return;
}

/* This function define the treeview wigdet we will use later in this
   apps */
GtkTreeModel *
gui_list_model_create (void)
{
	GtkListStore *store;
	GType list_types[N_COLUMNS] = {G_TYPE_STRING, // File
				       G_TYPE_STRING, // Size
				       G_TYPE_STRING, // Used space
				       G_TYPE_STRING, // Free space
				       G_TYPE_STRING, // Used percent
				       G_TYPE_STRING, // Free percent
				       G_TYPE_STRING, // FS type
				       G_TYPE_STRING, // Mount opts
				       G_TYPE_STRING, // Mount point
				       GDK_TYPE_PIXBUF, // Capacity
				       
				       G_TYPE_ULONG,   // Size in Kb (used to sort)
				       G_TYPE_ULONG,   // Used space in Kb (used to sort)
				       G_TYPE_ULONG,   // Free space in Kb (used to sort)
				       G_TYPE_INT,    // Used percent
				       G_TYPE_INT,    // Free percent
				       G_TYPE_INT     // Status
	};
	
	store = gtk_list_store_newv(N_COLUMNS, list_types);
	
	return GTK_TREE_MODEL(store);
}

/* This function create & show the main window, we display the list
   into it. */
void
gui_main_window_create (void)
{
	GdkDrawable *icon_pixmap;
	GdkDrawable *icon_mask;
	GtkWidget *main_box, *menu_box;
	
	GtkTreeSelection *selection;
       	GtkStyle *style;
	
	GtkWidget *status_table, *status_bar;
	
	/*--MainWindow--*/
	mwindow_attr.mwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(mwindow_attr.mwindow), "gtkdiskfree");
	g_signal_connect(G_OBJECT(mwindow_attr.mwindow), "destroy",
			 G_CALLBACK(gtk_main_quit), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(mwindow_attr.mwindow), 0);
	gtk_widget_realize(mwindow_attr.mwindow);
	icon_pixmap = gdk_pixmap_create_from_xpm_d(mwindow_attr.mwindow->window,
						   &icon_mask,
						   &mwindow_attr.mwindow->style->bg[GTK_STATE_NORMAL],
						   atr_window_xpm);
	gdk_window_set_icon(mwindow_attr.mwindow->window, NULL, icon_pixmap, icon_mask);
	gdk_window_set_icon_name(mwindow_attr.mwindow->window, "GtkDiskFree");
	mwindow_attr.colorboard = gdk_drawable_get_colormap(mwindow_attr.mwindow->window);
	style = gtk_widget_get_default_style();
	mwindow_attr.font = gtk_style_get_font(style);
	
	main_box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(mwindow_attr.mwindow), main_box);
	gtk_widget_show(main_box);
	
	/*--MenuBar & ToolBar--*/
	menu_box = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(main_box), menu_box, FALSE, FALSE, 0);
	gtk_widget_show(menu_box);
	
	gui_main_menu_create(menu_box);
	gui_toolbar_create(menu_box);
	
	/*--List--*/
	list_box = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start_defaults(GTK_BOX(main_box), list_box);
	gtk_container_set_border_width(GTK_CONTAINER(list_box), 0);
	gtk_widget_show(list_box);
	
	list_scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(list_scroll),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(list_box), list_scroll, TRUE, TRUE, 0);
	gtk_widget_show(list_scroll);
	
	/* We get the model from the function we did before. */
	list_treemodel = gui_list_model_create();
	
	/* We create the widget from the model. */
 	list_treeview = gtk_tree_view_new_with_model(list_treemodel);
	g_object_unref(G_OBJECT(list_treemodel));
	
	/* GtkTreeView config */
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(list_treeview));
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);
	gtk_tree_view_set_reorderable(GTK_TREE_VIEW(list_treeview), FALSE);
	gtk_container_add(GTK_CONTAINER(list_scroll), list_treeview);
	
	/* We need to create & defined cells (title and others). */
	gui_list_columns_create(GTK_TREE_VIEW(list_treeview));
	
	/* Signals */
	g_signal_connect(G_OBJECT(list_treeview), "button-press-event",
			 G_CALLBACK(gui_popup_menu_signal), NULL);
	gtk_widget_show_all(list_treeview);
	
	/*--StatusBar--*/
	
	status_hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(main_box), status_hbox, FALSE, FALSE, 0);
	gtk_widget_show(status_hbox);
	
	status_table = gtk_table_new(1, 5, TRUE);
	gtk_box_pack_start_defaults(GTK_BOX(status_hbox), status_table);
	gtk_widget_show(status_table);
	
	status_bar = gtk_statusbar_new();
	gtk_statusbar_set_has_resize_grip(GTK_STATUSBAR(status_bar), FALSE);
	gtk_table_attach(GTK_TABLE(status_table), status_bar, 0, 3, 0, 1,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
	gtk_widget_show(status_bar);
	  
	status_bar_timeout = gtk_statusbar_new();
	gtk_statusbar_set_has_resize_grip(GTK_STATUSBAR(status_bar_timeout), FALSE);
	gtk_table_attach(GTK_TABLE(status_table), status_bar_timeout, 3, 4, 0, 1,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
	gtk_widget_show(status_bar_timeout);
	timeout_status = gtk_statusbar_get_context_id(GTK_STATUSBAR(status_bar_timeout),
						      "Program status");
	status_bar_block = gtk_statusbar_new();
	gtk_statusbar_set_has_resize_grip(GTK_STATUSBAR(status_bar_block), FALSE);
	gtk_table_attach(GTK_TABLE(status_table), status_bar_block, 4, 5, 0, 1,
			 GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
	gtk_widget_show(status_bar_block);
	block_size_status = gtk_statusbar_get_context_id(GTK_STATUSBAR(status_bar_block),
							 "Blocks size status");
	gtk_widget_show(status_hbox);
	gui_statusbar_update_block();
	
	/*-------*/
	gtk_widget_show(mwindow_attr.mwindow);
	
	gui_main_window_disp_update();
	gui_list_columns_disp_update();
	gui_list_columns_init_sortway();
	
	gui_main_window_set_posize();
	gui_main_window_resize();
	
	g_signal_connect(G_OBJECT(mwindow_attr.mwindow), "configure-event",
			 G_CALLBACK(gui_main_window_configure), NULL);
	
	return;
}
