import sys
from common import gst, unittest

class BufferTest(unittest.TestCase):
    def testBufferBuffer(self):
        buf = gst.Buffer('test')
        assert str(buffer(buf)) == 'test'

    def testBufferStr(self):
        buffer = gst.Buffer('test')
        assert str(buffer) == 'test'
        
    def testBufferBadConstructor(self):
        self.assertRaises(TypeError, gst.Buffer, 'test', 0)
        
    def testBufferStrNull(self):
        test_string = 't\0e\0s\0t\0'
        buffer = gst.Buffer(test_string)
        assert str(buffer) == test_string

    def testBufferSize(self):
        test_string = 'a little string'
        buffer = gst.Buffer(test_string)
        assert len(buffer) == len(test_string)
        #assert hasattr(buffer, 'size')
        #assert buffer.size == len(buffer)
        
    def testBufferMaxSize(self):
        buffer = gst.Buffer(buffer_size=16)
        assert hasattr(buffer, 'maxsize')
        assert buffer.maxsize == 16

    def testBufferCreateSub(self):
        s = ''
        for i in range(64):
            s += '%02d' % i
            
        buffer = gst.Buffer(s)
        assert len(buffer) == 128

        sub = buffer.create_sub(16, 16)
        assert sub.maxsize == 16
        assert sub.offset == -1, sub.offset

    def testBufferMerge(self):
        buffer1 = gst.Buffer('foo')
        buffer2 = gst.Buffer('bar')

        merged_buffer = buffer1.merge(buffer2)
        assert str(merged_buffer) == 'foobar'
        
    def testBufferJoin(self):
        buffer1 = gst.Buffer('foo')
        buffer2 = gst.Buffer('bar')

        joined_buffer = buffer1.merge(buffer2)
        assert str(joined_buffer) == 'foobar'
        
    def testBufferSpan(self):
        buffer1 = gst.Buffer('foo')
        buffer2 = gst.Buffer('bar')

        spaned_buffer = buffer1.span(0L, buffer2, 6L)
        assert str(spaned_buffer) == 'foobar'

    def testBufferFlagIsSet(self):
        buffer = gst.Buffer()
        # Off by default
        assert not buffer.flag_is_set(gst.BUFFER_READONLY)

        # Try switching on and off
        buffer.flag_set(gst.BUFFER_READONLY)
        assert buffer.flag_is_set(gst.BUFFER_READONLY)
        buffer.flag_unset(gst.BUFFER_READONLY)
        assert not buffer.flag_is_set(gst.BUFFER_READONLY)

        # Try switching on and off
        buffer.flag_set(gst.BUFFER_IN_CAPS)
        assert buffer.flag_is_set(gst.BUFFER_IN_CAPS)
        buffer.flag_unset(gst.BUFFER_IN_CAPS)
        assert not buffer.flag_is_set(gst.BUFFER_IN_CAPS)

if __name__ == "__main__":
    unittest.main()
