/***************************************************************************
                          mysql.c  -  description
                             -------------------
    begin                : Sat Jul 8 2000
    copyright            : (C) 2000 by Calum Grant
    email                : calum@envisional.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <mysql.h>
#include <stdio.h>
#include <gprolog.h>
        
static MYSQL *mysql=0;
static MYSQL_RES *res=0; 
        
                
//      
// NAME
// sql_disconnect
//
// DESCRIPTION
// Disconnect from the database
//      
// RETURNS
// TRUE always  
//              
                
Bool sql_disconnect( void )
{
  if(mysql != NULL )
    {
      mysql_close(mysql);
    }
  return TRUE;
}


//
// NAME
// sql_connect
//
// DESCRIPTION
// Called from GNU Prolog to establish a connection to a MySQL database.
//
// RETURNS
// TRUE on success, or FALSE on failure.
//

Bool sql_connect(char *host, char *user, char *password, char *db)
{
  // Close the existing connection

  if(mysql != NULL)
    {
      mysql_close(mysql);
    }

  // Initialize the mysql object

  mysql = mysql_init(0);

  if(!mysql)
    {
      // Failed to initialize
      Pl_Err_System(Create_Atom("mysql_init_failure"));
      return FALSE;
    }

  // Connect to the server

  if(!mysql_real_connect(mysql, host, user, password, db, 0, 0, 0))
    {
      // Failed to connect
      Pl_Err_System(Create_Atom("mysql_connect_failure"));
      return FALSE;
    }
  
  // Connection established
        
  return TRUE;
}


// 
// NAME 
// sql_query
//
// DESCRIPTION
// A non-deternimistic predicate that returns successive rows from the database.
//      
// RETURNS
// A row from the database in result.
//      
                
Bool sql_query(char *query, PlTerm result)
{
  MYSQL_ROW row;

  // Check that we have done a sql_connect/4

  if(!mysql)
    {
      No_More_Choice();
      Pl_Err_System(Create_Atom("mysql_not_connected"));
      return FALSE;
    }

  if(Get_Choice_Counter()==0)
    {
#ifdef ADWDEBUG
      printf("MYSQL-First call!\n");
#endif
      // This is the first invocation, so actually query MySQL

      // Eat up previous results

      while(res && mysql_fetch_row(res))
	{
	  // Eat up old results
	}

      // Free the previous result

      if(res)
	{
	  mysql_free_result(res);
	  res = NULL;
	}

      // Issue the query to MySQL

      if(mysql_query(mysql, query))
	{
	  No_More_Choice();
	  Emit_Syntax_Error("SQL error", 1, 1, mysql_error(mysql));
	  return FALSE;
	}

      res = mysql_use_result(mysql);
    }

#ifdef ADWDEBUG
  printf("MYSQL-Fetching a record\n");
#endif
  row = res ? mysql_fetch_row(res) : NULL;

  if(row)
    {
      int fields = mysql_num_fields(res);
      PlTerm list[50];
      int i;
                
      if(fields<0) fields=0;
                
      for(i=0; i<fields; i++)
        {       
#ifdef ADWDEBUG 
	  printf("MYSQL-Field #%d building\n",i);
	  printf("list[0] before: %ld\n", list[0]);
	  printf("MYSQL-Row: %s\n", row[i]);
#endif          
	  /* int null = Create_Atom("null"); */
	  list[i] = row[i] ? Mk_Codes(row[i]) : Create_Allocate_Atom("null");
        }       
                        
#ifdef ADWDEBUG         
      printf("list[0] after: %ld\n", list[0]);
      printf("MYSQL-Unifying result\n");
      printf("MYSQL-LIST contains %d fields\n", fields);
#endif
      /* Check_For_Un_Variable( *result ); */
                
      return Unify(result, Mk_Proper_List( fields, list));
    }                     
  else          
    {
#ifdef ADWDEBUG
      printf("MYSQL-No more choices\n");
#endif
      // There are no more results from MySQL
      No_More_Choice();
      //Un_List_Check(0, *result);    

      return res == NULL;
    }
}       

//
// NAME
// sql_store_query
//
// DESCRIPTION
// Fetches the entire results set of the query, and outputs it to result
//
// RETURNS
// FALSE if there was a syntax error
//

Bool sql_store_query(char *query, PlTerm result)
{
  // Free up the old result

  while(res && mysql_fetch_row(res))
    {
      // Eat up old results
    }

  // Free the previous result

  if(res)
    {
      mysql_free_result(res);
      res = NULL;
    }

  // Issue the query

  if(mysql_query(mysql, query))
    {
      Emit_Syntax_Error("SQL error", 1, 1, mysql_error(mysql));
      return FALSE;
    }

  res = mysql_store_result(mysql);

  if(res)
    {
      // Construct the resulting term
                
      int numRows = mysql_num_rows(res);
      int numFields = mysql_num_fields(res);
      int rowNum;
  
      PlTerm row[numFields];
      PlTerm allRows[numRows];
  
      for(rowNum=0; rowNum<numRows; rowNum++)
	{
	  MYSQL_ROW r = mysql_fetch_row(res);
	  int i;

	  for(i=0; i<numFields; i++)
	    {
	      int null = Create_Atom("null");
	      row[i] = r[i] ? Mk_Codes(r[i]) : Mk_Atom(null);
	    }
                        
	  allRows[rowNum] = Mk_Proper_List(numFields, row);
	}
         
      // Free the sql results
                
      mysql_free_result(res);
      res = NULL;
                 
                // Return the result
                
      return Un_Proper_List_Check(numRows, allRows, result);
    }       
  else    
    {
      // Return an empty results set
      return Un_List_Check(0, result);

    }
}

