indexing

	description:

		"Eiffel preparsers"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/10/21 16:39:51 $"
	revision: "$Revision: 1.12 $"

class ET_EIFFEL_PREPARSER

inherit

	ET_EIFFEL_PREPARSER_SKELETON

creation

	make, make_with_factory

feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (INITIAL <= sc and sc <= VS3)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
			yy_acclist ?= yy_acclist_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 60 then
if yy_act <= 30 then
if yy_act <= 15 then
if yy_act <= 8 then
if yy_act <= 4 then
if yy_act <= 2 then
if yy_act = 1 then
yy_set_line_column
--|#line 32 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 32")
end

			
else
	yy_column := yy_column + 1
--|#line 33 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 33")
end

			
end
else
if yy_act = 3 then
	yy_column := yy_column + 2
--|#line 34 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 34")
end

			
else
	yy_column := yy_column + 5
--|#line 39 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 39")
end

			
end
end
else
if yy_act <= 6 then
if yy_act = 5 then
	yy_column := yy_column + 5
--|#line 40 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 40")
end

			
else
	yy_column := yy_column + 3
--|#line 41 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 41")
end

			
end
else
if yy_act = 7 then
	yy_column := yy_column + 3
--|#line 42 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 42")
end

			
else
	yy_column := yy_column + 2
--|#line 43 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 43")
end

			
end
end
end
else
if yy_act <= 12 then
if yy_act <= 10 then
if yy_act = 9 then
	yy_column := yy_column + 5
--|#line 44 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 44")
end

			
else
	yy_column := yy_column + 8
--|#line 45 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 45")
end

			
end
else
if yy_act = 11 then
	yy_column := yy_column + 7
--|#line 46 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 46")
end

			
else
	yy_column := yy_column + 5
--|#line 47 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 47")
end

			
end
end
else
if yy_act <= 14 then
if yy_act = 13 then
	yy_column := yy_column + 8
--|#line 48 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 48")
end

			
else
	yy_column := yy_column + 2
--|#line 49 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 49")
end

			
end
else
	yy_column := yy_column + 4
--|#line 50 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 50")
end

			
end
end
end
else
if yy_act <= 23 then
if yy_act <= 19 then
if yy_act <= 17 then
if yy_act = 16 then
	yy_column := yy_column + 6
--|#line 51 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 51")
end

			
else
	yy_column := yy_column + 3
--|#line 52 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 52")
end

			
end
else
if yy_act = 18 then
	yy_column := yy_column + 6
--|#line 53 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 53")
end

			
else
	yy_column := yy_column + 8
--|#line 54 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 54")
end

			
end
end
else
if yy_act <= 21 then
if yy_act = 20 then
	yy_column := yy_column + 6
--|#line 55 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 55")
end

			
else
	yy_column := yy_column + 8
--|#line 56 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 56")
end

			
end
else
if yy_act = 22 then
	yy_column := yy_column + 5
--|#line 57 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 57")
end

			
else
	yy_column := yy_column + 7
--|#line 58 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 58")
end

			
end
end
end
else
if yy_act <= 27 then
if yy_act <= 25 then
if yy_act = 24 then
	yy_column := yy_column + 4
--|#line 59 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 59")
end

			
else
	yy_column := yy_column + 6
--|#line 60 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 60")
end

			
end
else
if yy_act = 26 then
	yy_column := yy_column + 2
--|#line 61 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 61")
end

			
else
	yy_column := yy_column + 7
--|#line 62 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 62")
end

			
end
end
else
if yy_act <= 29 then
if yy_act = 28 then
	yy_column := yy_column + 8
--|#line 63 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 63")
end

			
else
	yy_column := yy_column + 5
--|#line 64 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 64")
end

			
end
else
	yy_column := yy_column + 7
--|#line 65 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 65")
end

			
end
end
end
end
else
if yy_act <= 45 then
if yy_act <= 38 then
if yy_act <= 34 then
if yy_act <= 32 then
if yy_act = 31 then
	yy_column := yy_column + 7
--|#line 66 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 66")
end

			
else
	yy_column := yy_column + 9
--|#line 67 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 67")
end

			
end
else
if yy_act = 33 then
	yy_column := yy_column + 2
--|#line 68 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 68")
end

			
else
	yy_column := yy_column + 4
--|#line 69 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 69")
end

			
end
end
else
if yy_act <= 36 then
if yy_act = 35 then
	yy_column := yy_column + 5
--|#line 70 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 70")
end

			
else
	yy_column := yy_column + 4
--|#line 71 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 71")
end

			
end
else
if yy_act = 37 then
	yy_column := yy_column + 3
--|#line 72 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 72")
end

			
else
	yy_column := yy_column + 8
--|#line 73 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 73")
end

			
end
end
end
else
if yy_act <= 42 then
if yy_act <= 40 then
if yy_act = 39 then
	yy_column := yy_column + 3
--|#line 74 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 74")
end

			
else
	yy_column := yy_column + 4
--|#line 75 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 75")
end

			
end
else
if yy_act = 41 then
	yy_column := yy_column + 2
--|#line 76 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 76")
end

			
else
	yy_column := yy_column + 9
--|#line 77 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 77")
end

			
end
end
else
if yy_act <= 44 then
if yy_act = 43 then
	yy_column := yy_column + 6
--|#line 78 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 78")
end

			
else
	yy_column := yy_column + 8
--|#line 79 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 79")
end

			
end
else
	yy_column := yy_column + 6
--|#line 80 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 80")
end

			
end
end
end
else
if yy_act <= 53 then
if yy_act <= 49 then
if yy_act <= 47 then
if yy_act = 46 then
	yy_column := yy_column + 7
--|#line 81 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 81")
end

			
else
	yy_column := yy_column + 6
--|#line 82 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 82")
end

			
end
else
if yy_act = 48 then
	yy_column := yy_column + 6
--|#line 83 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 83")
end

			
else
	yy_column := yy_column + 5
--|#line 84 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 84")
end

			
end
end
else
if yy_act <= 51 then
if yy_act = 50 then
	yy_column := yy_column + 6
--|#line 85 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 85")
end

			
else
	yy_column := yy_column + 8
--|#line 86 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 86")
end

			
end
else
if yy_act = 52 then
	yy_column := yy_column + 5
--|#line 87 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 87")
end

			
else
	yy_column := yy_column + 4
--|#line 88 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 88")
end

			
end
end
end
else
if yy_act <= 57 then
if yy_act <= 55 then
if yy_act = 54 then
	yy_column := yy_column + 4
--|#line 89 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 89")
end

			
else
	yy_column := yy_column + 8
--|#line 90 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 90")
end

			
end
else
if yy_act = 56 then
	yy_column := yy_column + 6
--|#line 91 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 91")
end

			
else
	yy_column := yy_column + 5
--|#line 92 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 92")
end

			
end
end
else
if yy_act <= 59 then
if yy_act = 58 then
	yy_column := yy_column + 7
--|#line 93 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 93")
end

			
else
	yy_column := yy_column + 4
--|#line 94 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 94")
end

			
end
else
	yy_column := yy_column + 3
--|#line 95 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 95")
end

			
end
end
end
end
end
else
if yy_act <= 90 then
if yy_act <= 75 then
if yy_act <= 68 then
if yy_act <= 64 then
if yy_act <= 62 then
if yy_act = 61 then
	yy_column := yy_column + 5
--|#line 97 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 97")
end

				class_keyword_found := True
			
else
	yy_column := yy_column + 6
--|#line 100 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 100")
end

				if use_assign_keyword then
					-- Do nothing.
				elseif class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := 6
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
end
else
if yy_act = 63 then
	yy_column := yy_column + 9
--|#line 112 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 112")
end

				if use_attribute_keyword then
					-- Do nothing.
				elseif class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := 6
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
else
	yy_column := yy_column + 7
--|#line 124 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 124")
end

				if use_convert_keyword then
					-- Do nothing.
				elseif class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := 6
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
end
end
else
if yy_act <= 66 then
if yy_act = 65 then
	yy_column := yy_column + 6
--|#line 136 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 136")
end

				if use_create_keyword then
					-- Do nothing.
				elseif class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := 6
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
else
	yy_column := yy_column + 6
--|#line 148 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 148")
end

				if use_recast_keyword then
					-- Do nothing.
				elseif class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := 6
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
end
else
if yy_act = 67 then
	yy_column := yy_column + 9
--|#line 160 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 160")
end

				if use_reference_keyword then
					-- Do nothing.
				elseif class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := 9
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 176 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 176")
end

				if class_keyword_found then
					last_token := E_IDENTIFIER
					last_literal_start := 1
					last_literal_end := text_count
					last_break_end := 0
					last_comment_end := 0
					last_classname := ast_factory.new_identifier (Current)
				end
			
end
end
end
else
if yy_act <= 72 then
if yy_act <= 70 then
if yy_act = 69 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 190 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 190")
end

			
else
	yy_column := yy_column + 3
--|#line 199 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 199")
end

			
end
else
if yy_act = 71 then
	yy_column := yy_column + 4
--|#line 200 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 200")
end

			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 201 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 201")
end

			
end
end
else
if yy_act <= 74 then
if yy_act = 73 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 204 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 204")
end

					-- Syntax error: missing character / at end
					-- of special character specification %/code/.
				column := column + text_count
				error_handler.report_SCAS_error (filename, current_position)
				column := column - text_count
				last_token := E_CHARERR
			
else
	yy_column := yy_column + 3
--|#line 212 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 212")
end

					-- Syntax error: missing ASCII code in
					-- special character specification %/code/.
				column := column + 3
				error_handler.report_SCAC_error (filename, current_position)
				column := column - 3
				last_token := E_CHARERR
			
end
else
	yy_column := yy_column + 2
--|#line 220 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 220")
end

					-- Syntax error: missing character between quotes.
				column := column + 1
				error_handler.report_SCQQ_error (filename, current_position)
				column := column - 1
				last_token := E_CHARERR
			
end
end
end
else
if yy_act <= 83 then
if yy_act <= 79 then
if yy_act <= 77 then
if yy_act = 76 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 227 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 227")
end

					-- Syntax error: missing quote at
					-- end of character constant.
				column := column + text_count
				error_handler.report_SCEQ_error (filename, current_position)
				column := column - text_count
				last_token := E_CHARERR
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 239 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 239")
end

			
end
else
if yy_act = 78 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 242 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 242")
end

					-- Verbatim string.
				verbatim_marker := text_substring (2, text_count - 1)
				set_start_condition (VS1)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 250 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 250")
end

				last_literal_start := 1
				last_literal_end := 0
				set_start_condition (VS2)
			
end
end
else
if yy_act <= 81 then
if yy_act = 80 then
	yy_column := yy_column + 1
--|#line 255 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 255")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 269 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 269")
end

				if is_verbatim_string_closer (last_literal_end + 1, text_count - 1) then
					verbatim_marker := Void
					set_start_condition (INITIAL)
				else
					more
					set_start_condition (VS3)
				end
			
end
else
if yy_act = 82 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 278 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 278")
end

				more
				set_start_condition (VS3)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 282 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 282")
end

				more
				last_literal_end := text_count - 2
			
end
end
end
else
if yy_act <= 87 then
if yy_act <= 85 then
if yy_act = 84 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 286 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 286")
end

				more
				last_literal_end := text_count - 1
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 290 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 290")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
else
if yy_act = 86 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 304 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 304")
end

				more
				last_literal_end := text_count - 2
				set_start_condition (VS2)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 309 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 309")
end

				more
				last_literal_end := text_count - 1
				set_start_condition (VS2)
			
end
end
else
if yy_act <= 89 then
if yy_act = 88 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 314 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 314")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 326 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 326")
end

					-- Manifest string with special characters.
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 329 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 329")
end

					-- Manifest string with special characters which may be made
					-- up of several lines or may include invalid characters.
					-- Keep track of current line and column.
				ms_line := line
				ms_column := column
				more
				set_start_condition (MS)
			
end
end
end
end
else
if yy_act <= 105 then
if yy_act <= 98 then
if yy_act <= 94 then
if yy_act <= 92 then
if yy_act = 91 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 340 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 340")
end

					-- Multi-line manifest string.
				more
				set_start_condition (MSN)
			
else
	yy_end := yy_start + yy_more_len + 2
	yy_column := yy_column + 2
--|#line 345 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 345")
end

					-- Multi-line manifest string.

					-- Syntax error: no space allowed after character
					-- % at end of line in multi-line manifest strings.
				column := yy_column - 1
				line := yy_line
--				error_handler.report_SSNS_error (filename, current_position)
				column := ms_column
				line := ms_line

				more
				set_start_condition (MSN1)
			
end
else
if yy_act = 93 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 359 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 359")
end

				more
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 362 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 362")
end

					-- Syntax error: missing character / at end of special
					-- character specification %/code/ in manifest string.
				column := yy_column
				line := yy_line
--				error_handler.report_SSAS_error (filename, current_position)
				column := ms_column
				line := ms_line

				more
			
end
end
else
if yy_act <= 96 then
if yy_act = 95 then
	yy_column := yy_column + 2
--|#line 373 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 373")
end

					-- Syntax error: missing ASCII code in special character
					-- specification %/code/ in manifest string.
				column := yy_column
				line := yy_line
--				error_handler.report_SSAC_error (filename, current_position)
				column := ms_column
				line := ms_line

				more
			
else
	yy_column := yy_column + 2
--|#line 384 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 384")
end

					-- Syntax error: special character specification
					-- %l where l is a letter code should be in
					-- upper-case in manifest strings.
				column := yy_column - 1
				line := yy_line
--				error_handler.report_SSCU_error (filename, current_position)
				column := ms_column
				line := ms_line

				more
			
end
else
if yy_act = 97 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 396 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 396")
end

				more
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 399 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 399")
end

				set_start_condition (INITIAL)
			
end
end
end
else
if yy_act <= 102 then
if yy_act <= 100 then
if yy_act = 99 then
	yy_column := yy_column + 2
--|#line 402 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 402")
end

					-- Syntax error: Invalid special character
					-- in manifest strings.
				column := yy_column - 1
				line := yy_line
--				error_handler.report_SSSC_error (filename, current_position)
				column := ms_column
				line := ms_line

				more
			
else
	yy_column := yy_column + 1
--|#line 413 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 413")
end

					-- Syntax error: invalid special character
					-- %l in manifest strings.
				column := yy_column
				line := yy_line
				error_handler.report_SSSC_error (filename, current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
else
if yy_act = 101 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 425 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 425")
end

					-- Syntax error: Invalid new-line in manifest string.
				column := 1
				line := yy_line
				error_handler.report_SSNL_error (filename, current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 451 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 451")
end

				more
				set_start_condition (MSN)
			
end
end
else
if yy_act <= 104 then
if yy_act = 103 then
	yy_column := yy_column + 1
--|#line 455 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 455")
end

					-- Should never happen.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 468 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 468")
end

				more
				set_start_condition (MS)
			
end
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 472 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 472")
end

					-- Syntax error: empty line in middle of
					-- multi-line manifest string.
				column := 1
				line := yy_line - 1
--				error_handler.report_SSEL_error (filename, current_position)
				column := ms_column
				line := ms_line

				more
			
end
end
end
else
if yy_act <= 112 then
if yy_act <= 109 then
if yy_act <= 107 then
if yy_act = 106 then
	yy_column := yy_column + 1
--|#line 483 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 483")
end

					-- Syntax error: missing character % at beginning
					-- of line in multi-line manifest string.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSNP_error (filename, current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 512 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 512")
end

			
end
else
if yy_act = 108 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 518 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 518")
end

			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 520 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 520")
end

			
end
end
else
if yy_act <= 111 then
if yy_act = 110 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 522 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 522")
end

					-- Syntax error: an underscore may not be
					-- the first character of an integer.
				error_handler.report_SIFU_error (filename, current_position)

				last_token := E_INTERR
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 529 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 529")
end

					-- Syntax error: an underscore must be followed
					-- by three digits and there must not be any
					-- consecutive group of four digits.
				error_handler.report_SITD_error (filename, current_position)

				last_token := E_INTERR
			
end
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 541 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 541")
end

			
end
end
else
if yy_act <= 116 then
if yy_act <= 114 then
if yy_act = 113 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 542 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 542")
end

			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 543 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 543")
end

			
end
else
if yy_act = 115 then
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 545 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 545")
end

			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 546 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 546")
end

			
end
end
else
if yy_act <= 118 then
if yy_act = 117 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 547 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 547")
end

			
else
	yy_column := yy_column + 1
--|#line 557 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 557")
end

				last_token := E_UNKNOWN
			
end
else
yy_set_line_column
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end
last_token := yyError_token
fatal_error ("scanner jammed")
end
end
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			inspect yy_sc
when 0 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end
terminate
when 1 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end

					-- Syntax error: missing double quote at
					-- end of manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSEQ_error (filename, current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 2 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end

					-- Syntax error: missing character % at beginning
					-- of line in multi-line manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSNP_error (filename, current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 3 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end

					-- Should never happen.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 4 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 5 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 6 then
--|#line 0 "et_eiffel_preparser.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_preparser.l' at line 0")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
			else
				terminate
			end
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,   16,   17,   18,   17,   19,   20,   21,   16,   22,
			   19,   19,   23,   24,   25,   26,   27,   28,   29,   19,
			   30,   31,   32,   33,   34,   35,   36,   37,   33,   33,
			   38,   33,   33,   39,   33,   40,   41,   42,   33,   43,
			   44,   45,   46,   47,   48,   49,   33,   33,   19,   50,
			   19,   51,   32,   33,   34,   35,   37,   33,   39,   40,
			   33,   43,   44,   45,   46,   47,   53,   53,  375,   54,
			   54,   55,   55,   57,   58,   57,   57,   58,   57,   59,
			   73,   74,   59,   61,   62,   61,   61,   62,   61,   64,
			   65,   64,   64,   65,   64,   67,   68,   69,   86,   70,

			   67,   68,   69,   86,   70,   73,   74,   75,   75,   75,
			   75,   75,   75,   78,   85,   79,  104,   76,   83,   84,
			   76,   86,   86,   87,   87,   88,  105,   89,   90,   88,
			  482,   90,   90,   86,   86,   91,   86,   86,  136,   94,
			  137,  109,  125,   71,   95,  110,   96,  479,   71,   99,
			  123,   97,   98,  100,  116,   80,  101,  126,  111,  102,
			  117,  130,  103,   92,  106,   91,  107,   92,  129,   95,
			   96,  109,  123,   97,   98,  112,  108,   99,  100,  126,
			  111,  102,  113,  114,  103,  119,  127,  276,  115,  106,
			  107,  130,  129,  321,  131,  120,  128,  121,  133,  133,

			  277,  122,  153,  154,  112,  155,  314,  114,  163,  164,
			  115,  145,  146,  145,  127,  119,  473,  147,  128,  472,
			  120,  121,  131,  122,  148,  149,  148,  150,  151,  150,
			  165,  164,  241,  241,  134,  138,  139,  140,  141,  138,
			  142,  138,  142,  142,  142,  138,  138,  138,  143,  138,
			  138,  138,  142,  138,  142,  138,  142,  142,  142,  142,
			  138,  142,  138,  142,  138,  138,  138,  142,  138,  142,
			  138,  138,  142,  142,  142,  142,  142,  142,  138,  138,
			  138,  138,  138,  138,  138,  138,  144,  144,  144,  144,
			  144,  144,  144,  144,  144,  144,  144,  144,  144,  144,

			  156,  153,  157,  470,  155,  156,  159,  157,  469,  155,
			  153,  160,   78,  161,   79,  152,   75,   75,   75,  168,
			  169,  168,   75,   78,  468,   79,   76,  174,  174,  178,
			  178,  173,   88,  185,  180,  181,  186,  187,  175,  466,
			  179,   88,   91,  181,  181,  182,  182,  188,  158,  189,
			  191,  192,  194,  158,   80,  195,  197,  202,  446,  196,
			  200,  186,  198,  176,  201,   80,  203,  187,  214,  188,
			   92,  189,   91,  216,  194,  192,  215,  199,  197,   92,
			  191,  183,  202,  212,  217,  195,  201,  226,  196,  228,
			  214,  227,  198,  258,  230,  213,  203,  234,  215,  199,

			  206,  236,  207,  216,  208,  231,  136,  136,  137,  137,
			  232,  228,  226,  212,  217,  209,  230,  258,  210,  234,
			  242,  233,   79,  236,  133,  133,  133,  133,  163,  164,
			  206,  207,  208,  153,  154,  231,  155,  209,  165,  164,
			  210,  219,  220,  233,  221,  238,  239,  238,  238,  240,
			  238,  436,  222,  159,  154,  223,  155,  224,  225,  434,
			  133,   75,  134,  145,  146,  145,  148,  149,  148,  147,
			  173,  219,  220,  221,  243,  243,  222,  223,  302,  224,
			  225,  150,  151,  150,  156,  153,  157,  308,  155,  156,
			  159,  157,  433,  155,  153,  160,  136,  161,  137,  152,

			  159,  160,  302,  161,  431,  152,  168,  169,  168,  244,
			   78,  308,   79,  246,  246,  245,  245,  247,  247,  249,
			  249,  248,  248,  259,  175,  250,  250,  257,  257,  253,
			  253,  278,  158,  254,  254,  261,  251,  158,   88,  262,
			  255,  256,   88,  263,  256,  256,  183,  183,   91,  176,
			  264,  265,   80,  259,  413,  266,  278,  261,  349,  271,
			  412,  252,  267,  183,  270,  263,  274,  283,  275,  262,
			  285,  289,  264,  272,  290,  291,   92,  266,   91,  294,
			   92,  265,  183,  349,  267,  295,  270,  300,  274,  271,
			  275,  298,  296,  305,  309,  309,  408,  283,  248,  248,

			  285,  289,  384,  290,  406,  291,  385,  295,  405,  294,
			  297,  313,  313,  298,  404,  305,  402,  300,  238,  239,
			  238,  324,  296,  310,  241,  241,  166,  243,  243,  311,
			  245,  245,  297,  312,  312,  315,  315,  316,  316,  319,
			  319,  317,  317,  324,  175,  318,  318,  314,  251,  254,
			  254,  320,  320,  322,  325,  255,  256,  322,  329,  256,
			  256,  323,  323,   91,  331,  350,  334,  336,  337,  176,
			  371,  371,  338,  252,  339,  361,  325,  341,  346,  348,
			  329,  351,  353,  354,  355,  358,  331,  321,  334,  336,
			  350,  183,  337,   91,  338,  183,  339,  183,  359,  341,

			  346,  348,  362,  351,  353,  361,  355,  358,  364,  365,
			  366,  367,  354,  135,  309,  309,  312,  312,  370,  370,
			  372,  372,  382,  359,  362,  373,  373,  369,  318,  318,
			  388,  365,  374,  374,  381,  366,  251,  364,  376,  376,
			  383,  367,  377,  377,  378,  378,  373,  373,  380,  386,
			  183,  183,  382,  387,  314,  390,  392,  379,  381,  388,
			  391,  252,  383,  398,  394,  393,  414,  401,  375,  403,
			  407,  411,  409,  386,  410,  387,  416,  416,  321,  418,
			  392,  400,  391,  417,  417,  390,   92,  393,  394,  401,
			  414,  403,  407,  398,  409,  399,  410,  397,  415,  415,

			  435,  411,  416,  416,  176,  373,  373,  420,  420,  421,
			  421,  429,  314,  422,  422,  430,  419,  423,  423,  424,
			  424,  425,  425,  427,  427,  423,  423,  432,  437,  439,
			  435,  438,  440,  429,  428,  441,  442,  430,  443,  444,
			  445,  416,  416,  375,  447,  448,  449,  416,  416,  432,
			  437,  439,  396,  321,  440,  438,  450,  450,  442,  456,
			  443,  454,  454,  444,  445,  441,  447,  395,  449,  448,
			  451,  451,  453,  453,  452,  452,  454,  454,  455,  455,
			  423,  423,  457,  457,  252,  423,  423,  458,  458,  459,
			  459,  461,  462,  460,  460,  463,  464,  375,  456,  465,

			  471,  452,  452,  467,  474,  474,  454,  454,  454,  454,
			  475,  475,  480,  461,  476,  476,  462,  481,  477,  477,
			  422,  422,  389,  252,  465,  463,  464,  467,  460,  460,
			  471,  456,  478,  478,  480,  450,  450,  477,  477,  481,
			  314,  483,  483,  457,  457,  475,  475,  368,  363,  360,
			  357,  356,  352,  347,  345,  344,  252,  343,  342,  340,
			  335,  333,  332,  330,  328,  327,  326,  307,  321,  306,
			  304,  314,  303,  301,  299,  293,  292,  375,  288,  321,
			  287,  375,   52,   52,   52,   52,   52,   52,   52,   52,
			   52,   52,   52,   52,   52,   52,   52,   52,   52,   52,

			   52,   52,   52,   56,   56,   56,   56,   56,   56,   56,
			   56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
			   56,   56,   56,   56,   60,   60,   60,   60,   60,   60,
			   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
			   60,   60,   60,   60,   60,   63,   63,   63,   63,   63,
			   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
			   63,   63,   63,   63,   63,   63,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   72,   72,   72,
			   72,   72,   72,   72,   72,   72,   72,   72,   72,   72,

			   72,   72,   72,   72,   72,   72,   72,   72,   77,   77,
			  286,   77,   77,   77,   77,   77,   77,   77,   77,   77,
			   77,   77,   77,   77,   77,   77,   77,   77,   77,   81,
			  284,  282,  281,  280,  279,   81,   81,   81,   81,   81,
			   81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
			   82,   82,  273,   82,   82,   82,   82,   82,   82,   82,
			   82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
			   82,   93,   93,  269,  268,   93,   93,   93,   93,   93,
			   93,   93,   93,  135,  135,  260,  135,  135,  135,  135,
			  135,  135,  135,  135,  135,  135,  135,  135,  135,  135,

			  135,  135,  135,  135,  152,  152,  152,  152,  152,  152,
			  152,  152,  152,  152,  152,  152,  152,  152,  152,  152,
			  152,  152,  152,  152,  152,  158,  158,  158,  158,  158,
			  158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
			  158,  158,  158,  158,  158,  158,  162,  162,  162,  162,
			  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
			  162,  162,  162,  162,  162,  162,  162,  166,  166,  166,
			  166,  244,  237,  235,  166,  166,  166,  166,  166,  166,
			  166,  166,  166,  171,  171,  229,  171,  171,  171,  171,
			  171,  171,  171,  171,  171,  171,  171,  171,  171,  171,

			  171,  171,  171,  171,   85,   85,   85,   85,   85,   85,
			   85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
			   85,   85,   85,   85,   85,  177,  177,  177,  177,  177,
			  177,  177,  177,  218,  177,  177,  177,  177,  177,  177,
			  177,  177,  177,  177,  177,  177,  135,  135,  135,  135,
			  211,  205,  204,  135,  135,  135,  135,  135,  135,  135,
			  135,  135,  166,  166,  193,  166,  166,  166,  166,  166,
			  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
			  166,  166,  166,  426,  426,  426,  426,  426,  426,  426,
			  426,  190,  426,  426,  426,  426,  426,  426,  426,  426,

			  426,  426,  426,  426,  184,  170,  172,  170,  167,   85,
			   86,  132,  124,  118,   86,   86,  484,   15,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484>>)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    3,    4,  475,    3,
			    4,    3,    4,    5,    5,    5,    6,    6,    6,    5,
			   13,   13,    6,    7,    7,    7,    8,    8,    8,    9,
			    9,    9,   10,   10,   10,   11,   11,   11,   25,   11,

			   12,   12,   12,   25,   12,   14,   14,   17,   17,   17,
			   18,   18,   18,   20,   23,   20,   35,   17,   22,   22,
			   18,   24,   23,   24,   24,   26,   35,   26,   26,   27,
			  471,   27,   27,   29,   29,   26,   30,   30,   52,   32,
			   52,   37,   44,   11,   32,   37,   32,  461,   12,   34,
			   42,   32,   32,   34,   39,   20,   34,   44,   37,   34,
			   39,   47,   34,   26,   36,   26,   36,   27,   46,   32,
			   32,   37,   42,   32,   32,   38,   36,   34,   34,   44,
			   37,   34,   38,   38,   34,   41,   45,  204,   38,   36,
			   36,   47,   46,  457,   48,   41,   45,   41,   51,   51,

			  204,   41,   66,   66,   38,   66,  450,   38,   72,   72,
			   38,   57,   57,   57,   45,   41,  448,   57,   45,  447,
			   41,   41,   48,   41,   61,   61,   61,   64,   64,   64,
			   74,   74,  143,  143,   51,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,

			   67,   67,   67,  444,   67,   69,   69,   69,  443,   69,
			   71,   71,   77,   71,   77,   71,   75,   75,   75,   80,
			   80,   80,   85,   80,  442,   80,   75,   87,   87,   88,
			   88,   85,   89,   95,   89,   89,   95,   96,   87,  438,
			   88,   90,   89,   90,   90,   92,   92,   97,   67,   98,
			  100,  101,  103,   69,   77,  104,  106,  109,  407,  104,
			  108,   95,  107,   87,  108,   80,  110,   96,  118,   97,
			   89,   98,   89,  120,  103,  101,  119,  107,  106,   90,
			  100,   92,  109,  117,  121,  104,  108,  125,  104,  126,
			  118,  125,  107,  184,  128,  117,  110,  130,  119,  107,

			  114,  132,  114,  120,  114,  129,  135,  142,  135,  142,
			  129,  126,  125,  117,  121,  114,  128,  184,  114,  130,
			  166,  129,  166,  132,  133,  133,  134,  134,  162,  162,
			  114,  114,  114,  152,  152,  129,  152,  114,  164,  164,
			  114,  124,  124,  129,  124,  139,  139,  139,  141,  141,
			  141,  393,  124,  154,  154,  124,  154,  124,  124,  390,
			  133,  173,  134,  145,  145,  145,  148,  148,  148,  145,
			  173,  124,  124,  124,  167,  167,  124,  124,  229,  124,
			  124,  150,  150,  150,  156,  156,  156,  235,  156,  157,
			  157,  157,  387,  157,  158,  158,  310,  158,  310,  158,

			  160,  160,  229,  160,  385,  160,  168,  168,  168,  172,
			  168,  235,  168,  174,  174,  172,  172,  175,  175,  176,
			  176,  175,  175,  185,  174,  178,  178,  182,  182,  179,
			  179,  205,  156,  179,  179,  189,  178,  157,  180,  190,
			  180,  180,  181,  191,  181,  181,  183,  183,  180,  174,
			  192,  193,  168,  185,  365,  194,  205,  189,  285,  200,
			  364,  178,  195,  182,  199,  191,  202,  210,  203,  190,
			  212,  218,  192,  200,  218,  219,  180,  194,  180,  222,
			  181,  193,  183,  285,  195,  223,  199,  227,  202,  200,
			  203,  225,  224,  232,  237,  237,  358,  210,  247,  247,

			  212,  218,  331,  218,  356,  219,  331,  223,  355,  222,
			  224,  248,  248,  225,  354,  232,  352,  227,  238,  238,
			  238,  258,  224,  241,  241,  241,  243,  243,  243,  245,
			  245,  245,  224,  246,  246,  249,  249,  250,  250,  252,
			  252,  251,  251,  258,  246,  251,  251,  248,  250,  253,
			  253,  254,  254,  255,  259,  255,  255,  256,  263,  256,
			  256,  257,  257,  255,  265,  287,  268,  270,  271,  246,
			  314,  314,  272,  250,  273,  299,  259,  275,  281,  283,
			  263,  289,  291,  292,  293,  296,  265,  254,  268,  270,
			  287,  255,  271,  255,  272,  256,  273,  257,  297,  275,

			  281,  283,  300,  289,  291,  299,  293,  296,  304,  305,
			  306,  307,  292,  309,  309,  309,  312,  312,  313,  313,
			  315,  315,  327,  297,  300,  316,  316,  312,  317,  317,
			  335,  305,  318,  318,  326,  306,  316,  304,  319,  319,
			  330,  307,  320,  320,  321,  321,  322,  322,  323,  332,
			  323,  323,  327,  334,  313,  337,  339,  322,  326,  335,
			  338,  316,  330,  347,  342,  341,  367,  351,  318,  353,
			  357,  362,  359,  332,  361,  334,  370,  370,  320,  372,
			  339,  350,  338,  371,  371,  337,  323,  341,  342,  351,
			  367,  353,  357,  347,  359,  348,  361,  346,  369,  369,

			  392,  362,  369,  369,  372,  373,  373,  374,  374,  375,
			  375,  382,  370,  376,  376,  383,  373,  377,  377,  378,
			  378,  379,  379,  380,  380,  379,  379,  386,  395,  397,
			  392,  396,  398,  382,  380,  399,  400,  383,  401,  404,
			  405,  415,  415,  374,  411,  412,  414,  416,  416,  386,
			  395,  397,  344,  377,  398,  396,  417,  417,  400,  422,
			  401,  420,  420,  404,  405,  399,  411,  343,  414,  412,
			  418,  418,  419,  419,  418,  418,  419,  419,  421,  421,
			  423,  423,  424,  424,  422,  425,  425,  427,  427,  428,
			  428,  429,  431,  428,  428,  433,  434,  420,  427,  435,

			  445,  451,  451,  441,  452,  452,  453,  453,  454,  454,
			  455,  455,  467,  429,  456,  456,  431,  469,  456,  456,
			  458,  458,  336,  427,  435,  433,  434,  441,  459,  459,
			  445,  458,  460,  460,  467,  474,  474,  476,  476,  469,
			  452,  477,  477,  478,  478,  483,  483,  311,  301,  298,
			  295,  294,  290,  282,  280,  279,  458,  278,  277,  274,
			  269,  267,  266,  264,  262,  261,  260,  234,  460,  233,
			  231,  474,  230,  228,  226,  221,  220,  477,  217,  478,
			  215,  483,  485,  485,  485,  485,  485,  485,  485,  485,
			  485,  485,  485,  485,  485,  485,  485,  485,  485,  485,

			  485,  485,  485,  486,  486,  486,  486,  486,  486,  486,
			  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,
			  486,  486,  486,  486,  487,  487,  487,  487,  487,  487,
			  487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
			  487,  487,  487,  487,  487,  488,  488,  488,  488,  488,
			  488,  488,  488,  488,  488,  488,  488,  488,  488,  488,
			  488,  488,  488,  488,  488,  488,  489,  489,  489,  489,
			  489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
			  489,  489,  489,  489,  489,  489,  489,  490,  490,  490,
			  490,  490,  490,  490,  490,  490,  490,  490,  490,  490,

			  490,  490,  490,  490,  490,  490,  490,  490,  491,  491,
			  213,  491,  491,  491,  491,  491,  491,  491,  491,  491,
			  491,  491,  491,  491,  491,  491,  491,  491,  491,  492,
			  211,  209,  208,  207,  206,  492,  492,  492,  492,  492,
			  492,  492,  492,  492,  492,  492,  492,  492,  492,  492,
			  493,  493,  201,  493,  493,  493,  493,  493,  493,  493,
			  493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
			  493,  494,  494,  197,  196,  494,  494,  494,  494,  494,
			  494,  494,  494,  495,  495,  188,  495,  495,  495,  495,
			  495,  495,  495,  495,  495,  495,  495,  495,  495,  495,

			  495,  495,  495,  495,  496,  496,  496,  496,  496,  496,
			  496,  496,  496,  496,  496,  496,  496,  496,  496,  496,
			  496,  496,  496,  496,  496,  497,  497,  497,  497,  497,
			  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
			  497,  497,  497,  497,  497,  497,  498,  498,  498,  498,
			  498,  498,  498,  498,  498,  498,  498,  498,  498,  498,
			  498,  498,  498,  498,  498,  498,  498,  499,  499,  499,
			  499,  171,  137,  131,  499,  499,  499,  499,  499,  499,
			  499,  499,  499,  500,  500,  127,  500,  500,  500,  500,
			  500,  500,  500,  500,  500,  500,  500,  500,  500,  500,

			  500,  500,  500,  500,  501,  501,  501,  501,  501,  501,
			  501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
			  501,  501,  501,  501,  501,  502,  502,  502,  502,  502,
			  502,  502,  502,  123,  502,  502,  502,  502,  502,  502,
			  502,  502,  502,  502,  502,  502,  503,  503,  503,  503,
			  116,  113,  111,  503,  503,  503,  503,  503,  503,  503,
			  503,  503,  504,  504,  102,  504,  504,  504,  504,  504,
			  504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
			  504,  504,  504,  505,  505,  505,  505,  505,  505,  505,
			  505,   99,  505,  505,  505,  505,  505,  505,  505,  505,

			  505,  505,  505,  505,   94,   84,   83,   82,   79,   76,
			   50,   49,   43,   40,   31,   28,   15,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484>>)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,   63,   64,   71,   74,   81,   84,   87,
			   90,   93,   98,   77,  102, 1416, 1417,  105,  108, 1417,
			  107,    0,  110,  102,  108,   84,  112,  116, 1396,  115,
			  117, 1395,  111,    0,  120,   90,  131,  119,  148,  124,
			 1377,  162,  111, 1386,  116,  157,  133,  139,  165, 1375,
			 1361,  183,  132, 1417, 1417,  234, 1417,  209, 1417, 1417,
			 1417,  222, 1417, 1417,  225, 1417,  199,  298, 1417,  303,
			 1417,  307,  205, 1417,  227,  314, 1397,  306, 1417, 1394,
			  317,    0, 1398, 1392, 1396,  319, 1417,  312,  314,  319,
			  328, 1417,  330,    0, 1378,  303,  312,  307,  308, 1365,

			  328,  316, 1338,  313,  332,    0,  316,  337,  323,  324,
			  344, 1316,    0, 1314,  375,    0, 1318,  359,  327,  336,
			  348,  360,    0, 1307,  417,  354,  350, 1259,  352,  380,
			  358, 1247,  362,  409,  411,  400, 1417, 1258, 1417,  443,
			 1417,  446,  401,  217, 1417,  461, 1417, 1417,  464, 1417,
			  479, 1417,  430, 1417,  450, 1417,  482,  487,  491, 1417,
			  497, 1417,  425, 1417,  435, 1417,  414,  459,  504, 1417,
			 1417, 1262,  500,  458,  498,  506,  504, 1417,  510,  518,
			  525,  529,  512,  531,  358,  501,    0,    0, 1155,  496,
			  515,  503,  507,  529,  516,  520, 1148, 1147,    0,  522,

			  537, 1126,  526,  527,  153,  498, 1108, 1103, 1106, 1094,
			  545, 1104,  548, 1073,    0,  944,    0,  952,  547,  553,
			  950,  949,  557,  543,  568,  552,  948,  565,  943,  443,
			  946,  944,  555,  939,  937,  452,    0,  579,  616, 1417,
			 1417,  609, 1417,  612, 1417,  615,  618,  583,  596,  620,
			  622,  630,  624,  634,  636,  640,  644,  646,  580,  614,
			  938,  935,  932,  618,  937,  623,  936,  933,  627,  930,
			  628,  633,  633,  635,  933,  635,    0,  932,  927,  910,
			  909,  639,  927,  640,    0,  525,    0,  632,    0,  639,
			  922,  642,  656,  645,  917,  920,  643,  665,  903,  651,

			  663,  911,    0,    0,  681,  667,  677,  689,    0,  699,
			  490,  938,  701,  703,  655,  705,  710,  713,  717,  723,
			  727,  729,  731,  735,    0,    0,  699,  699,    0,    0,
			  701,  576,  714,    0,  714,  703,  896,  730,  719,  721,
			    0,  726,  729,  841,  822,    0,  767,  739,  765,    0,
			  755,  728,  571,  728,  584,  582,  578,  731,  570,  731,
			    0,  733,  749,    0,  530,  528,    0,  731, 1417,  787,
			  761,  768,  753,  790,  792,  794,  798,  802,  804,  810,
			  808,    0,  769,  774,    0,  468,  786,  466,    0,    0,
			  433,    0,  778,  425,    0,  788,  796,  788,  791,  813,

			  795,  798,    0,    0,  804,  805,    0,  332,    0,    0,
			    0,  803,  810,    0,  805,  826,  832,  841,  859,  861,
			  846,  863,  833,  865,  867,  870, 1417,  872,  878,  850,
			    0,  857,    0,  870,  871,  866,    0,    0,  311,    0,
			    0,  868,  298,  272,  277,  876,    0,  193,  190,    0,
			  155,  886,  889,  891,  893,  895,  903,  142,  905,  913,
			  917,  121,    0,    0,    0,    0,    0,  871,    0,  878,
			    0,  104,    0,    0,  920,   17,  922,  926,  928,    0,
			    0,    0,    0,  930, 1417,  981, 1002, 1023, 1044, 1065,
			 1086, 1107, 1128, 1149, 1161, 1182, 1203, 1224, 1245, 1262,

			 1282, 1303, 1324, 1341, 1361, 1382>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  484,    1,  485,  485,  486,  486,  487,  487,  488,
			  488,  489,  489,  490,  490,  484,  484,  484,  484,  484,
			  491,  492,  493,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  484,  484,  495,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  496,  496,  484,  496,
			  484,  497,  498,  484,  498,  484,  484,  491,  484,  499,
			  491,  492,  484,  500,  484,  501,  484,  484,  502,  484,
			  484,  484,  484,  494,  494,  494,  494,  494,  494,  494,

			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  484,  484,  495,  484,  503,  484,  484,
			  484,  484,  495,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  496,  484,  496,  484,  496,  496,  497,  484,
			  497,  484,  498,  484,  498,  484,  504,  484,  491,  484,
			  484,  484,  484,  501,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,

			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,

			  494,  494,  494,  494,  494,  494,  494,  494,  494,  484,
			  495,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  484,  502,  484,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  505,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,

			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
			  484,  494,  494,  494,  494,  494,  494,  494,  494,  494,
			  494,  494,  494,  494,  484,  484,  484,  484,  484,  494,
			  494,  494,  494,  484,    0,  484,  484,  484,  484,  484,
			  484,  484,  484,  484,  484,  484,  484,  484,  484,  484,

			  484,  484,  484,  484,  484,  484>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    4,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    5,    6,    7,    5,    8,    7,    9,
			   10,   10,    5,   11,    5,   12,   13,   14,   15,   15,
			   16,   16,   16,   16,   16,   16,   16,   16,   17,    5,
			   18,   19,   20,   21,    7,   22,   23,   24,   25,   26,
			   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
			   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
			   47,   48,   49,   50,    5,   51,    1,   52,   53,   54,

			   55,   26,   56,   28,   57,   30,   31,   32,   58,   34,
			   59,   36,   37,   60,   61,   62,   63,   64,   65,   44,
			   45,   46,   47,    5,    7,    5,    5,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    2,    3,    4,    1,    5,    1,    6,    7,
			    8,    1,    1,    9,    7,   10,   11,    1,   12,    1,
			   13,    1,   14,   14,   14,   15,   10,   16,   10,   17,
			   10,   10,   10,   18,   10,   19,   10,   10,   14,   14,
			   14,   14,   14,   20,   10,   10,   10,   21,    1,    1,
			    1,   10,   10,   10,   10,   10,   10,   10,   10,   10,
			   10,   10,   10,   10,   10,   10>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    3,    4,    5,    6,    8,   11,   13,
			   16,   19,   22,   25,   28,   31,   34,   38,   42,   45,
			   48,   51,   54,   57,   60,   63,   66,   69,   72,   75,
			   78,   81,   84,   87,   90,   93,   96,   99,  102,  105,
			  108,  110,  112,  114,  116,  118,  120,  122,  124,  126,
			  129,  131,  133,  135,  137,  139,  141,  143,  145,  147,
			  149,  151,  153,  155,  157,  159,  160,  160,  161,  163,
			  163,  165,  166,  167,  168,  170,  171,  172,  174,  174,
			  176,  178,  179,  180,  181,  182,  183,  184,  186,  187,

			  188,  189,  190,  191,  192,  193,  195,  196,  197,  198,
			  199,  200,  201,  203,  204,  205,  207,  208,  209,  210,
			  211,  212,  213,  215,  216,  217,  218,  219,  220,  221,
			  222,  223,  224,  225,  227,  228,  229,  230,  230,  231,
			  232,  233,  234,  236,  238,  240,  240,  241,  242,  242,
			  243,  243,  244,  245,  246,  247,  248,  249,  250,  251,
			  253,  254,  256,  257,  258,  259,  261,  262,  262,  263,
			  264,  265,  266,  268,  269,  271,  271,  271,  272,  274,
			  275,  277,  279,  280,  281,  282,  283,  285,  287,  288,
			  289,  290,  291,  292,  293,  294,  295,  296,  297,  299,

			  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
			  310,  311,  312,  313,  314,  316,  317,  319,  320,  321,
			  322,  323,  324,  325,  326,  327,  328,  329,  330,  331,
			  332,  333,  334,  335,  336,  337,  338,  340,  340,  340,
			  341,  343,  344,  345,  345,  346,  347,  349,  349,  351,
			  351,  353,  353,  353,  353,  355,  357,  359,  360,  361,
			  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
			  373,  374,  375,  376,  377,  378,  379,  381,  382,  383,
			  384,  385,  386,  387,  388,  390,  391,  393,  394,  396,
			  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,

			  407,  408,  409,  411,  413,  414,  415,  416,  417,  419,
			  419,  421,  422,  423,  425,  425,  425,  427,  427,  431,
			  431,  433,  433,  433,  435,  437,  439,  440,  441,  443,
			  445,  446,  447,  448,  450,  451,  452,  453,  454,  455,
			  456,  458,  459,  460,  461,  462,  464,  465,  466,  467,
			  469,  470,  471,  472,  473,  474,  475,  476,  477,  478,
			  479,  481,  482,  483,  485,  486,  487,  489,  490,  491,
			  491,  493,  493,  494,  495,  499,  499,  499,  501,  501,
			  502,  502,  504,  505,  506,  508,  509,  510,  511,  513,
			  515,  516,  518,  519,  520,  522,  523,  524,  525,  526,

			  527,  528,  529,  531,  533,  534,  535,  537,  538,  540,
			  542,  544,  545,  546,  548,  549,  549,  550,  550,  550,
			  550,  554,  554,  555,  556,  556,  556,  557,  558,  559,
			  560,  562,  563,  565,  566,  567,  568,  570,  572,  573,
			  575,  577,  578,  579,  580,  581,  582,  584,  585,  586,
			  588,  589,  589,  590,  590,  592,  592,  592,  593,  594,
			  594,  595,  596,  598,  600,  602,  604,  606,  607,  609,
			  610,  612,  613,  615,  617,  618,  620,  620,  622,  623,
			  625,  627,  629,  631,  633,  633>>)
		end

	yy_acclist_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,   85,   85,   88,   88,  120,  118,  119,    1,  118,
			  119,    1,  119,    2,  118,  119,   90,  118,  119,   69,
			  118,  119,   76,  118,  119,    2,  118,  119,    2,  118,
			  119,    2,  118,  119,  108,  111,  118,  119,  108,  111,
			  118,  119,    2,  118,  119,    2,  118,  119,    2,  118,
			  119,    2,  118,  119,   68,  118,  119,   68,  118,  119,
			   68,  118,  119,   68,  118,  119,   68,  118,  119,   68,
			  118,  119,   68,  118,  119,   68,  118,  119,   68,  118,
			  119,   68,  118,  119,   68,  118,  119,   68,  118,  119,
			   68,  118,  119,   68,  118,  119,   68,  118,  119,   68,

			  118,  119,   68,  118,  119,   68,  118,  119,  118,  119,
			  118,  119,   97,  119,  101,  119,   98,  119,  100,  119,
			  106,  119,  106,  119,  105,  119,  104,  106,  119,  103,
			  119,  103,  119,  102,  119,   80,  119,   80,  119,   79,
			  119,   85,  119,   85,  119,   84,  119,   85,  119,   82,
			  119,   85,  119,   88,  119,   87,  119,   88,  119,    1,
			   90,   77,   89,   90, -197,   69,   76,   76,   75,   76,
			    1,    3,  114,  117,  108,  111,  108,  111,  107,  111,
			   68,   68,   68,   68,    8,   68,   68,   68,   68,   68,
			   68,   68,   68,   14,   68,   68,   68,   68,   68,   68,

			   68,   26,   68,   68,   68,   33,   68,   68,   68,   68,
			   68,   68,   68,   41,   68,   68,   68,   68,   68,   68,
			   68,   68,   68,   68,   68,  110,  111,  110,   97,   98,
			   99,   99,   91,   99,   97,   99,   95,   99,   96,   99,
			  105,  104,  102,   79,   85,   84,   85,   82,   85,   85,
			   85,   83,   84,   85,   81,   82,   88,   87,   88,   86,
			   87,   90,   90,  -78,   70,   76,   74,   76,    1,  114,
			  117,  112,  114,  117,  112,  108,  111,  108,  111,  111,
			  111,   68,   68,    6,   68,    7,   68,   68,   68,   68,
			   68,   68,   68,   68,   68,   68,   68,   17,   68,   68,

			   68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
			   68,   68,   68,   68,   37,   68,   68,   39,   68,   68,
			   68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
			   68,   68,   68,   68,   68,   68,   68,   68,   60,   68,
			   92,   91,   92,   94,   89,   71,   73,  114,  117,  114,
			  117,  114,  117,  113,  116,  108,  111,  108,  111,  111,
			   68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
			   68,   15,   68,   68,   68,   68,   68,   68,   68,   24,
			   68,   68,   68,   68,   68,   68,   68,   68,   34,   68,
			   68,   36,   68,   68,   40,   68,   68,   68,   68,   68,

			   68,   68,   68,   68,   68,   68,   68,   68,   68,   53,
			   68,   54,   68,   68,   68,   68,   68,   59,   68,   93,
			   97,   76,  114,  114,  117,  114,  117,  113,  114,  116,
			  117,  113,  116,  109,  111,    4,   68,    5,   68,   68,
			   68,    9,   68,   61,   68,   68,   68,   68,   12,   68,
			   68,   68,   68,   68,   68,   68,   22,   68,   68,   68,
			   68,   68,   29,   68,   68,   68,   68,   35,   68,   68,
			   68,   68,   68,   68,   68,   68,   68,   68,   68,   49,
			   68,   68,   68,   52,   68,   68,   68,   57,   68,   68,
			   72,  114,  117,  117,  114,  113,  114,  116,  117,  113,

			  116,  112,   62,   68,   68,   68,   65,   68,   68,   68,
			   68,   16,   68,   18,   68,   68,   20,   68,   68,   68,
			   25,   68,   68,   68,   68,   68,   68,   68,   68,   43,
			   68,   66,   68,   68,   68,   45,   68,   68,   47,   68,
			   48,   68,   50,   68,   68,   68,   56,   68,   68,  114,
			  113,  114,  116,  117,  117,  113,  115,  117,  115,   68,
			   64,   68,   68,   11,   68,   68,   68,   68,   23,   68,
			   27,   68,   68,   30,   68,   31,   68,   68,   68,   68,
			   68,   68,   46,   68,   68,   68,   58,   68,  117,  117,
			  113,  114,  116,  117,  116,   68,   10,   68,   13,   68,

			   19,   68,   21,   68,   28,   68,   68,   38,   68,   68,
			   44,   68,   68,   51,   68,   55,   68,  117,  116,  117,
			  116,  117,  116,   63,   68,   32,   68,   42,   68,   67,
			   68,  116,  117>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 1417
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 484
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 485
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is true
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is true
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 119
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 120
			-- End of buffer rule code

	yyLine_used: BOOLEAN is true
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is false
			-- Is `position' used?

	INITIAL: INTEGER is 0
	MS: INTEGER is 1
	MSN: INTEGER is 2
	MSN1: INTEGER is 3
	VS1: INTEGER is 4
	VS2: INTEGER is 5
	VS3: INTEGER is 6
			-- Start condition codes

feature -- User-defined features



end
