indexing

	description:

		"Routines that ought to be in class DOUBLE"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/26 20:04:54 $"
	revision: "$Revision: 1.10 $"

class KL_DOUBLE_ROUTINES
























feature -- Logarithms

	log (d: DOUBLE): DOUBLE is
			-- Natural logarithm of `d'
		require
			d_positive: d > 0.0
		do







			Result := double_math.log (d)




		end

	log10 (d: DOUBLE): DOUBLE is
			-- Base 10 logarithm of `d'
		require
			d_positive: d > 0.0
		do







			Result := double_math.log10 (d)




		end

feature -- Exponent

	exp (d: DOUBLE): DOUBLE is
			-- Inverse of the natural logarithm
		do









		end

	nth_root (d, n: DOUBLE): DOUBLE is
			-- `n'-th root of `d'
		require



			divisible: (1.0).divisible (n)

		do






		end


feature {NONE} -- Implementation

	double_math: DOUBLE_MATH is
			-- Double math functions
			-- (Note: HACT 4.0.1 does not handle correctly the renaming
			-- of external features with no alias clause.)
		once
			create Result
		ensure
			double_math_not_void: Result /= Void
		end


end
