/**
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef CACHE_H
#define CACHE_H

#include <stdlib.h>
#include <audiofile.h>
#include <config.h>

#define CACHE_MAX_BLOCKS 16
#define CACHE_MIN_BLOCK_SIZE 1000 /* in frames */

typedef enum {
    CACHE_REAL,
    CACHE_NULL
} cache_type;

typedef struct _cache {
    cache_type type;
    size_t high;
    size_t low;
    size_t sz;
    void *data;
    char *disk;
} cache;

cache *
cache_new(cache_type type,
          size_t sz);

cache *
cache_clone(cache *c,
            size_t off,
            size_t sz);

void 
cache_destroy(cache *c);

size_t
cache_fill(cache *c,
           void *src,
           size_t offset,
           size_t sz);

void
cache_find(cache *c,
           void *dst,
           size_t *offset,
           size_t *sz);

void
cache_clear(cache *c);

int
cache_resize(cache *c, 
             size_t sz);

void 
cache_move(cache *c,
           size_t new_off,
           size_t old_off,
           size_t sz);

cache *
cache_join(cache *c1,
           cache *c2);

void
cache_dump(cache *c);

#endif /* ! CACHE_H */
