#
# Copyright 2002-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# UIwin32.py
#
# DESCRIPTION:
# Set of classes that provide a menuing interface via PyWin32
#
# NOTES:
# This file is nothing but a temporary hack.  Navigator should
# reuse GNUe Form's UI* classes if at all possible.


import os, sys
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.utils.FileUtils import dyn_import, openResource
from gnue.common.apps import GConfig
from gnue.navigator import VERSION

from gnue.forms.uidrivers.win32.common import getNextId
from gnue.forms.uidrivers.win32.GFwin32App import *

try:
  from gnue.forms.GFInstance import GFInstance
  from gnue.forms import GFParser
  from gnue.forms.uidrivers import win32 as ui
  FORMS_SUPPORT=0
except ImportError:
  FORMS_SUPPORT=1
  print 'GNUe Forms is not installed on your system'

import struct, array, tempfile
import win32api, win32gui, win32ui, win32con, commctrl
from pywin.mfc import window, activex
from win32com.client import gencache

WebBrowserModule = gencache.EnsureModule("{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}", 0, 1, 1)
if WebBrowserModule is None:
  raise ImportError, "IE4 does not appear to be installed."

ID_EXIT = getNextId()
ID_FAV_ORG = getNextId()
ID_FAV_ADD = getNextId()
ID_ABOUT = getNextId()

_menustyle = win32con.MF_STRING

images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'

class Instance:
  def __init__(self, processes):
    self.processes = processes
    self._formInstances = {}

    self.titlePage = """
    <html>
      <body>
        <center>
         <B>GNUe Navigator</B>
         <p><img src="%s"></p>
         <p>A part of the <a href="http://www.gnuenteprise.org/">GNU Enterprise Project</a></p>
        </center>
      </body>
    </html>
    """ % (images_dir+"/ship2.png")

    win32gui.InitCommonControls()
    message_map = {
      win32con.WM_SIZE: self.OnWMSize,
      win32con.WM_NOTIFY: self.OnWMNotify,
      win32con.WM_CLOSE: self.OnWMClose,
      win32con.WM_COMMAND: self.OnWMCommand,
    }
    # Register the Window class.
    wc = win32gui.WNDCLASS()
    wc.lpszClassName = "GNUe navigator"
    wc.hCursor = win32gui.LoadCursor( 0, win32con.IDC_ARROW )
    wc.hbrBackground = win32con.COLOR_WINDOW
    wc.lpfnWndProc = message_map # could also specify a wndproc.
    self.classAtom = win32gui.RegisterClass(wc)
    self.hTree = 0

  def run(self, connections):
    #
    # Assign the proper login handler based upon the user interface choice
    #
    self.connections = connections
    self.connections.setLoginHandler(ui.UILoginHandler())

    app = getWin32App()
    self._app = app

    style = win32con.WS_OVERLAPPEDWINDOW | win32con.WS_CLIPCHILDREN 
    self.hMainWindow = win32gui.CreateWindow(self.classAtom, "GNUe Navigator", style, \
                  0, 0, 600, 400, \
                  0, 0, 0, None)

    self._app._MainWindowList.append(self.hMainWindow)

    win32gui.ShowWindow(self.hMainWindow, win32con.SW_SHOWNORMAL)
    
    self.CreateMenu()
    self.BuildTree()
    self.tempfile = tempfile.mktemp('.html')
    self.tempfileHandle = open(self.tempfile, 'w')
    self.tempfileHandle.write(self.titlePage)
    self.tempfileHandle.flush()

    self.CreateBrowser(self.tempfile)

    self.processes.setClientHandlers({'form':self.runForm})

    self._mapping = {}
    self.processes.walk(self.__buildTreeControl)

    win32gui.SendMessage(self.hTree, commctrl.TVM_EXPAND, commctrl.TVE_EXPAND , self.processes.__node)

    app.MainLoop()


  def CreateMenu(self):
    _mainmenu = win32ui.CreateMenu()

    self._menu = win32ui.CreatePopupMenu()
    self._favorites = win32ui.CreatePopupMenu()
    self._help = win32ui.CreatePopupMenu()

    _mainmenu.AppendMenu(_menustyle | win32con.MF_POPUP, self._menu.GetHandle(), '&Menu')
    _mainmenu.AppendMenu(_menustyle | win32con.MF_POPUP, self._favorites.GetHandle(), '&Favorites')
    _mainmenu.AppendMenu(_menustyle | win32con.MF_POPUP, self._help.GetHandle(), '&Help')

#    self._menu.AppendMenu(win32con.MF_SEPARATOR, 0, "")
    self._menu.AppendMenu(_menustyle, ID_EXIT, "E&xit")

    self._favorites.AppendMenu(_menustyle, ID_FAV_ADD, '&Add Favorite')
    self._favorites.AppendMenu(_menustyle, ID_FAV_ORG, '&Organize Favorites')

    self._help.AppendMenu(_menustyle, ID_ABOUT,'&About')
    win32gui.SetMenu(self.hMainWindow, _mainmenu.GetHandle())


  def BuildTree(self):
    hinst = win32api.GetModuleHandle(None)
    l,t,r,b = win32gui.GetClientRect(self.hMainWindow)
    style = win32con.WS_VISIBLE | win32con.WS_CHILD | \
               commctrl.TVS_HASLINES | commctrl.TVS_HASBUTTONS | commctrl.TVS_LINESATROOT
    width = (r-l)/3
    height = b-t
    self.hTree = win32gui.CreateWindowEx(win32con.WS_EX_CLIENTEDGE, commctrl.WC_TREEVIEW, '', style, \
                                                         0,0, width,height, self.hMainWindow, getNextId(), hinst, None)
    win32gui.ShowWindow(self.hTree, win32con.SW_SHOWNORMAL)

    # TODO: create imagelist from form.ico, report.ico,...
#    iconloc = 'c:\\python22\\shared\\images\\forms\\toolbar-24x24.bmp'
#    himl = win32gui.ImageList_LoadImage(0, iconloc, 24, 0, 0xFF000000, win32con.IMAGE_BITMAP, \
#      win32con.LR_LOADFROMFILE | win32con.LR_SHARED | win32con.LR_CREATEDIBSECTION)
#    win32gui.SendMessage(self.hTree, commctrl.TVM_SETIMAGELIST, commctrl.TVSIL_NORMAL, himl)


  def CreateBrowser(self, url):
    self.browser = BrowserFrame(url)
    l,t,r,b = win32gui.GetClientRect(self.hMainWindow)
    self.browser.Create("", rect=((r-l)/3, 0, r-l, b-t),\
                               parent=win32ui.CreateWindowFromHandle(self.hMainWindow))


  def OnWMNotify(self, hwnd, msg, wParam, lParam):
    # NMTREEVIEW struct: NMHDR, action, old TVIEW, new TVIEW, POINT
    format = "iiiIIiIIPiiiiiIiIIPiiiiiii"
    buf = win32gui.PyMakeBuffer(struct.calcsize(format), lParam)
    hwndFrom, idFrom, code, action, \
    omask, ohItem, ostate, ostateMask, opszText, occhTextMax, oiImage, oiSelectedImage, ocChildren, olParam,\
    nmask, nhItem, nstate, nstateMask, npszText, ncchTextMax, niImage, niSelectedImage, ncChildren, nlParam,\
    x,y \
      = struct.unpack(format, buf)
    code += 0x4f0000 # hrm - wtf - commctrl uses this, and it works with mfc.  *sigh*

    if code == commctrl.TVN_SELCHANGED:
      object = self._mapping[nhItem]
      win32gui.SetWindowText(self.browser.GetSafeHwnd(), "")
      for item in object._children:
        if item._type == 'GNDescription':
          content = item.getChildrenAsContent()
          self.tempfileHandle.seek(0)
          self.tempfileHandle.truncate()
          self.tempfileHandle.write("<html\n>")
          self.tempfileHandle.write(content)
          self.tempfileHandle.flush()
          self.browser.ocx.Refresh()
          break

    elif code == commctrl.NM_DBLCLK or code == commctrl.NM_RETURN:
      curSelected = win32gui.SendMessage(self.hTree, commctrl.TVM_GETNEXTITEM, commctrl.TVGN_CARET, 0)
      object = self._mapping[curSelected]
      if object._type != 'GNStep':
        pass
        #self.tree.Expand(process.__node)
      else:
        object.run()


  def OnWMClose(self, hwnd, msg, wParam, lParam):
    self._app._MainWindowList.remove(hwnd)
    win32gui.DestroyWindow(hwnd)
    if len(self._app._MainWindowList) == 0:
      win32gui.PostQuitMessage(0) # Terminate the app.
    self.tempfileHandle.close()


  def OnWMCommand(self, hwnd, msg, wParam, lParam):
  # menu/toolbar selection
    id = win32api.LOWORD(wParam)
    if id == ID_EXIT:
      win32gui.SendMessage(self.hMainWindow, win32con.WM_CLOSE, 0, 0)
    elif id == ID_ABOUT:
      self.OnAbout()


  def OnWMSize(self, hwnd, msg, wParam, lParam):
    l,t,r,b = win32gui.GetClientRect(self.hMainWindow)
    win32gui.SetWindowPos(self.hTree, 0, 0, 0, (r-l)/3, b-t, win32con.SWP_NOMOVE | win32con.SWP_NOZORDER)
    try:
      win32gui.SetWindowPos(self.browser.GetSafeHwnd(), 0, (r-l)/3, 0, (r-l) - (r-l)/3, b-t, win32con.SWP_NOZORDER)
    except:
      pass


  def __buildTreeControl(self, object):
    if object._type == 'GNProcesses':
      node = self.__addItem(None, object.title,1)
    elif object._type in ('GNStep','GNProcess'):
      node = self.__addItem(object._parent.__node, object.title,2)
    else:
      return

    object.__node = node
    self._mapping[node] = object


  def __addItem(self, hParent, text, image):
    if hParent:
      parent=hParent
    else:
      parent=commctrl.TVI_ROOT

    buff = array.array('c', '%s \0x00' % text.encode(gConfig('textEncoding'),'replace'))
    addrText = buff.buffer_info()[0]
    # TVINSTERTSTRUCT:
    # hParent, hInsertAfter ,mask, hItem, state, stateMask, pszText, cchTextMax, iImage, iSelectedImage, cChildren, lParam
    tvIns = struct.pack("iiIiIIPiiiii",parent, commctrl.TVI_LAST, commctrl.TVIF_TEXT|commctrl.TVIF_IMAGE,\
                                                       0,0,0,addrText,0,image,0,0,0)
    return win32gui.SendMessage(self.hTree, commctrl.TVM_INSERTITEM, 0, tvIns)


  def OnAbout(self):
    text = _("GNUE Navigator")+"\r\n"+      \
    _("  Version : ")+"%s\r\n"+         \
    _("  Driver  : UIwxpython")+"\r\n"+ \
    _("-= Process Info =-")+"\r\n"+        \
    _("  Name   : ")+"%s\r\n"+          \
    _("  Version: ")+"%s\r\n"+          \
    _("  Author : ")+"%s\r\n"+          \
    _("  Description:")+"%s\r\n"
    style = win32con.MB_OK | win32con.MB_ICONINFORMATION
    win32ui.MessageBox(text % (VERSION,"","","",""), _("About") , style)


  def runForm(self, step, parameters = {}):    
    # parameters are now part of the step in _params
        
    # This is the code executing in the new thread. Simulation of
    # a long process (well, 10s here) as a simple loop - you will
    # need to structure your processing so that you periodically
    # peek at the abort variable

    # TODO: Pass parameters

    if os.path.basename(step.location) == step.location:
      try:
        formdir = gConfigNav('FormDir')
      except KeyError:
        formdir = ""
      formfile = formdir+"/"+step.location
    else:
      formfile = step.location

    self._runForm(formfile, step._params)


  def _runForm(self, formfile, parameters):

    try:
      #
      # Create the instance
      #
      #instance = GFInstance(id(self),
      #    connections=self.connections,
      #    ui=ui, disableSplash=1)
      instance = GFInstance(self,connections=self.connections,
                            ui=ui,disableSplash=1, parameters=parameters)
      self._formInstances[id(self)] = instance
         
      #
      # Build the form tree
      #
      instance.addFormFromFile(formfile)

      #
      # Start the instance
      #
      instance.addDialogs()
          
      #instance.buildForm(form)
      instance.activate()

    except GConnections.Error, mesg:
      self.handleError(mesg)

    except IOError, mesg:
      self.handleError(_("Unable to open file\n\n     %s")%mesg)

    except GDataObjects.ConnectError, mesg:
      self.handleError(\
         _("Unable to login to datasource.\n\n       %s") %mesg)

    except GDataObjects.ConnectionError, mesg:
      self.handleError(\
         _("Error while communicating with datasource.\n\n       %s") %mesg)

    except GDataObjects.Error, mesg:
      self.handleError(mesg)


  def handleStartupError(self, errortext):
    print
    print '-' * 60
    print _("Error: %s") % errortext
    print '-' * 60


  def handleError(self, mesg):
#    dlg = wxMessageDialog(self.frame, "Error: %s!" % mesg, \
#                          "Error", \
#                          wxOK)
#    dlg.ShowModal()

#    dlg.Destroy()

     print mesg


class MyWebBrowser(activex.Control, WebBrowserModule.WebBrowser):
  pass
#  def OnBeforeNavigate2(self, pDisp, URL, Flags, TargetFrameName, PostData, Headers, Cancel):
#    self.GetParent().OnNavigate(URL)


class BrowserFrame(window.Wnd):
  def __init__(self, url):
    self.url = url

  def Create(self, title, rect = None, parent = None):
    style = win32con.WS_CHILD | win32con.WS_VISIBLE
    window.Wnd.__init__(self, win32ui.CreateWnd ())
    self._obj_.AttachObject(self)
    self._obj_.CreateWindow(None, title, style, rect, parent, getNextId())
    rect = self.GetClientRect()
    rect = (0,0,rect[2]-rect[0], rect[3]-rect[1])
    self.ocx = MyWebBrowser()
    win32ui.EnableControlContainer()
    self.ocx.CreateControl("", style, rect, self, getNextId())    
    self.ocx.Navigate(self.url)
    self.HookMessage (self.OnSize, win32con.WM_SIZE)
    
  def OnSize (self, params):
    rect = self.GetClientRect()
    rect = (0,0,rect[2]-rect[0], rect[3]-rect[1])
    self.ocx.SetWindowPos(0, rect, 0)

