#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
# A QT-based user interface driver for GNUe forms.
#
# NOTES:
#
from qt import *

from gnue.forms.uidrivers.qt.widgets._base import UIHelper

#
# UIBox
#
# Widget set specific function that creates a single instance of a border box
#
class UIBox(UIHelper):
    
  def _createWidget(self, event, spacer):
    object = event.object
    
    # Create a group box..
    newWidget = QGroupBox(object.label, event.container)
        
    # ..and move it to it's proper place
    newWidget.setGeometry(object.Char__x*event.widgetWidth,
                          (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight,
                          (object.Char__width-1)*event.widgetWidth,
                                                         (object.Char__height-1)*event.widgetHeight)
#                          self.itemWidth,self.itemHeight)
    newWidget.lowerW()
    
    return newWidget

#
# Configuration data 
#
configuration = {
    'baseClass'  : UIBox,
    'provides'   : 'GFBox',
    'container'  : 0,
    }

