/* glib_addon.c
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "glib_addon.h"

/* recursive copy */
GNode*
g_node_copy (GNode* root, 
	     GNodeCopyData func, 
	     gpointer user_data)
{
  GNode*  new_root;
  GNode*  child;
  GNode*  new_child;
	
  g_return_val_if_fail (root != NULL, NULL);
  g_return_val_if_fail (func != NULL, NULL);
	
  new_root = func (root, user_data);
  if ( !G_NODE_IS_LEAF (root) ) {
    child = g_node_first_child (root);
    do {
      new_child = g_node_copy (child, func, user_data);
      g_node_append (new_root, new_child);
    } while ((child = g_node_next_sibling (child)) != NULL);
  }		
  return new_root;
}
