(* This file is part of an ocaml binding of an XSLT engine working on Gdome
 * documents.
 * 
 * The code is largely based on the code of T.J. Mather's XML::GDOME::XSLT
 * Perl module (http://kobesearch.cpan.org/search?dist=XML-GDOME-XSLT)
 *
 * Copyright (C) 2002 Claudio Sacerdoti Coen <sacerdot@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please send an email to <sacerdot@cs.unibo.it>
 *)

let (output_file,
     correct_output_file,
     input_file,
     stylesheet_file)  =
  ("../../test_files/output.xml",
   "../../test_files/output.xml.correct",
   "../../test_files/input.xml",
   "../../test_files/stylesheet.xsl")
in
let domImpl = Gdome.domImplementation () in
 let input =
  domImpl#createDocumentFromURI ~uri:input_file ()
 and style =
  domImpl#createDocumentFromURI ~uri:stylesheet_file ()
 in
  (* First of all, let's try the exception handling machinery *)
  let _ =
   try
    ignore (Gdome_xslt.processStylesheet input);
    assert false (* previous line should rise an exception *)
   with
    Gdome_xslt_init.ProcessStylesheetException -> ()
  in
  let pstyle = Gdome_xslt.processStylesheet style in
   let output =
    Gdome_xslt.applyStylesheet input pstyle
     ["parameter1","'value1'" ;
      "parameter2","'value2'" ;
      "parameter3","'value3'"
     ]
   in
(*  (* old version: use gdome serialization functions *)
    let res =
     domImpl#saveDocumentToFile ~doc:output ~name:output_file ()
    in
     if not res then
      prerr_endline ("Error saving to document " ^ output_file)
     else
      begin
       Printf.printf
        "The test was successful iff %s is equal to %s\n"
        output_file
        correct_output_file
      end
*)
  (* new version: use libxslt serialization functions *)
  let outchan = open_out output_file in
  Gdome_xslt.saveResultToChannel ~outchan ~result:output ~stylesheet:pstyle;
  close_out outchan;
  Printf.printf
   "The test was successful iff %s is equal to %s\n"
   output_file
   correct_output_file
;;
