#!/bin/bash

if [ ! -f Install_Seti_Sensor.bin ]
then
  echo "Please run the script from the seti-psi dir"
  exit 1
fi

if [ -d ~/.gdesklets/Themes/Psi-Disp-Themes/ ]
then

  # Adding seti sensors
  ./Install_Seti_Sensor.bin

  # Adding seti to the themes list created by Psi themes
  # I would like to add it anywhere after ping...
  cat ~/.gdesklets/Themes/Psi-Disp-Themes/icons/themes | sed 's/nonewmail ping/nonewmail ping seti/' > /tmp/psi.theme.tmp
  mv /tmp/psi.theme.tmp ~/.gdesklets/Themes/Psi-Disp-Themes/icons/themes

  # Copying display file
  cp seti.display ~/.gdesklets/psi-small

  # Copying icon
  cp seti.png ~/.gdesklets/Themes/Psi-Disp-Themes/icons/crystal

  # Running gdesklets with the new desklet file
  gdesklets ~/.gdesklets/psi-small/seti.display 
else

  # Refusing to run without a noticeable installation of psi themes.
  echo "Couldn't find ~/.gdesklets/Themes/Psi-Disp-Themes/, are you sure you have install psi themes support?"
fi
