
#ifndef  OBJECTTREEVIEWITEM_H
#define  OBJECTTREEVIEWITEM_H

#include <qlistview.h>

#include <string>
#include <map>

namespace libfwbuilder {
    class FWObject;
}

class ObjectTreeView;

class ObjectTreeViewItem : public QListViewItem {

    libfwbuilder::FWObject *objptr;
    QMap<QString, QString>  props;
    QString                 lib;
    
 public:

    ObjectTreeViewItem(QListView *parent) : QListViewItem(parent) {
        objptr=NULL;
    }

    ObjectTreeViewItem(QListViewItem *parent) : QListViewItem(parent){
        objptr=NULL;
    }

    libfwbuilder::FWObject *getFWObject() { return objptr; }
    void setFWObject(libfwbuilder::FWObject *obj) { objptr=obj; }

    ObjectTreeView* getTree();

    QString getLib() { return lib; }
    void        setLib(const QString &l) { lib=l; }

    QString getProperty(const QString &name) { return props[name]; }
    void        setProperty(const QString &name,const QString &val) {
        props[name]=val;
    }
};

#endif
