/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ObjectTreeView.h,v 1.11 2004/06/19 05:46:05 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef  __OBJECTTREEVIEW_H_
#define  __OBJECTTREEVIEW_H_

#include <qlistview.h>
#include <qdragobject.h>
#include <qiconview.h>
#include <qtimer.h>

#include <vector>

namespace libfwbuilder {
    class FWObject;
};

class ObjectTreeView : public QListView {

     Q_OBJECT

    QListViewItem   *item_before_drag_started;
    QListViewItem   *lastSelected;
    QTimer           singleClickTimer;
    bool             second_click;

    bool             selectionFrozen;

    std::vector<libfwbuilder::FWObject*>          selectedObjects;
        
 protected:

    virtual void dragEnterEvent( QDragEnterEvent *ev);
    virtual void dragMoveEvent( QDragMoveEvent *ev);
    virtual void dropEvent(QDropEvent *ev);
    virtual QDragObject* dragObject();
    virtual void dragLeaveEvent( QDragLeaveEvent *ev);

    virtual void contentsMousePressEvent( QMouseEvent *e );
    virtual void contentsMouseReleaseEvent( QMouseEvent *e );
    virtual void contentsMouseDoubleClickEvent( QMouseEvent *e );
    virtual void contentsMouseMoveEvent( QMouseEvent *e );
    virtual void keyPressEvent( QKeyEvent* ev );

 public:

    ObjectTreeView(QWidget* parent = 0, const char * name = 0, WFlags f = 0);

    void freezeSelection(bool f) { selectionFrozen=f; }

    std::vector<libfwbuilder::FWObject*>& getSelectedObjects()
        { return selectedObjects; }

    bool isSelected(libfwbuilder::FWObject* obj);
    int  getNumSelected();
    
 public slots:

     void selectionChanged();
     void resetSelection();
     void returnPressed(QListViewItem *itm);
     void currentChanged(QListViewItem *itm);

 signals:

//     void showObjectInfo_sign(libfwbuilder::FWObject *);
     void openObjectEditor_sign(libfwbuilder::FWObject *);
     void objectDropped_sign(libfwbuilder::FWObject *);
     void deleteObject_sign(libfwbuilder::FWObject *);
};


#endif

