%define name cyphesis
%define version 0.3.5
%define release 1

Summary: A simple personal server for the WorldForge project
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Amusements/Games
Source0: %{name}-%{version}.tar.gz
Source1: cyphesis.init
Source2: cyclient.init
Source3: cyphesis.sysconfig
Requires: Atlas-C++ >= 0.4.94 mercator varconf skstream >= 0.3.1 readline postgresql-libs >= 7.1 openssl python >= 1.5.2 libstdc++
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
BuildRequires: Atlas-C++-devel >= 0.4.94 mercator-devel varconf-devel >= 0.6.2 skstream-devel >= 0.3.1 readline-devel postgresql-devel >= 7.1 openssl-devel python-devel >= 1.5.2 libstdc++-devel

%description
Cyphesis is a very simple world simulator. NPCs that do things according to
rules. They have minds with simple input and output. They can
use/move/make things and have simple discussion. They can deduce
simple things (like where I can get these things and where I should
be). They have simple memory and use it too. They can have goals (like
build home for me or go to dinner).

%package service
Summary: Files for running cyphesis as a unix service
Group: System Environment/Daemons
PreReq: initscripts /usr/sbin/useradd /sbin/chkconfig
Requires: %{name} = %{version} %{name}-mason postgresql-server >= 7.1

%description service
Cyphesis is a very simple world simulator. This package allows it to be run
as a service controlled by init.

%package acorn
Summary: Game data for running the Acorn game in cyphesis
Group: Amusements/Games
Requires: %{name} = %{version}

%description acorn
This is the rules data, scripts and map data required for the Acorn
game. Install this package if you intend to run an Acorn server.
Acorn is deprecated. See README for details.

%package mason
Summary: Game data for running the Mason game in cyphesis
Group: Amusements/Games
Requires: %{name} = %{version}

%description mason
This is the rules data, scripts and map data required for the Mason
game. Install this package if you intend to run an Mason server.

%package werewolf
Summary: Game data for running the Werewolf game in cyphesis
Group: Amusements/Games
Requires: %{name} = %{version} %{name}-acorn

%description werewolf
This is the rules data, scripts and map data required for the Werewolf
game. Install this package if you intend to run an Werewolf server.
Werewolf is not yet functional.


%prep
%setup -q

%build
CXXFLAGS=$RPM_OPT_FLAGS %configure --enable-static
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
if [ -d /etc/rc.d/init.d ]
then
	install -d $RPM_BUILD_ROOT/etc/rc.d/init.d
	install -m 755 %{SOURCE1} $RPM_BUILD_ROOT/etc/rc.d/init.d/cyphesis
	install -m 755 %{SOURCE2} $RPM_BUILD_ROOT/etc/rc.d/init.d/cyclient
        echo /etc/rc.d/init.d/cyphesis >> service.lst
        echo /etc/rc.d/init.d/cyclient >> service.lst
fi
if [ -d /etc/sysconfig ]
then
	install -d $RPM_BUILD_ROOT/etc/sysconfig
	install -m 644 %{SOURCE3} $RPM_BUILD_ROOT/etc/sysconfig/cyphesis
        echo /etc/sysconfig/cyphesis >> service.lst
fi

%pre service
useradd -M -n -r -s /bin/bash -c "Cyphesis user" cyphesis >/dev/null 2>&1 || :

%post service
chkconfig --add cyphesis
chkconfig --add cyclient

%preun service
if [ $1 = 0 ] ; then
        chkconfig --del cyphesis
        chkconfig --del cyclient
fi

%postun service
if [ $1 -ge 1 ]; then
  /sbin/service cyphesis condrestart >/dev/null 2>&1
fi
if [ $1 = 0 ] ; then
        userdel cyphesis >/dev/null 2>&1 || :
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/cy*
%{_datadir}/cyphesis/rulesets/basic
%{_mandir}/man1/*.1.gz
%config %{_sysconfdir}/cyphesis/basic.xml
%config %{_sysconfdir}/cyphesis/cyphesis.vconf
%doc README COPYING AUTHORS THANKS NEWS

%files service -f service.lst
%defattr(-,root,root)

%files acorn
%defattr(-,root,root)
%config %{_sysconfdir}/cyphesis/acorn.xml
%{_datadir}/cyphesis/rulesets/acorn

%files mason
%defattr(-,root,root)
%config %{_sysconfdir}/cyphesis/mason.xml
%{_datadir}/cyphesis/rulesets/mason

%files werewolf
%defattr(-,root,root)
%config %{_sysconfdir}/cyphesis/werewolf.xml
%{_datadir}/cyphesis/rulesets/werewolf
