#!/usr/bin/env python
# -*- Mode: python -*-
#
# Copyright (C) 2002-2003 Mark Ferrell <xrxgrok@yahoo.com>
# Copyright (C) 2003 Charles Duffy <cduffy@spamcop.net>
#
# -----------------------------------------------------------------------
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
# -----------------------------------------------------------------------

import SCM.Revision

from StorageLayer import ChangesetDAO

class MemberError(ValueError): pass
class TagError(ValueError): pass

class ChangeSet(ChangesetDAO):

	def append(self, rev):
		"""append(scm.revision) -> None

		Appends specified revision to the changeset revision list.  If
		the revision is not a valid member of the changeset then a
		MemberError exception is raised.

		"""
		#if not isinstance(rev, SCM.Revision.Revision):
		#	raise ValueError, 'non-Revision type'

		log = rev.log
		branch = rev.branch
		author = rev.author
		filename = rev.filename

		if self.isBrandNew():
			self.log = log
			self.branch = branch
			self.author = author
		else:
			# We don't allow more then 1 revision of the
			# same file in the same changeset
			if self.containsNewRevisionForFile(filename):
				raise MemberError, "%s already has revision in changeset" % filename

			# If the log of this revision by this author is
			# the same as the log of the last changeset by
			# this author and on the same branch then the
			# rev belongs to the changeset, else make a new
			# one
			if log != self.log:
				raise MemberError, 'log mismatch'
			if branch != self.branchName:
				raise MemberError, 'branch mismatch (%s vs %s)' % (branch, self.branchName)
			if author != self.author:
				raise MemberError, 'author mismatch (%s vs %s)' % (author, self.author)

		# Fixup our start and end times for this changeset
		time = rev.time
		if self.starttime > time: self.starttime = time
		if self.endtime   < time: self.endtime = time

		# revisions specific to this changeset
		self._addRevision(rev)

# tag: Mark Ferrell Fri May 23 11:04:48 CDT 2003 (modules/SCM/ChangeSet.py)
