;;;
;;; BOUNCE-GLUT.LISP
;;;
;;; Translation of "bounce.c" by Brian Paul
;;; Changed to use RGB mode.
;;;

(in-package :cl-user)
(eval-when (:compile-toplevel :load-toplevel :execute)
  (require :gl))

(defpackage :bounce-glut
  (:use :cl :gl)
  (:export :main))

(in-package :bounce-glut)

(defun sind (x)
  (coerce (sin (* x (/ pi 180.))) 'single-float))

(defun cosd (x)
  (coerce (cos (* x (/ pi 180.))) 'single-float))

(defvar ball)
(defvar window)
(defvar Zrot)
(defvar Zstep)
(defvar Xpos)
(defvar Ypos)
(defvar Xvel)
(defvar Yvel)
(defvar Xmin)
(defvar Xmax)
(defvar Ymin)
(defvar Ymax)
(defvar G)
(defvar vel0)

(setq Zrot 0.0
      Zstep 0.6
      Xpos 0.0 Ypos 1.0
      Xvel 0.02 Yvel 0.0
      Xmin -4.0 Xmax 4.0
      Ymin -3.8 Ymax 4.0
      G -0.001
      vel0 -100.0)

(defun make-ball ()
  (let ((da 18.0) (db 18.0)
	(radius 1.0)
	(color 0)
	(x 0.0) (y 0.0) (z 0.0))
    
    (setq ball (glGenLists 1))
    (glNewList ball GL_COMPILE)
    
    (setq color 0)
    (do ((a -90.0 (+ a da))) ((> (+ a da) 90.0))
      ;;
      (glBegin GL_QUAD_STRIP)
      (do ((b 0.0 (+ b db))) ((> b 360.0))
	
	(format t "b:~a, color:~a~%" b color)
	(if (> color 0)
	  (glColor3f 1.0 0.0 0.0)
	  (glColor3f 1.0 1.0 1.0))
	
	(setq x (* (cosd b) (cosd a)))
	(setq y (* (sind b) (cosd a)))
	(setq z (sind a))
	(glVertex3f x y z)
	
	(setq x (* radius (cosd b) (cosd (+ a da))))
	(setq y (* radius (sind b) (cosd (+ a da))))
	(setq z (* radius (sind (+ a da))))
	(glVertex3f x y z)
	
	(setq color (- 1 color)))
      
      (glEnd))
    
    (glEndList)))

(defun reshape (width height)
  (format t "Callback RESHAPE. WIDTH:~a, HEIGHT:~a~%" width height)
  (glViewport 0 0 width height)
  (glMatrixMode GL_PROJECTION)
  (glLoadIdentity)
  (glOrtho -6d0 6d0 -6d0 6d0 -6d0 6d0)
  (glMatrixMode GL_MODELVIEW))

(defun idle ()
  (format t "Callback IDLE.~%")
  (setq zrot (+ zrot zstep))
  
  (setq xpos (+ xpos xvel))
  (when (>= xpos xmax)
    (setq xpos xmax)
    (setq xvel (- xvel))
    (setq zstep (- zstep)))
  ;;
  (when (<= xpos xmin)
    (setq xpos xmin)
    (setq xvel (- xvel))
    (setq zstep (- zstep)))
  ;;
  (setq ypos (+ ypos yvel))
  (setq yvel (+ yvel g))
  (when (< ypos ymin)
    (setq ypos ymin)
    (when (= vel0 -100.0) (setq vel0 (abs yvel)))
    (setq yvel vel0))
  (glutPostRedisplay))



(defun key (k x y)
  (format t "Callback KEY. K:~a, X:~a, Y:~a~%" k x y)
  (case (code-char k)
    (#\Escape
     ;;(glutDestroyWindow window)
     ;;(quit)
     ;; Use throw/catch to exit glutMainLoop
     (throw :exit-glut nil))))

(defun draw ()
  (format t "Callback DRAW.~%")
  (glClear GL_COLOR_BUFFER_BIT)
  (glColor3f 0.0 1.0 1.0)
  (glBegin GL_LINES)
  (do ((i -5 (+ i 1))) ((> i 5))
    (glVertex2i i -5) (glVertex2i i 5))
  ;;
  (do ((i -5 (+ i 1))) ((> i 5))
    (glVertex2i -5 i) (glVertex2i 5 i))
  ;;
  (do ((i -5 (+ i 1))) ((> i 5))
    (glVertex2i i -5) (glVertex2f (* i 1.15) -5.9))
  ;;
  (glVertex2f -5.3 -5.35)  (glVertex2f 5.3 -5.35)
  (glVertex2f -5.75 -5.9)  (glVertex2f 5.75 -5.9)
  (glEnd)
  
  (glPushMatrix)
  (glTranslatef Xpos Ypos 0.0)
  (glScalef 2.0 2.0 2.0)
  (glRotatef 8.0 0.0 0.0 1.0)
  (glRotatef 90.0 1.0 0.0 0.0)
  (glRotatef Zrot 0.0 0.0 1.0)
  
  (glCallList ball)
  (glPopMatrix)
  (glFlush)
  (glutSwapBuffers))

(defun visible (vis)
  (format t "Callback VISIBLE. VIS:~s~%" vis)
  (cond ((= vis GLUT_VISIBLE)
	 (glutIdleFunc #'idle))
	(t
	 (glutIdleFunc nil))))

(defun main ()
  ;;
  (glutInitDisplayMode (+ GLUT_RGB GLUT_DOUBLE))
  (glutInitWindowPosition 0 0)
  (glutInitWindowSize 600 600)
  (setq window (glutCreateWindow "Bounce"))

  (format t "*** Making ball~%")
  (make-ball)
  (format t "*** End making ball~%")
  
  (glcullface GL_BACK)
  (glenable GL_CULL_FACE)
  (gldisable GL_DITHER)
  (glshademodel GL_FLAT)
  
  (glutDisplayFunc #'draw)
  (glutReshapeFunc #'reshape)
  (glutIdleFunc #'idle)
  (glutKeyboardFunc #'key)
  (glutVisibilityFunc #'visible)

  (unwind-protect
       (catch :exit-glut
	 (glutMainLoop))
    ;; The window does not disappear on Solaris for some reason...
    ;; Possibly an Xlib problem?
    (glutDestroyWindow window)))