/* 
 * installer/install.c
 * 
 * Stuff to install bootsector/device stuff.
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<unistd.h>

#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>
#include<chos/mapfile.h>

#define BOOTPATH	"/boot" 	/* where the boot files are 	*/
#define STAGE2_ID	stage2id
#define BSECT_ID	bsectid
#define ID_LEN		6

char instdest[256];
char tmpstr[512];
char tmpstr2[512];

char*map_file=		BOOTPATH"/chos.map";
char*background_file=	BOOTPATH"/chos.background";

long emerg_sect;
char emerg_dev=0xff;

int map_set=0,background_set=0;

#define DO_XX(aa,bb)				\
void do_chos_##aa(char*n)			\
{						\
	int 	str_len;			\
						\
	if(aa##_set)				\
		return;				\
						\
	str_len=strlen(n);			\
						\
	if(!(aa##_file=(char*)malloc(str_len+1)))\
		die(-ENOMEM,NULL);		\
						\
	memcpy(aa##_file,n,str_len+1);		\
						\
	verbose("Using %s as " bb "\n",n);	\
}

DO_XX(map,"map file");
DO_XX(background,"a file to save background in");

#include<chos/bsect.h>

static void write_bs(char*,ChosBsect*);

// Install the bootsector
int install_it( void )
{
	int		desaddr;
	int		fd;
	ulong		s2addr[STAGE2SECTS];
	ulong		mapaddr[2];
	int		a;
	GEOMETRY	geo;

	ChosBsect*	bs;
	
	if(mh->default_image>=mh->nimages)
		die(-1,"Default image number is greater than the total number of images.\n");

	verbose("\n");
	
	if(sizeof(ChosBsect)!=4*(3+STAGE2SECTS+1+2))
		die(-1,"Fuck the gcc alignments...\n");
		
	if(!testing){
		finish_bg();
		mapaddr[0]=finish_map();
		mapaddr[1]=map[0]->next_map;
	}
	
	// Get the second stage loader
	fd=get_binary("loader",CHOS_LOADER,"a 2nd stage loader",&a);
	if(a/513+1!=STAGE2SECTS)
		die(-1,"%s is of invalid size\n",tmpstr);

	if(!get_device(fd,&geo))
		die(errno,tmpstr);
		
	for(a=0;a<STAGE2SECTS;a++){
		s2addr[a]=get_addr(fd,a,&geo);
		VER_BIOS(&geo,s2addr[a],tmpstr);
	}
	
	close(fd);

	// Get the bootsector into memory
	fd=get_binary("bsect",CHOS_BSECT,"bootsector",&a);
	
	if(a!=PARTTABLE_OFF-2)
		die(-1,"%s is of invalid size\n",tmpstr);
	
	if(!(bs=(ChosBsect*)malloc(a)))
		die(-1,"Outta memory. Can this happen?\n");
	
	if(read(fd,bs,a)!=a)
		die(errno,"%s",tmpstr);
	close(fd);
	
	// Build the bootsector
	
	// stage 2
	bs->stage2_drive=geo.device;
	for(a=0;a<STAGE2SECTS;a++)
		bs->stage2_sects[a]=s2addr[a];
	
	// map
	bs->map_drive=mapgeo.device;
	for(a=0;a<2;a++)
		bs->map_sects[a]=mapaddr[a];
	
	// emergency
	bs->emerg_drive=emerg_dev;
	bs->emerg_sect=emerg_sect;
	
	if(testing){
		verbose("Test succesful...\n");
		return;
	}

	// Install it

	write_bs(instdest,bs);

	verbose("Syncing...\n");
	sync();
	verbose("Done.\n");
	
	return 1;
}

void make_backup(int fd,char*p)
{
#ifndef NO_BACKUP
	char*	p2;
	int	bfd;
	
	// get basename
	p2=p+strlen(p);
	while(p2>p){
		if(*p2=='/'){
			p2++;	// just to make verbose look better ;)
			break;
		}
		p2--;
	}
	sprintf(tmpstr2,"/boot/bsect-backup.%s",p2);
	/*
	switch(bfd=access(tmpstr2,F_OK)){
	case -ENOENT:
		break;
	case 0:
		return;
	default:
		goto backup_err;
	}
	*/
	bfd=open(tmpstr2,O_RDWR|O_CREAT|O_EXCL,0600);
	
	if(errno==EEXIST)
		return;
		
	if(bfd<0){
backup_err:	
		fprintf(stderr,"Couldn't create boot sector backup file %s (%s)\n"
			       "You may continue the installation process anyway...\n",tmpstr2,strerror(errno));
		continue_yn();
		return;
	}
	verbose("Creating bootsector backup %s...\n",tmpstr2);
	
	if(lseek(fd,0,SEEK_SET)<0)
		die(errno,p);

	if(read(fd,tmpstr,SECTORSIZE)!=SECTORSIZE)
		die(errno,p);

	if(write(bfd,tmpstr,SECTORSIZE)!=SECTORSIZE)
		die(errno,tmpstr2);
		
	close(bfd);
#endif
}

void write_bs(char*p,ChosBsect*bs)
{
	int	fd;
	int	result;
	static unsigned short	bsect_valid=BOOTSECT_VALID;
	
	if((fd=open(p,O_RDWR))<0)
		die(errno,p);
		
	make_backup(fd,p);

	// Ooops... forgot this
	if(lseek(fd,0,SEEK_SET)<0)
		die(errno,p);

	verbose("Installing the bootsector on %s ...\n",p);
	
	result=(write(fd,bs,PARTTABLE_OFF)==PARTTABLE_OFF);
	if(result){
		result=(lseek(fd,512-2,SEEK_SET)==512-2);
		if(result)
        		result=(write(fd,&bsect_valid,2)==2);
	}
	if(!result){
		die(-1,"Error writing bootsector on %s (%s)!\n"
		       "The system may be UNBOOTABLE!\n",
			p,strerror(errno));
	}
	
	fsync(fd);
	close(fd);
}
