package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.BaseCheckTestCase;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;

public class IllegalImportCheckTest
extends BaseCheckTestCase
{
    public void testWithSupplied()
        throws Exception
    {
        final DefaultConfiguration checkConfig =
            createCheckConfig(IllegalImportCheck.class);
        checkConfig.addAttribute("illegalPkgs", "java.io");
        final String[] expected = {
            "9:1: Import from illegal package - java.io.*.",
        };
        verify(checkConfig, getPath("InputImport.java"), expected);
    }

    public void testWithDefault()
        throws Exception
    {
        final DefaultConfiguration checkConfig =
            createCheckConfig(IllegalImportCheck.class);
        final String[] expected = {
            "15:1: Import from illegal package - sun.net.ftpclient.FtpClient.",
        };
        verify(checkConfig, getPath("InputImport.java"), expected);
    }
}
