/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999, 2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <math.h>
#include <ctype.h>
#include <signal.h>

#include "absimg.h"

#ifdef HAVE_FNMATCH
#include <fnmatch.h>
#else
#include "fnmatch.h"
#endif

#include "config.h"
#include "gimpgradient.h"
#include "recurse.h"

#define ServeEvents if (stop_changing) {return;} else {while(gtk_events_pending()) gtk_main_iteration();}

static GdkWindow *_screensaver_window = NULL;
static GdkWindow *_own_window = NULL;
static GdkWindow *screensaver_window = NULL;
guint tid = 0;

extern guint restart_loop;

gboolean stop_changing = FALSE;
gboolean have_setup = FALSE;
gboolean change_pic = FALSE;

#define SET_BGCOL(clr)\
	{\
		if (!clr)\
		{ \
			gdk_color_alloc(gdk_colormap_get_system(), &prop->background);\
			gdk_gc_set_foreground(gc, &prop->background);\
			gdk_colormap_free_colors(gdk_colormap_get_system(), &prop->background, 1);\
		} \
		else \
			memcpy(clr, &prop->background, sizeof(GdkColor));\
	}

#ifdef NO_USLEEP
void usleep(usec)
unsigned long usec;
{
	struct timeval tout;

	tout.tv_sec = 0;
	tout.tv_usec = usec;
	select(0, NULL, NULL, NULL, &tout);
}
#endif

#ifdef NO_SETENV
int setenv(var, val, ovr)
char *var;
char *val;
int ovr;
{
	char *pom=g_malloc(strlen(var) + strlen(val) + 2);

	sprintf(pom, "%s=%s", var, val);
	return putenv(pom);
}

#define unsetenv(var) setenv(var, "", 1)

#endif

static int Switch(data)
gpointer data;
{
	if (tid)
	{
		gtk_timeout_remove(tid);
		tid = 0;
		change_pic = TRUE;
	}
	return FALSE;
}

static void chbg_screensaver_event_func(event, win)
GdkEvent *event;
GdkWindow **win;
{
	if (event->any.window == *win)
	{
		switch(event->any.type)
		{
			case GDK_BUTTON_RELEASE:
			case GDK_KEY_RELEASE:
				gdk_pointer_ungrab(GDK_CURRENT_TIME);
				gdk_keyboard_ungrab(GDK_CURRENT_TIME);
				gdk_window_hide(*win);
				ServeEvents
				if (!have_setup)
					gtk_exit(0);
				stop_changing = TRUE;
				break;
			case GDK_VISIBILITY_NOTIFY:
			case GDK_CONFIGURE:
				gdk_window_raise(*win);
				break;
			default: break;
		}
	}
	else
		gtk_main_do_event(event);
}

static void win_event_func(event)
GdkEvent *event;
{
	if (event->any.window == screensaver_window)
	{
		switch(event->any.type)
		{
			case GDK_KEY_RELEASE:
			{
				GdkEventKey *kevent = (GdkEventKey *)event;
				switch(kevent->keyval)
				{
					case GDK_Q:
					case GDK_q:
					case GDK_Escape:
						if (!have_setup)
							gtk_exit(0);
						stop_changing = TRUE;
					break;
					case GDK_n:
					case GDK_N:
					case GDK_space:
						Switch(NULL);
					break;
					default:
					break;
				}
			}
			break;
			default: 
			break;
		}
	}
	else
		gtk_main_do_event(event);
}

static void init_window()
{
	if (!_own_window)
	{
		GdkWindow	*root_window;
		GdkWindowAttr	wattr;

		root_window = GDK_ROOT_PARENT();
	
		wattr.title = "ChBg window";
		wattr.event_mask = GDK_KEY_RELEASE_MASK |
			GDK_KEY_PRESS_MASK;
		wattr.x = 0 ;
		wattr.y = 0;
		wattr.width = 100;
		wattr.height = 100;
		wattr.wclass = GDK_INPUT_OUTPUT;
		wattr.visual = gdk_window_get_visual(root_window);
		wattr.window_type = GDK_WINDOW_TOPLEVEL;
		wattr.override_redirect = FALSE;
		_own_window = gdk_window_new(root_window, &wattr ,
			GDK_WA_TITLE | GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_NOREDIR);
	}
	screensaver_window = _own_window;

	gdk_window_show(screensaver_window);
	gdk_window_raise(screensaver_window);
	gdk_event_handler_set((GdkEventFunc) win_event_func, NULL, NULL);
}

GdkWindow *chbg_init_full_win(old_win, _event_func, data)
GdkWindow *old_win;
void *_event_func;
void *data;
{
	GdkWindow *ret_win = old_win;

	if (!old_win)
	{
		GdkWindow	*root_window;
		GdkWindowAttr	wattr;
		guint		rw,rh;

		root_window = GDK_ROOT_PARENT();
		gdk_window_get_size(root_window, &rw, &rh);
	
		wattr.title = "ChBg window";
		wattr.event_mask = GDK_BUTTON_RELEASE_MASK |
			GDK_KEY_RELEASE_MASK |
			GDK_BUTTON_PRESS_MASK | 
			GDK_KEY_PRESS_MASK |
			GDK_VISIBILITY_NOTIFY_MASK |
			GDK_SUBSTRUCTURE_MASK;

		wattr.x = 0 ;
		wattr.y = 0;
		wattr.width = rw;
		wattr.height = rh;
		wattr.wclass = GDK_INPUT_OUTPUT;
		wattr.visual = gdk_window_get_visual(root_window);
		wattr.window_type = GDK_WINDOW_TOPLEVEL;
		wattr.override_redirect = TRUE;
		ret_win = gdk_window_new(root_window, &wattr ,
			GDK_WA_TITLE | GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_NOREDIR);
	}

	gdk_window_show(ret_win);
	gdk_window_raise(ret_win);
	gdk_keyboard_grab(ret_win, TRUE, GDK_CURRENT_TIME);
	gdk_pointer_grab(ret_win, TRUE,
		GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
		GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
		GDK_POINTER_MOTION_MASK,
		NULL, gdk_cursor_new (GDK_ARROW), GDK_CURRENT_TIME);
	
	gdk_event_handler_set((GdkEventFunc) _event_func, data, NULL);

	return ret_win;
}

void chbg_clear_window(window, type)
GdkWindow *window;
int type;
{
	gint i,j,k,l;
	gint w,h;

	chbg_status_what(gettext("Changing picture"), 0);

	gdk_window_get_size(window, &w, &h);

	switch (type)
	{
		case 1:
			gdk_window_clear(window);
		break;
		case 2:
			for (i = w/2 ; i ; i--)
			{
				gdk_window_clear_area(window, i, 0, 1, h);
				gdk_window_clear_area(window, w - i, 0, 1, h);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 3:
			for (i = h/2 ; i ; i--)
			{
				gdk_window_clear_area(window, 0, i, w, 1);
				gdk_window_clear_area(window, 0, h - i, w, 1);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 4:
			for (i = 0 ; i <= w/2 ; i++)
			{
				gdk_window_clear_area(window, i, 0, 1, h);
				gdk_window_clear_area(window, w - i, 0, 1, h);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 5:
			for (i = 0 ; i <= h/2 ; i++)
			{
				gdk_window_clear_area(window, 0, i, w, 1);
				gdk_window_clear_area(window, 0, h - i, w, 1);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 6:
			for (i = 0 ; i < h ; i++)
			{
				gdk_window_clear_area(window, 0, i, w, 1);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 7:
			for (i = 0 ; i < w ; i++)
			{
				gdk_window_clear_area(window, i, 0, 1, h);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 8:
			for (i = 0 ; i <= MAX(w/2,h/2) ; i++)
			{
				gdk_window_clear_area(window, w/2 - i, h/2 - i, 2*i + 1, 1);
				gdk_window_clear_area(window, w/2 - i, h/2 - i, 1, 2*i + 1);
				gdk_window_clear_area(window, w/2 - i, h/2 + i, 2*i + 1, 1);
				gdk_window_clear_area(window, w/2 + i, h/2 - i, 1, 2*i + 1);
				gdk_flush();
				usleep(cfg.speed/2);
				ServeEvents
			}
		break;
		case 9:
			for (i = 0 ; i <= MIN(w/2,h/2) ; i++)
			{
				gdk_window_clear_area(window, i,  i, w - 2*i, 1);
				gdk_window_clear_area(window, i, i, 1, h - 2*i);
				gdk_window_clear_area(window, i, h - i, w - 2*i + 1, 1);
				gdk_window_clear_area(window, w - i, i, 1, h - 2*i + 1);
				gdk_flush();
				usleep(cfg.speed/2);
				ServeEvents
			}
		break;
		case 10:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j < w ; j += i)
				{
					gdk_window_clear_area(window, j, 0, 1, h);
					gdk_flush();
				}
				usleep(3*cfg.speed);
				ServeEvents
			}
		break;
		case 11:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j < h ; j += i)
				{
					gdk_window_clear_area(window, 0, j, w, 1);
					gdk_flush();
				}
				usleep(10*cfg.speed);
				ServeEvents
			}
		break;
		case 12:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j < MAX(w, h) ; j += i)
				{
					gdk_window_clear_area(window, 0, j, w, 1);
					gdk_window_clear_area(window, j, 0, 1, h);
					gdk_flush();
				}
				usleep(5*cfg.speed);
				ServeEvents
			}
		break;
		case 13:
			for (i = 0 ; i < MAX(w,h) ; i++)
			{
				gdk_window_clear_area(window, i, 0, 1, i+1);
				gdk_window_clear_area(window, 0, i, i+1, 1);
				usleep(cfg.speed/32);
				gdk_flush();
				ServeEvents
			}
		break;
		case 14:
			for (i = 0 ; i <= MAX(w/2,h/2) ; i++)
			{
				gdk_window_clear_area(window, i, 0, 1, i+1);
				gdk_window_clear_area(window, 0, i, i+1, 1);
				gdk_window_clear_area(window, w - i, 0, 1, i+1);
				gdk_window_clear_area(window, w - i, i, i+1, 1); 
				gdk_window_clear_area(window, 0, h-i, i+1, 1);
				gdk_window_clear_area(window, i, h-i, 1, i+1);
				gdk_window_clear_area(window, w - i, h - i, 1, i + 1);
				gdk_window_clear_area(window, w - i, h - i, i + 1 ,1);


				usleep(cfg.speed/3);
				gdk_flush();
				ServeEvents
			}
		break;
		case 15:
#define BOX_SIZE cfg.box_size /* 16 */
			for(i = 0 ; i <= MAX(w,h) ; i += BOX_SIZE)
			{
				k = i;
				for (j = 0 ; j <= i ; j += BOX_SIZE, k -= BOX_SIZE)
				{
					if (k > (h/2 + BOX_SIZE) || j > (w/2 + BOX_SIZE)) continue;

					gdk_window_clear_area(window, j, k, BOX_SIZE, BOX_SIZE);
					gdk_window_clear_area(window, j, h-k, BOX_SIZE, BOX_SIZE);
					gdk_window_clear_area(window, w-j, k, BOX_SIZE, BOX_SIZE);
					gdk_window_clear_area(window, w-j, h-k, BOX_SIZE, BOX_SIZE);

					gdk_flush();
					usleep(cfg.speed/3);
				}
				ServeEvents
			}
		break;
		case 16:
			for(k = 0 ; k <= MIN(h/2,w/2) ; k += 2*BOX_SIZE)
			{
				for(i = k ; i <= (w - k) ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, i, k, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k)  ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, w - k - 2*BOX_SIZE, i, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (w - k) ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, w - i, h - k - 2*BOX_SIZE, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k) ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, k, h - i, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				ServeEvents
			}
		break;
		case 17:
			for(k = MIN(h/2,w/2) ; k > -2*BOX_SIZE ; k -= 2*BOX_SIZE)
			{
				for(i = k + 2*BOX_SIZE ; i <= (w - k) ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, i, k, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k)  ; i += 2*BOX_SIZE)
				{
					/*gdk_window_clear_area(window, w - k, h - i, 2*BOX_SIZE, 2*BOX_SIZE);*/
					gdk_window_clear_area(window, w - k, i, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (w - k) ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, w - i, h - k, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k + 2*BOX_SIZE) ; i += 2*BOX_SIZE)
				{
					gdk_window_clear_area(window, k, h - i, 2*BOX_SIZE, 2*BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				ServeEvents
			}
		break;
		case 18:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j <= MAX(w/2, h/2) ; j += i)
				{
					gdk_window_clear_area(window, 0, h/2 + j, w, 1);
					gdk_window_clear_area(window, 0, h/2 - j, w, 1);
					gdk_window_clear_area(window, w/2 - j, 0, 1, h);
					gdk_window_clear_area(window, w/2 + j, 0, 1, h);
					usleep(cfg.speed/20);
				}
				usleep((i/32)*cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 19:
			for (k = 8 ; k ; k--)
			{
				for (j = 0 ; j <= h/BOX_SIZE ; j++)
				{
					for(i = ((k + j) % 8) * BOX_SIZE  ; i < w ; i+= 8 * BOX_SIZE)
					{
						gdk_window_clear_area(window, i ,  j * BOX_SIZE, BOX_SIZE, BOX_SIZE);
					}
					usleep(cfg.speed/2);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 20:
			for (k = 8 ; k ; k--)
			{
				l = 8;
				for (j = 0 ; j <= h/BOX_SIZE ; j++)
				{
					l += ((j/8)%2 ? 1 : -1);
					for(i = ((k - l) % 8) * BOX_SIZE  ; i < w ; i+= 8 * BOX_SIZE)
					{
						gdk_window_clear_area(window, i ,  j * BOX_SIZE, BOX_SIZE, BOX_SIZE);
					}
					usleep(cfg.speed);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 21:
			for (i = 0 ; i <= w ; i += BOX_SIZE)
			{
				for (j = 0 ; j <= h ; j += BOX_SIZE)
				{
					if ((j/BOX_SIZE) % 2)
						gdk_window_clear_area(window, w - i - BOX_SIZE, j, BOX_SIZE, BOX_SIZE);
					else
						gdk_window_clear_area(window, i, j, BOX_SIZE, BOX_SIZE);
				}
				usleep(cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 22:
			for (i = 0 ; i <= h ; i += BOX_SIZE)
			{
				for (j = 0 ; j <= w ; j += BOX_SIZE)
				{
					if ((j/BOX_SIZE) % 2)
						gdk_window_clear_area(window, j, h - i - BOX_SIZE, BOX_SIZE, BOX_SIZE);
					else
						gdk_window_clear_area(window, j, i, BOX_SIZE, BOX_SIZE);
				}
				usleep(cfg.speed/2);
				gdk_flush();
				ServeEvents
			}
		break;
		case 23:
			for (i = 0 ; i < w * h * 2 ; i += 16*BOX_SIZE*BOX_SIZE)
			{
				j = (int) ((float)chbg_rand() * (((float)(w * h)/(float) (16*BOX_SIZE*BOX_SIZE)) / (float)RAND_MAX));

				k = (j / (w/(4*BOX_SIZE))) * 4 * BOX_SIZE;
				l = (j % (w/(4*BOX_SIZE))) * 4 * BOX_SIZE;

				gdk_window_clear_area(window, l, k, 4*BOX_SIZE, 4*BOX_SIZE);
				gdk_flush();
				usleep(cfg.speed/50);
				ServeEvents
			}
			for (i = 0 ; i <= h ; i += BOX_SIZE)
			{
				gdk_window_clear_area(window, 0, i, w, BOX_SIZE);
				usleep(cfg.speed/10);
				gdk_flush();
				ServeEvents
			}
		break;
		case 24:
			for (i = 0 ; i < (h+2*BOX_SIZE) ; i += 2*BOX_SIZE)
			{
				for(j = 0 ; j <= (w+2*BOX_SIZE) ; j += 2*BOX_SIZE)
				{
					if ((i/(2*BOX_SIZE))%2)
						gdk_window_clear_area(window, w - j, i, 2*BOX_SIZE, 2*BOX_SIZE);
					else
						gdk_window_clear_area(window, j, i, 2*BOX_SIZE, 2*BOX_SIZE);

					usleep(cfg.speed/50);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 25:
			for (i = 0 ; i < (w+2*BOX_SIZE) ; i += 2*BOX_SIZE)
			{
				for(j = 0 ; j < (h+2*BOX_SIZE) ; j += 2*BOX_SIZE)
				{
					if ((i/(2*BOX_SIZE))%2)
						gdk_window_clear_area(window, i, h - j, 2*BOX_SIZE, 2*BOX_SIZE);
					else
						gdk_window_clear_area(window, i, j, 2*BOX_SIZE, 2*BOX_SIZE);

					usleep(cfg.speed/50);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 26:
			for (i = 0 ; i <= w ; i += 2)
			{
				gdk_window_clear_area(window, i, 0, 1, h);
				gdk_window_clear_area(window, w - i + (w%2 ? 0 : 1), 0, 1, h);
				usleep(cfg.speed/50);
				gdk_flush();
				ServeEvents
			}
		break;
		case 27:
			for (i = 0 ; i <= h ; i += 2)
			{
				gdk_window_clear_area(window, 0, i, w, 1);
				gdk_window_clear_area(window, 0, h - i + (h%2 ? 0 : 1), w, 1);
				usleep(cfg.speed/50);
				gdk_flush();
				ServeEvents
			}
		break;
		case 28:
			for (i = 0 ; i <= w ; i += BOX_SIZE)
			{
				for (j = 0 ; j <= h ; j += BOX_SIZE)
				{
					k = (int)((float)3*(float)chbg_rand()/(RAND_MAX+1.0));
					gdk_window_clear_area(window, i + (k*BOX_SIZE), j, BOX_SIZE, BOX_SIZE);
				}
				gdk_window_clear_area(window, i, 0, BOX_SIZE, h);
				usleep(cfg.speed/2);
				gdk_flush();
				ServeEvents
			}
			gdk_window_clear(window);
		break;
		case 29:
			k = (1+w/BOX_SIZE);
			k = (k + (1-k%2))*BOX_SIZE;
			l = (1+h/BOX_SIZE);
			l = (l + (1-l%2))*BOX_SIZE;

			for (i = 0 ; i <= MAX(w,h) ; i += 2 * BOX_SIZE)
			{
				gdk_window_clear_area(window, i, 0, BOX_SIZE, h);
				gdk_window_clear_area(window, k - i, 0, BOX_SIZE, h);
				gdk_window_clear_area(window, 0, i, w, BOX_SIZE);
				gdk_window_clear_area(window, 0, l - i, w, BOX_SIZE);
				
				usleep(20*cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		default:
			gdk_window_clear(window);
	}
#ifdef HAVE_XSS_SUPPORT
	if (cfg.send_expose && cfg.infwindow)
	{
		XEvent evt;

		memset(&evt, '\0', sizeof(evt));
		evt.xexpose.type = Expose;
		evt.xexpose.window = GDK_WINDOW_XWINDOW(window);
		evt.xexpose.display = GDK_DISPLAY();
		evt.xexpose.send_event = TRUE;
		evt.xexpose.x = 0;
		evt.xexpose.y = 0;
		evt.xexpose.width = w;
		evt.xexpose.height = h;
		evt.xexpose.count = 0;

		XSendEvent(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(window),
			False, NoEventMask, &evt);
	}
#endif
}

static void set_root_fake_nautilus(rb)
absimg_rgb_t *rb;
{
	char *pic,*bak,*bg;
	FILE *f;
	static int i = 1;

	i = (i + 1) % 2;
	pic = g_strdup_printf("/tmp/chbg_nautilus-%d-%s@%s.png", i,
			g_get_user_name(), gdk_get_display());

	absimg_rgb_savePNG(rb, pic);

	bg = g_strconcat(g_get_home_dir(), "/.gnome/Background", NULL);
	bak = g_strconcat(bg, ".bak");
	rename(bg, bak);

	f = fopen(bg, "w");
	if (f)
	{
		fprintf(f, "\n[Default]\nsimple=solid\nwallpaper=%s\n", pic);
		fclose(f);
	}
	else
		rename(bak, bg);

	g_free(bak);
	g_free(bg);
	g_free(pic);
}

static void set_blank_screen_real(prop, rb, w, h)
prop_t *prop;
absimg_rgb_t **rb;
guint w;
guint h;
{
	GdkGC *gc = NULL;
	GdkPixmap *pixmap = NULL;
	GdkWindow *root_window;
	guint rw = 1,rh = 1;

	chbg_status_what(gettext("Blanking screen"), 0);

	root_window = (cfg.screensaver || cfg.xscreensaver ||
		       cfg.inwindow || cfg.infwindow) ?
			screensaver_window : GDK_ROOT_PARENT();

	if (w && h)
	{
		rw = w;
		rh = h;
	}
	else
		gdk_window_get_size(root_window, &rw, &rh);

	gc = gdk_gc_new(root_window);
	SET_BGCOL(NULL);

	if ((prop->use_banners && prop->banner) || rb || cfg.fake_nautilus)
	{
		GdkColor color;
		absimg_rgb_t *shbuf;

		shbuf = absimg_rgb_new(rw, rh);

		SET_BGCOL(&color);
		absimg_rgb_fill(shbuf, (color.red >> 8),
			(color.green >> 8), (color.blue >> 8));
				
		shader_shade_pixmap(prop, NULL, NULL, rw, rh, TRUE,
			NULL, shbuf);

		if (prop->banner)
			banner_render_to_rgb(shbuf, prop->banner);

		if (!cfg.inwindow && !cfg.screensaver && !cfg.infwindow &&
		    !cfg.xscreensaver && cfg.fake_nautilus)
			set_root_fake_nautilus(shbuf);

		if (rb)
			*rb = shbuf;
		else
		{
			pixmap = gdk_pixmap_new(root_window, rw, rh,
					gdk_visual_get_best_depth());

			gdk_draw_rgb_image(pixmap, gc, 0, 0,
				shbuf->width, shbuf->height,
				GDK_RGB_DITHER_NORMAL,
				shbuf->rgb, 3*shbuf->width);

			absimg_rgb_free(shbuf);
		}
	}
	else
	{
		if (prop->shade)
		{
			pixmap = gdk_pixmap_new(root_window, rw, rh,
					gdk_visual_get_best_depth());
			gdk_draw_rectangle(pixmap, gc, TRUE, 0, 0, rw, rh);
			shader_shade_pixmap(prop, pixmap, gc, rw, rh, TRUE,
				NULL, NULL);
		}
		else
		{
			pixmap = gdk_pixmap_new(root_window, 1, 1,
					gdk_visual_get_best_depth());
			gdk_draw_point(pixmap, gc, 0, 0);
		}
	}

	if (pixmap)
	{
		gdk_window_set_back_pixmap(root_window, pixmap, FALSE);
		chbg_clear_window(root_window, prop->efect);

#ifdef HAVE_ESETROOT_SUPPORT
		if (!cfg.inwindow && !cfg.screensaver && !cfg.infwindow &&
		    !cfg.xscreensaver && !stop_changing)
			esetroot_pixmap_property(root_window,pixmap,rw,rh,prop);
#endif /* HAVE_ESETROOT_SUPPORT */

		gdk_pixmap_unref(pixmap);
	}
	gdk_gc_unref(gc);

	gdk_flush();
}


static void set_blank_screen(prop)
prop_t *prop;
{
	set_blank_screen_real(prop, NULL, 0, 0);
}

int set_root_bg_real(root_window, image, prop, rb, w, h, isroot)
GdkWindow **root_window;
absimg_image_t 	*image;
prop_t *prop;
absimg_rgb_t **rb;
guint w;
guint h;
gint isroot;
{
	GdkPixmap	*pixmap = NULL;
	guint		rw,rh;
	absimg_rgb_t	*shbuf = NULL;

	if (w && h)
	{
		rw = w;
		rh = h;
	}
	else
		gdk_window_get_size(*root_window, &rw, &rh);

	if (rb || absimg_have_alpha(image) ||
	    (isroot && cfg.fake_nautilus) ||
	    (prop->use_banners && prop->banner))
	{
		shbuf = absimg_rgb_new(rw, rh);
		if (rb)
			*rb = shbuf;
	}

	switch (prop->type)
	{
		case RENDERT_TILE:
			rw = image->rgb_width;
			rh = image->rgb_height;

			if (shbuf)
				absimg_rgb_tile(shbuf, image, rw, rh);
			else
				pixmap = absimg_render(image, rw, rh);
		break;
		case RENDERT_SYM_MIRROR:
		case RENDERT_INT_MIRROR:
		case RENDERT_MIRROR:
		{
			GdkPixmap *p1;
			GdkGC *gc;
			guint w,h;

			w = image->rgb_width;
			h = image->rgb_height;

			if (prop->type == RENDERT_INT_MIRROR)
			{
				/* detract picture */
				if (rw%w)
					w = rw/(rw/w + 1);
				if (rh%h)
					h = rh/(rh/h + 1);
			}


			pixmap = gdk_pixmap_new(*root_window, 2*w, 2*h,
				gdk_visual_get_best_depth());

			gc = gdk_gc_new(*root_window);
			SET_BGCOL(NULL);

			gdk_draw_rectangle(pixmap, gc, TRUE, 0, 0, 2*w, 2*h);

			p1 = absimg_render(image, w, h);
			gdk_draw_pixmap(pixmap, gc, p1 ,
				0, 0, 0, 0, w, h);
			absimg_destroy_pixmap(p1);


			absimg_flip_vertical(image);
			p1 = absimg_render(image, w, h);
			gdk_draw_pixmap(pixmap, gc, p1 ,
				0, 0, 0, h, w, h);
			absimg_destroy_pixmap(p1);


			absimg_flip_horizontal(image);
			p1 = absimg_render(image, w, h);
			gdk_draw_pixmap(pixmap, gc, p1 ,
				0, 0, w, h, w, h);
			absimg_destroy_pixmap(p1);


			absimg_flip_vertical(image);
			p1 = absimg_render(image, w, h);
			gdk_draw_pixmap(pixmap, gc, p1 ,
				0, 0, w, 0, w, h);
			absimg_destroy_pixmap(p1);

			if (prop->type == RENDERT_SYM_MIRROR)
			{
				gint xof,yof;

				w *= 2;
				h *= 2;

				xof = (rw/2 % w);

				yof = (rh/2 % h);

				p1 = pixmap;

				pixmap = gdk_pixmap_new(*root_window, w, h,
					gdk_visual_get_best_depth());

				gdk_draw_pixmap(pixmap, gc, p1,
					0, 0, xof, yof, w-xof, h-yof);
				gdk_draw_pixmap(pixmap, gc, p1,
					w-xof, h-yof, 0, 0, xof, yof);
				gdk_draw_pixmap(pixmap, gc, p1,
					w-xof, 0, 0, yof, xof, h-yof);
				gdk_draw_pixmap(pixmap, gc, p1,
					0, h-yof, xof, 0, w-xof, yof);

				gdk_pixmap_unref(p1);
			}

			gdk_gc_unref(gc);
		}
		break;
		case RENDERT_CENTER:
		{
			if (shbuf)
			{
				shader_shade_pixmap(prop, NULL, NULL, rw, rh,
					TRUE, NULL, shbuf);

				absimg_render_to_rgb(shbuf, image,
					image->rgb_width, image->rgb_height,
					prop->xpos, prop->ypos);
			}
			else
			{
				GdkPixmap *p1;
				GdkGC *gc;

				gc = gdk_gc_new(*root_window);
				SET_BGCOL(NULL);

				pixmap = gdk_pixmap_new(*root_window, rw, rh,
					gdk_visual_get_best_depth());
				gdk_draw_rectangle(pixmap, gc, TRUE, 0, 0,
					rw, rh);

				shader_shade_pixmap(prop, pixmap, gc, rw, rh, TRUE, NULL, NULL);

				p1 = absimg_render(image, image->rgb_width, image->rgb_height);
				gdk_draw_pixmap(pixmap, gc, p1 ,
					0, 0,
					(rw - image->rgb_width) / 2,
					(rh - image->rgb_height) / 2,
					image->rgb_width, image->rgb_height);
				absimg_destroy_pixmap(p1);

				gdk_gc_unref(gc);
			}
		}
		break;
		case RENDERT_MAXIMIZE:
			if (shbuf)
				absimg_rgb_tile(shbuf, image, rw, rh);
			else
				pixmap = absimg_render(image, rw, rh);
		break;
		case RENDERT_SMART:
		{
			gfloat ratio;
			guint pw, ph;

			ratio = MIN((gfloat)((rw * prop->max_size)/100.0) / (gfloat)image->rgb_width ,
				(gfloat)((rh * prop->max_size)/100.0) / (gfloat)image->rgb_height);

			ratio = MIN(prop->max_grow, ratio);

			pw = (guint)(ratio * image->rgb_width);
			ph = (guint)(ratio * image->rgb_height);

			if (shbuf)
			{
				shader_shade_pixmap(prop, NULL, NULL, rw, rh,
					TRUE, NULL, shbuf);

				absimg_render_to_rgb(shbuf, image, pw, ph,
					prop->xpos, prop->ypos);
			}
			else
			{
				GdkGC *gc;
				GdkPixmap *p1;

				gc = gdk_gc_new(*root_window);
				SET_BGCOL(NULL);

				pixmap = gdk_pixmap_new(*root_window, rw, rh,
					gdk_visual_get_best_depth());

				gdk_draw_rectangle(pixmap, gc, TRUE, 0, 0, rw, rh);

				shader_shade_pixmap(prop, pixmap, gc, rw, rh, TRUE, NULL, NULL);

				p1 = absimg_render(image, pw, ph);

				gdk_draw_pixmap(pixmap, gc, p1,
					0, 0,
					(rw - pw) * prop->xpos,
					(rh - ph) * prop->ypos, pw, ph);

				absimg_destroy_pixmap(p1);
				gdk_gc_unref(gc);
			}
		}
		break;
		case RENDERT_CENTER_TILE:
		{
			GdkPixmap *p1;
			GdkGC *gc;
			guint w,h,xof,yof;

			w = image->rgb_width;
			h = image->rgb_height;

			if ((rw/2/w)%2)
				xof = w - (rw % w) / 2;
			else
				xof = (rw % w) / 2;

			if ((rh/2/h)%2)
				yof = h - (rh % h) / 2;
			else
				yof = (rh % h) / 2;

			gc = gdk_gc_new(*root_window);
			SET_BGCOL(NULL);

			p1 = absimg_render(image, w, h);

			pixmap = gdk_pixmap_new(*root_window, w, h,
				gdk_visual_get_best_depth());

			gdk_draw_pixmap(pixmap, gc, p1,
				0, 0, xof, yof, w-xof, h-yof);
			gdk_draw_pixmap(pixmap, gc, p1,
				w-xof, h-yof, 0, 0, xof, yof);
			gdk_draw_pixmap(pixmap, gc, p1,
				w-xof, 0, 0, yof, xof, h-yof);
			gdk_draw_pixmap(pixmap, gc, p1,
				0, h-yof, xof, 0, w-xof, yof);

			absimg_destroy_pixmap(p1);
			gdk_gc_unref(gc);
		}
		break;
		case RENDERT_INT_TILE:
		{
			guint w,h;

			w = image->rgb_width;
			h = image->rgb_height;

			/* detract picture */
			if (rw%w)
				w = rw/(rw/w + 1);
			if (rh%h)
				h = rh/(rh/h + 1);

			if (shbuf)
				absimg_rgb_tile(shbuf, image, w, h);
			else
				pixmap = absimg_render(image, w, h);
		}
		break;
		case RENDERT_SYM_TILE:
		{
			GdkPixmap *p1;
			GdkGC *gc;
			gint w,h,xof,yof;

			w = image->rgb_width;
			h = image->rgb_height;

			xof = (rw/2 % w);

			yof = (rh/2 % h);

			gc = gdk_gc_new(*root_window);
			SET_BGCOL(NULL);

			p1 = absimg_render(image, w, h);

			pixmap = gdk_pixmap_new(*root_window, w, h,
				gdk_visual_get_best_depth());

			gdk_draw_pixmap(pixmap, gc, p1,
				0, 0, xof, yof, w-xof, h-yof);
			gdk_draw_pixmap(pixmap, gc, p1,
				w-xof, h-yof, 0, 0, xof, yof);
			gdk_draw_pixmap(pixmap, gc, p1,
				w-xof, 0, 0, yof, xof, h-yof);
			gdk_draw_pixmap(pixmap, gc, p1,
				0, h-yof, xof, 0, w-xof, yof);

			absimg_destroy_pixmap(p1);
			gdk_gc_unref(gc);
		}
		break;
	}

	if (shbuf && pixmap)
	{
		absimg_image_t *tempi;
		guint w,h;

		gdk_window_get_size(pixmap, &w, &h);
		tempi = absimg_from_pixmap(pixmap);
		absimg_destroy_pixmap(pixmap);
		pixmap = NULL;

		absimg_rgb_tile(shbuf, tempi, w, h);
		absimg_destroy(tempi);
	}

	if (shbuf && prop->use_banners && prop->banner)
	{
		banner_render_to_rgb(shbuf, prop->banner);
	}

	if (shbuf && !rb)
	{
		GdkGC *gc;

		gc = gdk_gc_new(*root_window);
		SET_BGCOL(NULL);

		pixmap = gdk_pixmap_new(*root_window,
			shbuf->width, shbuf->height,
			gdk_visual_get_best_depth());

		gdk_draw_rgb_image(pixmap, gc, 0, 0,
			shbuf->width, shbuf->height,
			GDK_RGB_DITHER_NORMAL,
			shbuf->rgb, 3*shbuf->width);

		if (isroot && cfg.fake_nautilus)
			set_root_fake_nautilus(shbuf);

		absimg_rgb_free(shbuf);
		gdk_gc_unref(gc);
	}

	if (!stop_changing && !rb)
	{
		if (have_setup) 
			while(gtk_events_pending()) gtk_main_iteration();

		if (*root_window)
		{
			gdk_window_set_back_pixmap(*root_window, pixmap, FALSE);

			chbg_clear_window(*root_window, prop->efect);
#ifdef HAVE_ESETROOT_SUPPORT
			if (isroot)
				esetroot_pixmap_property(*root_window,
					pixmap,rw,rh,prop);
#endif /* HAVE_ESETROOT_SUPPORT */
		}
	}

	if (!rb)
		absimg_destroy_pixmap(pixmap);

	return 0;
}

static int set_root_bg_load(root_window, imgname, prop)
GdkWindow *root_window;
gchar *imgname;
prop_t *prop;
{
	absimg_image_t 	*image;
	rendering_type	type,stype;
	guint rw,rh;
	int rv;
	int isroot;

	chbg_status_what(gettext("Loading image"), 0);

	chbg_status_progress(0,1);

	image = absimg_load(imgname);

	if (!image)
		return -1;

	stype = prop->type;

	if (cfg.inwindow && screensaver_window)
	{
		rw = image->rgb_width;
		rh = image->rgb_height;
		gdk_window_resize(screensaver_window, rw, rh);
		while(gtk_events_pending())gtk_main_iteration();
		type = RENDERT_CENTER;
	}
	else
	{
		gdk_window_get_size(root_window, &rw, &rh);
	}

	chbg_status_progress(1,1);

	type = prop->type;

	chbg_status_what(gettext("Adjusting image"), 0);

	stype = prop->type;

	isroot = (!cfg.infwindow && !cfg.inwindow &&
		  !cfg.screensaver && !cfg.use_ebg &&
		  !cfg.xscreensaver && !stop_changing);

	rv = set_root_bg_real(&root_window, image, prop, NULL, 0, 0, isroot);

	prop->type = stype;

	absimg_destroy(image);
	gdk_flush();
	chbg_status_progress(0,1);

	return rv;
}

static int set_root_to_file(imgname, prop, filename, w, h)
gchar *imgname;
prop_t *prop;
char *filename;
guint w;
guint h;
{
	absimg_image_t 	*image;
	absimg_rgb_t *res;
	GdkWindow *rw;
	int rv = 0;

	if (imgname)
	{
		chbg_status_what(gettext("Loading image"), 0);

		chbg_status_progress(0,1);

		image = absimg_load(imgname);

		if (!image)
			return -1;

		rw = GDK_ROOT_PARENT();
		rv = set_root_bg_real(&rw, image, prop, &res, w, h, FALSE);

		absimg_destroy(image);
	}
	else
		set_blank_screen_real(prop, &res, w, h);

	chbg_status_progress(0,1);

	absimg_rgb_savePNG(res, filename);

	absimg_rgb_free(res);

	return rv;
}

static int set_root_ebg(imgname, prop)
gchar *imgname;
prop_t *prop;
{
	gchar *command,*p,*spec = NULL;
	GdkColor color;
	GdkGC *gc;
	int rv = 0;

	SET_BGCOL((&color));

	p = g_strdup_printf("eesh <<EOF\n"
			    "background chbg\n"
	       		    "background chbg bg.solid %d %d %d\n",
			    color.red, color.green, color.blue);

	if (prop->use_tiles || prop->use_banners || prop->shade)
	{
		char pom[2048];

		sprintf(pom, "/tmp/chbg_ebg-%s@%s.png", g_get_user_name(), gdk_get_display());

		rv = set_root_to_file(imgname, prop, pom, 0, 0);

		spec = g_strdup_printf("background chbg top.file %s\n"
				       "background chbg top.xjust 512\n"
				       "background chbg top.yjust 512\n",
				       pom);
	}
	else switch (prop->type)
	{
		case RENDERT_TILE:
		case RENDERT_MIRROR:
		case RENDERT_CENTER_TILE:
		case RENDERT_INT_TILE:
		case RENDERT_SYM_TILE:
		case RENDERT_INT_MIRROR:
		case RENDERT_SYM_MIRROR:
			spec = g_strdup_printf("background chbg bg.file %s\n"
					       "background chbg bg.tile 1\n",
						imgname);
		break;
		case RENDERT_CENTER:
			spec = g_strdup_printf("background chbg top.file %s\n"
					       "background chbg top.xjust 512\n"
					       "background chbg top.yjust 512\n",
					       imgname);
		break;
		case RENDERT_MAXIMIZE:
			spec = g_strdup_printf("background chbg top.file %s\n"
					       "background chbg top.xjust 512\n"
					       "background chbg top.yjust 512\n"
					       "background chbg top.xperc 1024\n"
					       "background chbg top.yperc 1024\n",
					       imgname);
		break;
		case RENDERT_SMART:
		{
			guint rw,rh,iw,ih;
			absimg_image_t 	*image;
			gfloat ratio;

			image = absimg_load(imgname);

			if (image)
			{
				iw = image->rgb_width;
				ih = image->rgb_height;
				absimg_destroy(image);
			}
			else
			{
				iw = 0;
				ih = 0;
			}

			gdk_window_get_size(GDK_ROOT_PARENT(), &rw, &rh);

			if (iw && ih)
			{
				ratio = MIN((gfloat)((rw * prop->max_size)/100) / (gfloat)iw ,
					(gfloat)((rh * prop->max_size)/100) / (gfloat)ih);

				ratio = MIN(prop->max_grow, ratio);
			}
			else
				ratio = 1.0;

			spec = g_strdup_printf("background chbg top.file %s\n"
					       "background chbg top.xjust 512\n"
					       "background chbg top.yjust 512\n"
					       "background chbg top.xperc %d\n"
					       "background chbg top.yperc %d\n"
					       "background chbg top.keep_aspect 1\n",
					       imgname,
					       (guint)(ratio * 1024),
					       (guint)(ratio * 1024));
		}
		break;
	}

	if (!rv)
	{
		char *dsks = NULL, *pom;
		int ndesks = 1;
		char resp[1024];
		FILE *f = popen("eesh -ewait \"num_desks ?\"", "r");

		if (f)
		{
			if (!fgets(resp, sizeof(resp)-1,f) ||
			    !sscanf(resp, "Number of Desks: %d\n", &ndesks))
				ndesks = 1;
			pclose(f);
		}

		for (; ndesks; ndesks --)
		{
			sprintf(resp, "use_bg chbg %d\n", ndesks - 1);
			pom = dsks;
			if (pom)
			{
				dsks = g_strconcat(dsks, resp, NULL);
				g_free(pom);
			}
			else
				dsks = g_strdup(resp);
		}

		command = g_strconcat(p, spec, dsks, "EOF", NULL);
		g_free(p);
		g_free(spec);
		system (command);
		g_free (command);
	}

       return rv;
}



static guint chbg_prop_get_effect(prop)
prop_t *prop;
{
	guint type = prop->efect;
	int i,j;

	if (type == 1)
	{
		GSList *ptr = cfg.d_effects;
		i = CHBG_EFECTS;
		while(ptr)
		{
			if (((int) ptr->data) < CHBG_EFECTS)
				i--;
			ptr = ptr->next;
		}
		type = 2 + (int)((float)i*(float)chbg_rand()/(RAND_MAX +1.0));

		if (cfg.d_effects)
		{
			for(i = 1, j = 0; i < CHBG_EFECTS; i++)
			{
				if (!g_slist_find(cfg.d_effects, (gpointer)i))
				{
					j++;
					if (j == type)
						break;
				}
			}
			type = i;
		}
	}
	return type;
}

static guint chbg_prop_get_shader(prop)
prop_t *prop;
{
	guint type;
	int i,j;

	if (prop->shade == 1)
	{
		GSList *ptr = cfg.d_shaders;
		i = shader_get_cnt();
		while(ptr)
		{
			if (((int)ptr->data) < shader_get_cnt())
				i--;
			ptr = ptr->next;
		}
		type = 2 + (int)((float)(i-2)*(float)chbg_rand()/(RAND_MAX + 1.0));

		if (cfg.d_shaders)
		{
			for(i = 1, j = 0; i < shader_get_cnt(); i++)
			{
				if (!g_slist_find(cfg.d_shaders, (gpointer)i))
				{
					j++;
					if (j == type)
						break;
				}
			}
			type = i;
		}
	}
	else
		type = prop->shade;

	return type;
}

static guint chbg_prop_get_gradient(prop)
prop_t *prop;
{
	guint gr;

	if (prop->use_grad && !prop->gradnr)
	{
		gr = g_slist_length(cfg.grads);
		gr = chbg_rand() % gr;
	}
	else
		gr = prop->gradnr;

	return gr;
}

static char *chbg_prop_get_tile(prop)
prop_t *prop;
{
	char *p = NULL;

	if (prop->tile && prop->use_tiles)
	{
		p = prop->tile;

                if ((!strcmp(p, gettext("Random")) ||
                     !strcasecmp(p, "random")) &&
                    cfg.tiles)
                {
                        int n = g_list_length(cfg.tiles);

                        n = chbg_rand()%n;

                        p = (char *)(g_list_nth(cfg.tiles, n))->data;
                }
	}

	return g_strdup(p);
}

static char *chbg_prop_get_banner(prop)
prop_t *prop;
{
	char *p = NULL;

	if (prop->banner && prop->use_banners)
	{
		p = prop->banner;

                if ((!strcmp(p, gettext("Random")) ||
                     !strcasecmp(p, "random")) &&
                    cfg.banners)
                {
                        int n = g_list_length(cfg.banners);

                        n = chbg_rand()%n;

                        p =  ((banner_t *) (g_list_nth(cfg.banners, n))->data)->name;
                }
	}

	return g_strdup(p);
}

static void chbg_prop_get_bg(prop, clr)
prop_t *prop;
GdkColor *clr;
{
	if (prop->rand_colors)
	{
		clr->red = (int)(65535.0*(float)chbg_rand()/(RAND_MAX + 1.0));
		clr->green = (int)(65535.0*(float)chbg_rand()/(RAND_MAX + 1.0));
		clr->blue = (int)(65535.0*(float)chbg_rand()/(RAND_MAX + 1.0));
	}
	else
	{
		memcpy(clr, &(prop->background), sizeof(GdkColor));
	}
}

static void chbg_prop_get_bg2(prop, clr)
prop_t *prop;
GdkColor *clr;
{
	if (prop->rand_colors)
	{
		clr->red = (int)(65535.0*(float)chbg_rand()/(RAND_MAX + 1.0));
		clr->green = (int)(65535.0*(float)chbg_rand()/(RAND_MAX + 1.0));
		clr->blue = (int)(65535.0*(float)chbg_rand()/(RAND_MAX + 1.0));
	}
	else
	{
		memcpy(clr, &(prop->background2), sizeof(GdkColor));
	}
}

static void chbg_compose_prop(imgname, prop, cprop)
gchar *imgname;
prop_t *prop;
prop_t *cprop;
{
	memset(cprop, '\0', sizeof(prop_t));

	cprop->max_grow = prop->max_grow;
	cprop->interval = prop->interval;
	cprop->interval_end = prop->interval_end;
	cprop->type = prop->type;
	cprop->max_size = prop->max_size;
	cprop->rand_colors = prop->rand_colors;
	cprop->use_grad = prop->use_grad;
	cprop->use_tiles = prop->use_tiles;
	cprop->use_banners = prop->use_banners;
	cprop->xpos = prop->xpos;
	cprop->ypos = prop->ypos;
	

	cprop->efect = chbg_prop_get_effect(prop);
	cprop->shade = chbg_prop_get_shader(prop);
	cprop->gradnr = chbg_prop_get_gradient(prop);
	cprop->tile = chbg_prop_get_tile(prop);
	cprop->banner = chbg_prop_get_banner(prop);
	chbg_prop_get_bg(prop, &cprop->background);
	chbg_prop_get_bg2(prop, &cprop->background2);
	memcpy(&cprop->banner_prop, &prop->banner_prop, sizeof(banner_prop_t));

	chbg_status_set(imgname, cprop);
}

static void chbg_prop_free(prop)
prop_t *prop;
{
	g_free(prop->tile);
	g_free(prop->banner);
}

int set_root_bg(imgname, prop)
gchar *imgname;
prop_t *prop;
{
	GdkWindow *root_window;
	prop_t sprop;
	int rv = 0;

	chbg_compose_prop(imgname, prop, &sprop);

	if (cfg.tofile && cfg.outfile)
	{
		rv = set_root_to_file(imgname, &sprop, cfg.outfile,
				cfg.outfile_width, cfg.outfile_height);
	}
	else if (cfg.use_ebg)
	{
		rv = set_root_ebg(imgname, &sprop);
	}
	else if (!imgname)
	{
		set_blank_screen(&sprop);
	}
	else
	{
		root_window = ((cfg.screensaver || cfg.xscreensaver ||
				cfg.inwindow || cfg.infwindow) &&
			       screensaver_window) ?
				screensaver_window : GDK_ROOT_PARENT();

		rv = set_root_bg_load(root_window, imgname, &sprop);
	}

	chbg_prop_free(&sprop);

	return rv;
}

static guint is_option(str, argc, argv)
gchar *str;
guint argc;
gchar **argv;
{
	guint i;
	for(i = 1; i < argc ; i++)
		if (!strcasecmp(str, argv[i])) return TRUE;

	return FALSE;
}

int cmp_images(picentry_t* Image1, picentry_t* Image2)
{
	return g_strcasecmp(g_basename(Image1->name), g_basename(Image2->name));
}

void load_pictures()
{
	chbg_status_what(gettext("Scanning directory for pictures"), 0);

	recurse_dir(&cfg.pics, &cfg.num_pics, cfg.pattern, cfg.min_size,
		(recurse_getname_func)picentry_get_name,
		(recurse_newentry_func)picentry_clone,
		(recurse_free_func)picentry_free);

	chbg_status_what("", 0);
}

void init_locale_env()
{
	char *lang;
	char *lc_messages;
	char *lc_all;
	char *lc_ctype;
	char *l = NULL;

	lang = g_strdup(getenv("LANG"));
	lc_all = g_strdup(getenv("LC_ALL"));
	lc_messages = g_strdup(getenv("LC_MESSAGES"));
	lc_ctype = g_strdup(getenv("LC_CTYPE"));

	if (lc_all) unsetenv("LC_ALL");
	if (lang) unsetenv("LANG");
	if (lc_messages) unsetenv("LC_MESSAGES");
	unsetenv("LC_TIME");
	unsetenv("LC_NUMERIC");

	if (lc_messages) l = lc_messages;
	else if (lang) l = lang;
	else if (lc_all) l = lc_all;

	if (l) setenv("LC_MESSAGES", l, TRUE);

	if (!lc_ctype)
	{
		if (lc_all) setenv("LC_CTYPE", lc_all, TRUE);
		else if (lang) setenv("LC_CTYPE", lang, TRUE);
	}

	g_free(lang);
	g_free(lc_messages);
	g_free(lc_all);
}

static int pe_find_by_name(pe, name)
picentry_t *pe;
char *name;
{
	return strcmp(pe->name, name);
}


static int get_interval_s(prop)
prop_t *prop;
{
	int rv;

	if (prop->interval_end > prop->interval)
	{
		gfloat f;

		f = prop->interval;
		f += (prop->interval_end - prop->interval) *
			((float)chbg_rand()/(RAND_MAX + 1.0));

		rv = (int) (f * (gfloat)60);
	}
	else
		rv = (int) (prop->interval * (gfloat)60);

	return rv;
}

static void chbg_cycle_blank()
{
	while(!stop_changing)
	{
		chbg_srand(time(NULL));
		set_root_bg(NULL, &cfg.properties);
		if (cfg.once)
			stop_changing = TRUE;
		if (!stop_changing)
		{
			if (cfg.screensaver || cfg.inwindow || have_setup)
			{
				chbg_status_what(gettext("Sleeping"), 0);
				tid = gtk_timeout_add(get_interval_s(&cfg.properties) * 1000 ,
					(GtkFunction) Switch, NULL);
				while (!stop_changing && !change_pic)
					g_main_iteration(TRUE);
				change_pic = FALSE;
			}
			else
				sleep(get_interval_s(&cfg.properties));
		}

	}
}

static GList *chbg_rand_list(list)
GList *list;
{
	GList *rv = NULL,*ptr;

	for (ptr = list; ptr; ptr = ptr->next)
	{
		if (!rv)
			rv = g_list_append(rv, ptr->data);
		else
			rv = g_list_insert(rv, ptr->data, 
				chbg_rand() % g_list_length(rv));
	}

	return rv;
}

static void chbg_cycle_pictures()
{
	picentry_t *pe;
	GdkColor *actc;
	GList *rlist;

	while(!stop_changing && cfg.pics)
	{
		GList *ptr = cfg.pics;

		chbg_srand(time(NULL));
		if (cfg.randomize)
		{
			ptr = rlist = chbg_rand_list(cfg.pics);
		}
		else
		{
			ptr = rlist = g_list_copy(cfg.pics);

			if (cfg.remember_last && cfg.current_name)
			{
				/* Start from the last one */
				ptr = g_list_find_custom(rlist,
					cfg.current_name, pe_find_by_name);
				if (!ptr)
				{
					/* Not found : Start from beginning */
					ptr = rlist;
				}
			}
		}

		restart_loop = FALSE;
		while (!restart_loop && !stop_changing && ptr)
		{
			if (cfg.remember_last && cfg.scenario && !cfg.randomize)
			{
				/* Save the scenario */
				cfg_save_scenario(cfg.scenario);
			}

			pe = picentry_dup((picentry_t *)ptr->data);
			actc = pe->prop ? &pe->prop->background : &cfg.properties.background;
			gdk_color_alloc(gdk_colormap_get_system(), actc);
			
			if (!set_root_bg(pe->name, pe->prop ? pe->prop : &cfg.properties))
			{
                                if (!cfg.randomize && cfg.scenario)
				{
					/* Save the point to start from it at next launch */
					if (cfg.current_name)
						g_free(cfg.current_name);
					cfg.current_name = g_strdup(pe->name);
                                }

				if (cfg.once)
					stop_changing = TRUE;

				if (cfg.num_pics > 1 && !stop_changing)
				{
					if (cfg.screensaver || cfg.inwindow || have_setup)
					{
						chbg_status_what(gettext("Sleeping"), 0);
						tid = gtk_timeout_add(get_interval_s(pe->prop ? pe->prop : &cfg.properties) * 1000,
							(GtkFunction) Switch, NULL);
						while (!stop_changing && !change_pic)
							g_main_iteration(TRUE);
						change_pic = FALSE;
					}
					else
						sleep(get_interval_s(pe->prop ? pe->prop : &cfg.properties));
				}
			}
			else if (cfg.blank && !stop_changing)
			{
				set_root_bg(NULL, pe->prop ? pe->prop : &cfg.properties);
				if (cfg.once)
					stop_changing = TRUE;
				if (!stop_changing)
				{
					if (cfg.screensaver || cfg.inwindow || have_setup)
					{
						chbg_status_what(gettext("Sleeping"), 0);
						tid = gtk_timeout_add(get_interval_s(pe->prop ? pe->prop : &cfg.properties) * 1000,
							(GtkFunction) Switch, NULL);
						while (!stop_changing && !change_pic)
							g_main_iteration(TRUE);
						change_pic = FALSE;
					}
					else
						sleep(get_interval_s(pe->prop ? pe->prop : &cfg.properties));
				}
			}
			else if (!restart_loop && !stop_changing)
			{
				fprintf(stderr, gettext("removing picture \"%s\" from list\n"), ((picentry_t *)ptr->data)->name);

				picentry_free(ptr->data);
				cfg.pics = g_list_remove(cfg.pics, ptr->data);
				cfg.num_pics --;
			}

			if (!restart_loop)
			{
				GList *nx = ptr->next;
				rlist = g_list_remove_link(rlist, ptr);
				ptr = nx;
				if (!ptr)
					ptr = rlist;
			}

			gdk_colormap_free_colors(gdk_colormap_get_system() ,
							actc, 1);

			picentry_free(pe);
		}
		g_list_free(rlist);
		if (cfg.num_pics < 2) break;
	    }

	    if (cfg.once)
		stop_changing = TRUE;
	    if (cfg.num_pics)
	    {
		if (cfg.screensaver && !stop_changing)
		{
			while (!stop_changing && !change_pic)
				g_main_iteration(TRUE);
			change_pic = FALSE;
		}
		else if (!stop_changing)
		{
			if (have_setup)
			{
				chbg_status_what(gettext("only one picture available : changing not required"), 10);
				gdk_beep();
			}
			else
				fprintf(stderr, gettext("only one picture available : changing not required\n"));
		}
	    }
	    else
	    {
		if (cfg.blank)
			set_root_bg(NULL, &cfg.properties);
		if (have_setup)
		{
			chbg_status_what(gettext("unable to find any suitable picture"), 10);
			gdk_beep();
		}
		else
			fprintf(stderr, gettext("unable to find any suitable picture\n"));
	}
}

void run_changing_process()
{

	chbg_status_what(gettext("Initializing"), 0);

	change_pic = FALSE;
	stop_changing = FALSE;

	if (cfg.infwindow)
	{
		cfg.screensaver = FALSE;
		cfg.xscreensaver = FALSE;
		cfg.inwindow = FALSE;
		screensaver_window = gdk_window_foreign_new(cfg.windowid);
		if (!screensaver_window)
		{
			fprintf(stderr, gettext("Unable to find window id - 0x%08lx\n"), cfg.windowid);
			chbg_status_what(gettext("Unable to find foreign window"), 10);
			gdk_beep();
			return;
		}
	}

	if (cfg.inwindow)
	{
		cfg.screensaver = FALSE;
		cfg.xscreensaver = FALSE;
		if (!cfg.windowid)
			init_window();
	}

	if (cfg.screensaver && !cfg.xscreensaver)
	{
		_screensaver_window = screensaver_window = chbg_init_full_win(_screensaver_window, chbg_screensaver_event_func, &screensaver_window);
	}

#ifdef HAVE_XSS_SUPPORT
	if (cfg.xscreensaver)
	{
		screensaver_window = xss_get_window();
		if (!screensaver_window)
		{
			if (have_setup)
			{
				chbg_status_what(gettext("Unable to find xscreensaver window"), 10);
				gdk_beep();
			}
			else
				fprintf(stderr, gettext("Unable to find xscreensaver window\n"));
			return;
		}
	}
#endif

	if (cfg.pics_orig)
	{
		while (cfg.pics_orig)
		{
			picentry_free(cfg.pics_orig->data);
			cfg.pics_orig = g_list_remove_link(cfg.pics_orig, cfg.pics_orig);
		}
	}

	if (cfg.recurse)
	{
		GList *ptr;

		for (ptr = cfg.pics; ptr ; ptr = ptr->next)
		{
			cfg.pics_orig = g_list_append(cfg.pics_orig,
				picentry_dup((picentry_t *)ptr->data));
		}

		load_pictures();
	}

	if (!cfg.randomize && cfg.sort)
	{
		/* Sort images */
		cfg.pics = g_list_sort(cfg.pics, (GCompareFunc) cmp_images);
	}

	if (!cfg.pics && cfg.cycle_blank)
	{
		chbg_cycle_blank();
	}
	else
	{
		chbg_cycle_pictures();
	}

	gdk_event_handler_set((GdkEventFunc)gtk_main_do_event, NULL, NULL);

	if (screensaver_window &&
	    (cfg.screensaver || cfg.inwindow ))
	{
		gdk_window_hide(screensaver_window);
		gdk_window_destroy(screensaver_window);
		_own_window = NULL;
		_screensaver_window = NULL;
		screensaver_window = NULL;
	}

	if (!have_setup && gtk_main_level() > 0) gtk_main_quit();
	stop_changing = FALSE;
	if (tid) gtk_timeout_remove(tid);
	tid = 0;

	chbg_status_what(NULL, 5);

	ServeEvents;
}

void SignalUsr1_Handler(p)
int p;
{
	if (cfg.screensaver || cfg.inwindow || have_setup)
	{
		if (tid) gtk_timeout_remove(tid);
		tid = 0;
	}
	change_pic = TRUE;
}

static char *tile_get_name(name)
char *name;
{
	return name;
}

void load_tiles()
{
	recurse_dir(&cfg.tiles, NULL, NULL, 0,
		(recurse_getname_func) tile_get_name,
		(recurse_newentry_func) tile_get_name,
		(recurse_free_func) g_free);
}

void load_banners()
{
	recurse_dir(&cfg.banners, NULL, NULL, 0,
		(recurse_getname_func) banner_get_name,
		(recurse_newentry_func) banner_clone,
		(recurse_free_func) banner_free);
}

/* remove the pixmap property to avoid X errors in */
/* semitransparent terminals (aterm, eterm)        */
static void chbg_cleanup()
{
#if 0
	GdkAtom prop_root;
	prop_root = gdk_atom_intern("_XROOTPMAP_ID", FALSE);
	if (prop_root != GDK_NONE)
		gdk_property_delete(GDK_ROOT_PARENT(), prop_root);
	prop_root = gdk_atom_intern("ESETROOT_PMAP_ID", FALSE);
	if (prop_root != GDK_NONE)
		gdk_property_delete(GDK_ROOT_PARENT(), prop_root);
#endif
}

gint main(argc, argv)
guint argc;
gchar **argv;
{
	char *p,pom[PATH_MAX];

	stop_changing = FALSE;

	chbg_srand(time(NULL));

	init_locale_env();
	INIT_LOCALE

	gdk_init(&argc, &argv);
	gdk_rgb_init();

	cfg_default();
	cfg.grad_dir = NULL;
	cfg.grads = NULL;
	cfg.tiles = NULL;

	if (!is_option("-scenario", argc, argv))
	{
		p = g_get_home_dir();
		if (!p) p = "";
		sprintf(pom, "%s/.chbgrc", p);
		if (!access(pom, R_OK))
			cfg_scenario(pom);
#ifdef DEFAULT_SYS_CHBG_RC
		else if (!access(DEFAULT_SYS_CHBG_RC, R_OK))
			cfg_scenario(DEFAULT_SYS_CHBG_RC);
#endif
	}

	if (cfg_cmdln(argc, argv))
		cfg_usage(argv[0]);

	if (cfg.force_xscreensaver)
		cfg.xscreensaver = TRUE;

	if (cfg.grad_dir)
	{
		cfg.grads = grad_load_gradients(cfg.grad_dir);
	}
	else
	{
		int i;
		char *graddirs[] = {
			"/usr/share/gimp/gradients" ,
			"/usr/share/gimp/1.1/gradients" ,
			"/usr/share/gimp/1.2/gradients" ,
			"/usr/local/share/gimp/gradients" ,
			"/usr/local/share/gimp/1.1/gradients" ,
			"/usr/local/share/gimp/1.2/gradients" ,
			"/opt/share/gimp/gradients" ,
			"/opt/share/gimp/1.1/gradients" ,
			"/opt/share/gimp/1.2/gradients" ,
			NULL,
		};

		for (i = 0 ; graddirs[i] ; i++)
		{
			if (!access(graddirs[i], R_OK))
			{
				cfg.grads = grad_load_gradients(graddirs[i]);
				break;
			}
		}
	}

	if (cfg.tiles)
		load_tiles();

	if (cfg.banners)
		load_banners();

	/* Initialize the signal handler to change the image */
	signal(SIGUSR1, SignalUsr1_Handler);

	g_atexit(chbg_cleanup);

	if (cfg.use_ebg && !check_for_enlightenment())
	{
		fprintf(stderr, gettext("Requested to use Enlightenment, but Enlightenment not found!\n"));
		cfg.use_ebg = FALSE;
	}

	else if (!cfg.force_xscreensaver &&
		 ((!cfg.pics && !cfg.blank) || cfg.setup || cfg.thumb))
	{
		absimg_init();
		have_setup = TRUE;
		run_setup(&argc, &argv);
	}
	else
	{
		if (cfg.infwindow)
		{
			cfg.screensaver = FALSE;
			cfg.xscreensaver = FALSE;
			if (cfg.windowid)
			{
				screensaver_window = gdk_window_foreign_new(cfg.windowid);
				if (!screensaver_window)
				{
					fprintf(stderr, gettext("Unable to find window id - 0x%08lx\n"), cfg.windowid);
				}
			}
		}

		if (cfg.screensaver || cfg.xscreensaver)
		{
			gtk_init(&argc, &argv);
		}


		absimg_init();

		run_changing_process();
	}

	return 0;
}

