*
* $Id: frearg.F,v 1.1.1.1 1996/04/01 15:02:50 mclareni Exp $
*
* $Log: frearg.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:50  mclareni
* Mathlib gen
*
*
#include "gen/pilot.h"
      FUNCTION FREARG(X,Y)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   PURPOSE                                                            C
C     TO PERFORM A LINEAR INTERPOLATION ON A REAL FUNCTION OF TWO      C
C     INTEGER ARGUMENTS. THIS FUNCTION MUST HAVE THE NAME FINARG.      C
C     FREARG IS PLANNED FOR USE WITH THE CONTOUR PROGRAM CONT.         C
C     LET US DENOTE THE ARGUMENTS OF FINARG BY I AND J.                C
C     X AND I SHALL BE LINEARLY RELATED TO EACH OTHER.                 C
C     Y AND J SHALL BE LINEARLY RELATED TO EACH OTHER.                 C
C     THESE RELATIONSHIPS ARE COMPLETELY DEFINED BY REQUIRING THAT     C
C         X=X1  CORRESPONDS TO  I=I1,                                  C
C         X=X2  CORRESPONDS TO  I=I2,                                  C
C         Y=Y1  CORRESPONDS TO  J=J1,                                  C
C         Y=Y2  CORRESPONDS TO  J=J2.                                  C
C   USAGE                                                              C
C     AFTER THE STATEMENT                                              C
C     CALL SETUP(X1,I1,X2,I2,Y1,J1,Y2,J2)                              C
C     HAS BEEN EXECUTED, THE EXPRESSION                                C
C                  FREARG(X,Y)                                         C
C     WILL HAVE THE VALUE FOUND BY LINEAR INTERPOLATION FROM THE FOUR  C
C     NEAREST VALUES OF THE CORRESPONDING FUNCTION FINARG(I,J).        C
C   PARAMETERS                                                         C
C     X  -LINEARLY RELATED TO I,                                       C
C     Y  -LINEARLY RELATED TO J.                                       C
C   EXTERNAL SUBPROGRAMS USED                                          C
C     FINARG                                                           C
C     INTER                                                            C
C   REMARKS                                                            C
C     FINARG  IS TO BE WRITTEN BY THE USER.                            C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      COMMON /J509C2/CX1,CI1,CX2,CI2,CY1,CJ1,CY2,CJ2
C=======================================================================
C         STATEMENT FUNCTION YINTER DOES A LINEAR INTERPOLATION
      YINTER(X1,Y1,X2,Y2,XIN)=((X2-XIN)*Y1+(XIN-X1)*Y2)/(X2-X1)
C
      REALI = YINTER(CX1,CI1,CX2,CI2,X)
      REALJ = YINTER(CY1,CJ1,CY2,CJ2,Y)
#if !defined(CERNLIB_HPUX)
C*IA  X1,Y1,X2,Y2,XIN
      DATA X1,Y1,X2,Y2,XIN/5*0/
#endif
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   FIND NEAREST INTEGER LEFT -HAND NEIGHBOUR OF REALI, CALL IT IL,    C
C   FIND NEAREST INTEGER RIGHT-HAND NEIGHBOUR OF REALI, CALL IT IR,    C
C   FIND NEAREST INTEGER LEFT -HAND NEIGHBOUR OF REALJ, CALL IT JL,    C
C   FIND NEAREST INTEGER RIGHT-HAND NEIGHBOUR OF REALJ, CALL IT JR.    C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IL=REALI
      JL=REALJ
C         MAKE SURE THE TABLE VALUES EXIST
      IF (REALI .LT. 1.0)  IL=1
      IF (REALJ .LT. 1.0)  JL=1
      IF (REALI .GE. CI2)  IL= CI2-1.0
      IF (REALJ .GE. CJ2)  JL= CJ2-1.0
      IR=IL+1
      JR=JL+1
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     CONVERT THEM ALL TO REAL NUMBERS,AS ITER WANTS REAL ARGUMENTS.   C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      REALIL=IL
      REALIR=IR
      REALJL=JL
      REALJR=JR
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   FIND THE FOUR NEAREST FUNCTION VALUES OF FINARG AROUND             C
C     FINARG(REALI,RELAJ), WHICH IS NOT DEFINED.                       C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      FLL=FINARG(IL,JL)
      FLR=FINARG(IL,JR)
      FRL=FINARG(IR,JL)
      FRR=FINARG(IR,JR)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   INTERPOLATED BETWEEN IL AND IR, WITH J=JL.                         C
      F0L = YINTER(REALIL,FLL,REALIR,FRL,REALI)
C
C   INTERPOLATE BETWEEN IL AND IR, WITH J=JR.                          C
      F0R = YINTER(REALIL,FLR,REALIR,FRR,REALI)
C
C   FINALLY, INTERPOLATE BETWEEN JL AND JR, WITH I=REALI               C
      F00 = YINTER(REALJL,F0L,REALJR,F0R,REALJ)
C
      FREARG=F00
      RETURN
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   IT IS LEFT AS AN EXERCISE TO THE READER TO PROVE THAT TWO INTER-   C
C   POLATIONS IN THE J-DIRECTION AND FINALLY ONE IN THE I-DIRECTION    C
C   WOULD GIVE THE SAME RESULT.                                        C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
       END
