*
* $Id: zecfor.F,v 1.1.1.1 1996/03/08 12:01:12 mclareni Exp $
*
* $Log: zecfor.F,v $
* Revision 1.1.1.1  1996/03/08 12:01:12  mclareni
* Zbook
*
*
#include "zbook/pilot.h"
      SUBROUTINE ZECFOR(FORM,NWMAX,NW,IW,LOUT)
*
*--- DECODES A FORMAT DESCRIPTION FOR BANKS
*
* author HG       7/4/84
*
*--- INPUT
*    FORM        (TYPE CHARACTER)  FORMAT
*    NWMAX       SPACE AVAILABLE IN IW
*--- OUTPUT
*    NW       NO. OF WORDS IN IW
*    IW       (ARRAY) CONVERTED FORMAT
*    LOUT     PRINT OUTPUT UNIT
*
* THERE ARE FOUR TYPES OF CONVERSION POSSIBLE, 'A' FOR HOLLERITH,
* 'F' FOR SINGLE PRECISION FLOATING, 'I' FOR INTEGER,
* 'X' FOR NO CONVERSION.
*
* BLANKS ARE NOT SIGNIFICANT.
*
* FORMATS MAY CONSIST OF A HEADER PART, OR A PART WHICH IS
* REPEATED, OR BOTH.
*
* THE HEADER PART IS EXECUTED ONCE, THE REST IS LEFT UNTOUCHED.
* THE REPEAT OPTION ALLOWS TO EXECUTE A FORMAT UNTIL THE END OF
* THE ARRAY TO CONVERT.
*
* A BRACKET WITHOUT REPETITION FACTOR IN FRONT INDICATES THE START OF
* THE PART TO BE REPEATED.
*
* REPETITION FACTORS MUST NOT BE GREATER THAN 1000.
*
* MULTIPLE BRACKETS ARE NOT PERMITTED.
*
* EXAMPLE:  3I,F,1X,2A,4I,4(3F,3I),(I,2F)
* MEANS
* CONVERT FIRST THREE WORDS AS INTEGER,ONE WORD AS F, SKIP ONE WORD,
* TWO WORDS AS HOLLERITH, FOUR INTEGERS, THEN FOUR TIMES
* THREE FLOATING AND THREE INTEGERS, THE REST AS ONE INTEGER AND TWO
* FLOATING ALTERNATING.
*
* SECOND EXAMPLE: (I) MEANS CONVERT THE WHOLE ARRAY AS INTEGER.
*
* THE OUTPUT IN IW CONSISTS OF THE COUNT FOR EACH TYPE, PLUS
* 10000 FOR 'X', 20000 FOR 'I', 30000 FOR 'F', 40000 FOR 'A'.
* ACTUALLY, ANY CHARACTER OTHER THAN A,F, OR I IS TREATED LIKE X.
*
* REPETITION FACTORS ARE PUT IN FRONT OF THE BRACKET, A WORD '50000'
* INDICATES THE END.
*
* A WORD CONTAINING 0 INDICATES THE START OF THE PART TO BE REPEATED.
*
* EXAMPLE: THE FIRST FORMAT ABOVE WOULD RESULT IN:
* NW =  13
* IW =  20003 30001 10001 40002 20004 4 30003 20003 50000
*        0 20001 30002 50000
*
* IF THE FORMAT GIVEN IS ENTIRELY BLANK, NW IS RETURNED AS ZERO.
*
      DIMENSION IW(*)
      CHARACTER *(*) FORM,STEMP*1
      NW=0
      K=0
      IL=0
      DO 10 I=1,LEN(FORM)
         STEMP=FORM(I:I)
         ICH=ICHAR(STEMP)
         IF (STEMP.EQ.'(')  THEN
            IF (NW.EQ.NWMAX) GOTO 20
            NW=NW+1
            IW(NW)=K
            K=0
            IL=I
         ELSEIF (STEMP.EQ.')')  THEN
            IF (NW.EQ.NWMAX) GOTO 20
            NW=NW+1
            IW(NW)=50000
            IL=I
         ELSEIF (ICH.GE.ICHAR('A').AND.ICH.LE.ICHAR('Z'))  THEN
            IF (STEMP.EQ.'A')  THEN
               KADD=40000
            ELSEIF (STEMP.EQ.'I')  THEN
               KADD=20000
            ELSEIF (STEMP.EQ.'F')  THEN
               KADD=30000
            ELSE
               KADD=10000
            ENDIF
            IF (NW.EQ.NWMAX) GOTO 20
            NW=NW+1
            IW(NW)=KADD+MAX(K,1)
            K=0
            IL=I
         ELSEIF (ICH.GE.ICHAR('0').AND.ICH.LE.ICHAR('9'))  THEN
            K=MIN(1000,10*K+ICH-ICHAR('0'))
         ENDIF
   10 CONTINUE
      GOTO 999
   20 CONTINUE
      WRITE (LOUT,10000) FORM(:IL)
10000 FORMAT(/' ++++++++ZBFORM - USER BANK FORMAT TOO LONG, CUT TO',
     +        '  ''',A,''''/)
  999 END
