*
* $Id: gbrsge.F,v 1.2 1996/09/30 13:30:10 ravndal Exp $
*
* $Log: gbrsge.F,v $
* Revision 1.2  1996/09/30 13:30:10  ravndal
* Bremsstrahlung extension for higher energies
*
* Revision 1.1.1.1  1995/10/24 10:21:22  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/04 24/02/95  14.50.31  by  S.Giani
*-- Author :
      FUNCTION GBRSGE(ZZ,T,BCUT)
C.
C.    ******************************************************************
C.    *                                                                *
C.    *  Calculates cross-section in current material                  *
C.    *  for discrete(hard) electron BREMSSTRAHLUNG.                   *
C.    *         (SIG in barn/atom)                                     *
C.    *                                                                *
C.    *    ==>Called by : GBRSGA                                       *
C.    *       Author  L.Urban  *********                               *
C.    *                                                                *
C.    *  correction for T> 100 GeV !  (by L.Urban on 23/09/96)         *
C.    ******************************************************************
C.
#include "geant321/gconsp.inc"
#include "geant321/gcmate.inc"
      DIMENSION C(100),C1(60),C2(40)
      EQUIVALENCE (C(1),C1(1)),(C(61),C2(1))
      SAVE C
#if !defined(CERNLIB_BETHE)
      PARAMETER (AKSI=1.80,ALFA=0.98,VS=0.0001)
      DATA C1/ 0.430748E-02, 0.576058E-02,-0.122564E-02, 0.114843E-03
     +      ,-0.489452E-05, 0.795991E-07, 0.326746E-02,-0.132872E-02
     +      , 0.217197E-03,-0.179769E-04, 0.766114E-06,-0.125603E-07
     +      , 0.326452E-02,-0.175331E-02, 0.415488E-03,-0.507652E-04
     +      , 0.297569E-05,-0.651741E-07, 0.847189E-03,-0.433923E-03
     +      , 0.116672E-03,-0.166799E-04, 0.110237E-05,-0.263383E-07
     +      , 0.846052E-04,-0.415764E-04, 0.129610E-04,-0.212844E-05
     +      , 0.152871E-06,-0.384393E-08, 0.300838E-05,-0.136833E-05
     +      , 0.507296E-06,-0.943623E-07, 0.720305E-08,-0.187210E-09
     +      , 0.448230E-01,-0.210048E-01, 0.379434E-02,-0.328431E-03
     +      , 0.136710E-04,-0.220593E-06,-0.539248E-02, 0.330244E-02
     +      ,-0.733726E-03, 0.732312E-04,-0.336810E-05, 0.583913E-07
     +      ,-0.106983E-02, 0.378021E-03,-0.384854E-04, 0.978156E-06
     +      , 0.410622E-07,-0.174250E-08,-0.117501E-04,-0.983887E-05
     +      , 0.239644E-05,-0.190104E-06, 0.619226E-08,-0.680932E-10/
      DATA C2/ 0.168074E-03,-0.934609E-04, 0.141293E-04,-0.854216E-06
     +      , 0.183287E-07, 0.932144E-04,-0.234926E-04, 0.136656E-05
     +      , 0.351109E-07,-0.330189E-08, 0.174523E-04, 0.253854E-05
     +      ,-0.171643E-05, 0.183074E-06,-0.566331E-08, 0.111970E-05
     +      , 0.112776E-05,-0.386924E-06, 0.367597E-07,-0.108504E-08
     +      , 0.171604E-07, 0.738801E-07,-0.218761E-07, 0.199032E-08
     +      ,-0.576173E-10,-0.105531E-03, 0.362995E-04,-0.433334E-05
     +      , 0.207664E-06,-0.330250E-08,-0.168293E-05,-0.773204E-06
     +      , 0.227974E-06,-0.159385E-07, 0.321958E-09, 0.167046E-05
     +      ,-0.440761E-06, 0.396377E-07,-0.151053E-08, 0.215624E-10/
#endif
#if defined(CERNLIB_BETHE)
      PARAMETER (AKSI=1.80,ALFA=1.00,VS=0.0001)
      DATA C1/ 0.111394E-01, 0.138592E-02,-0.274910E-03, 0.198389E-04
     +      ,-0.472291E-06,-0.668760E-09, 0.839876E-02,-0.449619E-02
     +      , 0.917722E-03,-0.874992E-04, 0.390015E-05,-0.653499E-07
     +      , 0.464718E-02,-0.260321E-02, 0.582582E-03,-0.631769E-04
     +      , 0.325801E-05,-0.638109E-07, 0.101243E-02,-0.532089E-03
     +      , 0.129100E-03,-0.161260E-04, 0.958116E-06,-0.212606E-07
     +      , 0.926006E-04,-0.455288E-04, 0.124755E-04,-0.182510E-05
     +      , 0.122078E-06,-0.294182E-08, 0.308111E-05,-0.134712E-05
     +      , 0.436230E-06,-0.751770E-07, 0.552327E-08,-0.140541E-09
     +      , 0.292552E-02,-0.830719E-03, 0.210705E-04, 0.103750E-04
     +      ,-0.953318E-06, 0.236453E-07, 0.110907E-02,-0.219463E-03
     +      , 0.128517E-04,-0.554575E-06, 0.507378E-07,-0.182214E-08
     +      ,-0.639866E-03, 0.209918E-03,-0.250183E-04, 0.138030E-05
     +      ,-0.358845E-07, 0.366305E-09, 0.300095E-04,-0.133668E-04
     +      , 0.198606E-05,-0.133100E-06, 0.414062E-08,-0.485929E-10/
      DATA C2/ 0.938677E-04,-0.613470E-04, 0.981984E-05,-0.646289E-06
     +      , 0.150731E-07, 0.331764E-04, 0.447248E-05,-0.313021E-05
     +      , 0.329777E-06,-0.997210E-08, 0.876484E-08, 0.110042E-04
     +      ,-0.313406E-05, 0.280040E-06,-0.794116E-08,-0.103097E-05
     +      , 0.220550E-05,-0.569158E-06, 0.491359E-07,-0.136987E-08
     +      ,-0.781963E-07, 0.123162E-06,-0.302825E-07, 0.255485E-08
     +      ,-0.702300E-10,-0.193213E-03, 0.640349E-04,-0.720586E-05
     +      , 0.329673E-06,-0.514682E-08, 0.362138E-04,-0.142783E-04
     +      , 0.184063E-05,-0.967983E-07, 0.179386E-08, 0.496130E-06
     +      , 0.210105E-06,-0.538512E-07, 0.372388E-08,-0.812734E-10/
#endif
C.
      DATA THIGH,CHIGH/100.,50./
C.    ------------------------------------------------------------------
C.
      GBRSGE=0.
*
      IF(BCUT.LE.0.) GOTO 99
      IF(BCUT.GE.T) GOTO 99
*
      IF(T.GT.THIGH) THEN
          TT=THIGH
        IF(BCUT.GE.THIGH) THEN
            EC=CHIGH
        ELSE
            EC=BCUT
        ENDIF
      ELSE
          TT=T
          EC=BCUT
      ENDIF
*
      E=TT+EMASS
*
C
      X=LOG(E/EMASS)
      Y=LOG(E*VS/EC)
C
      S=0.
      YY=1.
      DO 30 I=1,2
         XX=1.
         DO 20 J=1,6
            K=6*I+J-6
            S=S+C(K)*XX*YY
            XX=XX*X
  20     CONTINUE
         YY=YY*Y
  30  CONTINUE
      DO 50 I=3,6
         XX=1.
         DO 40 J=1,6
            K=6*I+J-6
            IF(Y.LE.0.) THEN
               S=S+C(K)*XX*YY
            ELSE
               S=S+C(K+24)*XX*YY
            ENDIF
            XX=XX*X
  40     CONTINUE
         YY=YY*Y
  50  CONTINUE
      SS=0.
      YY=1.
      DO 70 I=1,2
         XX=1.
         DO 60 J=1,5
            K=5*I+J+55
            SS=SS+C(K)*XX*YY
            XX=XX*X
  60     CONTINUE
         YY=YY*Y
  70  CONTINUE
      DO 90 I=3,5
         XX=1.
         DO 80 J=1,5
            K=5*I+J+55
            IF(Y.LE.0.) THEN
               SS=SS+C(K)*XX*YY
            ELSE
               SS=SS+C(K+15)*XX*YY
            ENDIF
            XX=XX*X
  80     CONTINUE
         YY=YY*Y
  90  CONTINUE
C
      S=S+Z*SS
      IF(S.LE.0.) GOTO 99
C
      FAC=ZZ*(ZZ+AKSI)*E*E*(LOG(TT/EC))**ALFA/(TT*(E+EMASS))
      IF(FAC.LE.0.) GOTO 99
C
      GBRSGE=FAC*S
*
      IF(T.GT.THIGH) THEN

       IF(BCUT.LT.THIGH) THEN
        RAT=BCUT/T
        S=(-LOG(RAT)-2./3.+RAT-RAT*RAT/3.)
        RAT=BCUT/TT
        S=S/(-LOG(RAT)-2./3.+RAT-RAT*RAT/3.)
       ELSE
        RAT=BCUT/T
        S=(-LOG(RAT)-2./3.+RAT-RAT*RAT/3.)
        RAT=EC/TT
        S=S/(-LOG(RAT)-2./3.+RAT-RAT*RAT/3.)
       ENDIF

        GBRSGE=GBRSGE*S
      ENDIF
*
99    RETURN
*
      END
