/* JoinGraphicsChange.m
 *
 * Copyright (C) 1993-2002 by vhf interservice GmbH
 * Authors:  Georg Fleischmann
 *
 * created:  1993
 * modified: 2002-07-15
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include "undo.h"

@interface JoinGraphicsChange(PrivateMethods)

- (void)undoDetails;
- (void)redoDetails;

@end

@implementation JoinGraphicsChange


- (void)dealloc
{
    [pathBefore release];
    [path release];
    [super dealloc];
}

- (NSString *)changeName
{
    return JOIN_OP;
}

- (void)saveBeforeChange
{
    [super saveBeforeChange];
    [changeDetails makeObjectsPerformSelector:@selector(recordGraphicPositionIn:) withObject:[graphicView layerList]]; 
}

- (Class)changeDetailClass
{
    return [OrderChangeDetail class];
}

/* FIXME: we should note the layer too (see group),
 * since someone may want to joing graphics on several layers !!!
 */
- (void)notePathBefore:aPath
{
    pathBefore = [aPath copy];
}

- (void)notePath:aPath
{
    path = aPath;
    [path retain];
}

/* remove path build during punch operation (path)
 * add objects (and path before manipulation) involved in punch operation
 * FIXME: undo of join with more than one layer doesn't work correctly
 */
- (void)undoDetails
{   int		count, i;
    id		detail, graphic;
    NSArray	*layerList = [graphicView layerList];

    [graphicView removeGraphic:path];
    count = [changeDetails count];
    for ( i = 0; i < count; i++ )
    {   LayerObject	*layer;

	detail = [changeDetails objectAtIndex:i];
	graphic = [detail graphic];
        if ( pathBefore && graphic == path )
            graphic = pathBefore;
        layer = [layerList objectAtIndex:[detail layer]];
        [layer insertObject:graphic atIndex:Min([detail graphicPosition], [[layer list] count])];
    }
    [graphicView getSelection];
}

/* remove graphics involved in punch operation
 * add path build during punch operation
 */
- (void)redoDetails
{   int		count, i;
    id		detail = nil, graphic = nil;
    NSArray	*layerList = [graphicView layerList];
    LayerObject	*layer;

    count = [changeDetails count];
    for (i = 0; i < count; i++)
    {
	detail = [changeDetails objectAtIndex:i];
	graphic = [detail graphic];
        if ( pathBefore && graphic == path )
            graphic = pathBefore;
        [graphicView removeGraphic:graphic];
    }
    layer = [layerList objectAtIndex:[detail layer]];
    [layer insertObject:path atIndex:0];
    [graphicView getSelection]; 
}

@end
