#ifndef __EXPORTCDCATDB_H__
#define __EXPORTCDCATDB_H__
/****************************************************************************
                             Hyper's CD Catalog
		A multiplatform qt and xml based catalog program
 
 Author    : Christoph Thielecke (crissi99@gmx.de)
 License   : GPL
 Copyright : (C) 2003 Christoph Thielecke
****************************************************************************/

#include <qvariant.h>
#include <qpixmap.h>
#include <qdialog.h>
#include <qdatetime.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qobject.h>
#include <qlistview.h>
#include <qfiledialog.h>
#include <qwidget.h>
#include <qdatetime.h>
#include <qdialog.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <qvariant.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qdialog.h>
#include <qlabel.h>
#include <stdio.h>
#include <ctype.h>
#include <qfile.h>
#include <qabstractlayout.h>

#include <expat.h>
#include "recode.h"

#include "guibase.h"
#include "dbase.h"
#include "wdbfile.h"

class QLabel;
class QLineEdit;
class QPushButton;
class PWw;
class QApplication;

class exportCdcatDB : public QDialog {
	Q_OBJECT

public:
	exportCdcatDB(QApplication *appp,DataBase *db,QWidget* parent=0, const char* name=0, bool modal=true, WFlags fl=0 );
	~exportCdcatDB();


	void fillMedia();
	QLabel* textLabel2;
	QListBox* listAllMedia;
	QPushButton* buttonRemove;
	QPushButton* buttonAdd;
	QLabel* textLabel2_2;
	QListBox* listSelectedMedia;
	QCheckBox* checkAllMedia;
	QCheckBox* checkOnlyMediaName;
	QCheckBox* checkExportMediaName;
	QCheckBox* checkExportPath;
	QCheckBox* checkExportFile;
	QCheckBox* checkExportSize;
	QCheckBox* checkExportDate;
	QCheckBox* checkExportComment;
	QCheckBox* checkExportMp3Tag;
	QCheckBox* checkExportTitle;
	QCheckBox* checkExportTableHeader;
	QButtonGroup* buttonGroup1;
	QButtonGroup* buttonGroupFields;
	QRadioButton* radioHtml;
	QRadioButton* radioCsv;
	QLabel* seperatorLabel;
	QLabel* textLabel3;
	QLabel* spinColsLabel;
	QLineEdit* separatorInput;
	QLineEdit* fileName;
	QPushButton* buttonFile;
	QPushButton* buttonOk;
	QPushButton* buttonCancel;
	QSpinBox*	spinCols;
	int OK;


protected:
        PWw *pww;
        QApplication *app;
	QGridLayout* exportCdcatDBLayout;
	QVBoxLayout* layout32;
	QHBoxLayout* layout21;
	QVBoxLayout* layout10_2;
	QVBoxLayout* layout19;
	QHBoxLayout* layout10;
	QVBoxLayout* layout10_2_2;
	QVBoxLayout* buttonGroup1Layout;
	QHBoxLayout* layout26;
	QHBoxLayout* layout25;
	QHBoxLayout* layout29;
	QHBoxLayout* layout4;
	QHBoxLayout* layout27;
	QVBoxLayout* typeLayout;
	QVBoxLayout* fieldsLayout;

	DataBase *p;
	QString separator;
	QFile f;
	int writeDown(Node *source);
	int  writeCatalog  (Node *source);
	int  writeMedia    (Node *source);
	int  writeDirectory(Node *source);
	int  writeFile     (Node *source);
	int  writeMp3Tag   (Node *source);
	int  writeCatLnk   (Node *source);
	QString getFilePath(Node *current);

protected slots:
	virtual void languageChange();
	bool doHtmlExport();
	bool doCsvExport();
	void checkExportToggled();
	void removeMedia();
	void listAllMediaToggled();
	void exportTypeToggled();
	void checkOnlyMediaNameToggled();
	void browseFile();
	void addMedia();
public slots:
	void ok();
	void cancel();
private:
	QString outstring;
	QString medianame;
	QString currentpath;
	QString lastMedianame;

	char *out1;
	char *out2;
	char *out3;
	char *out4;
	char *out5;
};

#endif
