(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the standalone tool. *)

let _ = Zog_args.parse ()

let _ = match !Zog_args.file with
  None ->
    prerr_endline Zog_messages.usage ;
    exit 1
| Some file ->
    (
     ignore (GMain.Main.init ()) ;
     let data = new Zog_data.data file in
     let gui = new Zog_gui.gui data in
     let window = GWindow.window 
	 ~title: (Zog_messages.software^" : "^data#file)
	 ~width: 150 ~height: 250
	 () 
     in
     ignore (window#add gui#box#coerce) ;
     ignore (gui#box#connect#destroy window#destroy) ;
     ignore (window#connect#destroy GMain.Main.quit) ;
     ignore (gui#init_window window) ;
     ignore (window#show ()) ;
     GMain.Main.main ()
    )
