(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

module O = Options

type v_name = string
type v_type = T_List | T_String
type v_value = V_List of (string * bool) list | V_String of string * bool
type v_action = string (* v_value -> string *)

type variable = v_name * v_value * v_action

let name_of_variable (name, _, _) = name

let value_of_variable (_, value, _) = value

let action_of_variable (_, _, action) = action

let type_of_variable (_, value, _) =
  match value with
    | V_List _ -> T_List
    | V_String _ -> T_String

let type_of_variable var =
  match value_of_variable var with
    | V_List _ -> T_List
    | V_String _ -> T_String
	
let string_of_type = function
  | T_List -> "list"
  | T_String -> "string" 

exception Not_a_type of string

let type_of_string = function
  | "list" -> T_List
  | "string" -> T_String
  | s -> raise (Not_a_type s)

let new_empty_variable name typ =
  let value = match typ with
    | T_String ->
	V_String ("", false)
    | T_List ->
	V_List [] in
    (* TODO remove "" *)
    (name, value, "")

let new_variable name value action = (name, value, action)
