(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

open Options

module O = Options
module V = Omom_variables

let name_option = string_option


let file_option = string_option


let value_to_type v =
  V.type_of_string (value_to_string v)

let type_to_value t =
  string_to_value (V.string_of_type t)

let type_option =
  define_option_class "Type" value_to_type type_to_value

  
let value_option =
  list_option (tuple2_option
		 (string_option, bool_option))


let value_to_typed_value v = 
  match v with
    | O.List [v1; v2]
    | O.SmallList [v1; v2] ->
	(match (O.from_value type_option v1, O.from_value value_option v2) with
	  | (V.T_String, []) -> 
	      V.V_String ("", false)
	      (* TODO warn ? *)
	  | (V.T_String, h :: t) ->
	      V.V_String (fst h, snd h)
	  | (V.T_List, l) ->
	      V.V_List l)
    | _ -> failwith "Options: not a typed value option"

let typed_value_to_value v =
  match v with
    | V.V_String (string, bool) ->
	SmallList [to_value type_option V.T_String;
		   to_value value_option [(string, bool)]]
    | V.V_List l ->
	SmallList [to_value type_option V.T_List;
		   to_value value_option l]

let typed_value_option =
  define_option_class "Typed_value"
    value_to_typed_value typed_value_to_value
 
let action_option = string_option


let variable_option =
  tuple3_option (name_option, typed_value_option, action_option) 


let template_option =
  tuple3_option (name_option, file_option, list_option variable_option)

let default_ocaml =
  [("OCAMLBIN", V.V_String ("@OCAMLBIN@", true), "");
   ("OCAMLC", V.V_String ("@OCAMLC@", true), "");
   ("OCAMLOPT", V.V_String ("@OCAMLOPT@", true), "");
   ("OCAMLDEP", V.V_String ("@OCAMLDEP@", true), "");
   ("OCAMLLEX", V.V_String ("@OCAMLLEX@", true), "");
   ("OCAMLYACC", V.V_String ("@OCAMLYACC@", true), "");
   ("OCAMLLIB", V.V_String ("@OCAMLLIB@", true), "");
   ("OCAMLDOCDIR", V.V_String ("$(OCAMLLIB)/ocamldoc", true), "");
   ("OCAMLBEST", V.V_String ("@OCAMLBEST@", true), "");
   ("OCAMLVERSION", V.V_String ("@OCAMLVERSION@", true), "");
   ("EXTRACT_CRC", V.V_String ("@OCAML", true), "");
   ("OCAMLDOC", V.V_String ("$(OCAMLLIB)/extract_crc", true), "")] 

let default_common = 
  [("INCLUDES", V.V_List [], "includes");
   ("PPFLAGS", V.V_String ("", false), "");
   ("COMPFLAGS", V.V_String ("", false), "");
   ("LINKFLAGS", V.V_String ("", false), "")]


  
