(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

module O = Options
module G = Omom_gen
module R = Omom_rc
module D = Omom_data


let usage () =
  prerr_endline "usage: omom <omom_file> <template>";
  exit 2

let _ =
  if Array.length Sys.argv <> 3 then
    usage ()
  else
    try
      let data = new D.data Sys.argv.(1) in
      let template = Sys.argv.(2) in
	data#load;
	data#generate template
    with
      |	Sys_error s ->
	  prerr_endline s
      | exn ->
	  prerr_endline (Printexc.to_string exn)

