(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

module B = Base
module F = B.Foo

let d = B.connect "guesdon" "posttest"

let _ = 
  try F.create d
  with Failure s -> prerr_endline s

let _ = F.delete d ()

let cpt = ref 0
let _ = 
  while (!cpt <= 1000) do
    (
     if !cpt mod 2 = 0 then
       F.insert d ~id: !cpt  ~n: None ()
     else
       F.insert d ~id: !cpt ~n: (Some !cpt) ~text: (Some (string_of_int !cpt)) ();
     incr cpt
    )
  done

let l = F.select d ()
let _ = List.iter (fun t -> 
  print_int t.F.id;
  print_string "=";
  (match t.F.n with
    None -> print_string "NULL"
  | Some n -> print_int n);
  print_string "=";
  (match t.F.text with
    None -> print_string "NULL"
  | Some text -> print_string text);
  print_newline ()) l


(*
let _ = F.drop d
*)
