(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Messages and string constants. *)

let _ = ignore (GMain.Main.init())


let software = Cam_installation.software
let software_version = Cam_installation.software_version
let software_author = "Maxence Guesdon"
let software_author_mail = "Maxence.Guesdon@inria.fr"
let software_copyright = 
  "Copyright 2002 Institut National de Recherche en \n"^
  "Informatique et en Automatique. All rights reserved.\n"^
  "This software is distributed under the terms of the\n"^
  "GNU General Public License version2.\n"^
  "(see file LICENSE in the distribution)"
let software_about = 
  software^" version "^software_version^"\n\n"^
  software_author^"\n"^
  software_author_mail^"\n\n"^
  software_copyright

let software_top = "Topcameleon"
let software_top_about = 
  software_top^" version "^software_version^"\n\n"^
  software_author^"\n"^
  software_author_mail^"\n\n"^
  software_copyright

let home = 
  try Sys.getenv "HOME"
  with Not_found -> ""

let rc_dir = 
  let d = Filename.concat home ".cameleon" in
  let _ = 
    try (* A VOIR avec le CDK Unix2.safe_mkdir *) Unix.mkdir d 0o700  
    with _ -> ()
  in
  d

let plugins_dir = 
  let d = Filename.concat rc_dir "plugins" in
  let _ = 
    try (* A VOIR avec le CDK Unix2.safe_mkdir *) Unix.mkdir d 0o700  
    with _ -> ()
  in
  d

(** Create the given empty file. *)
let create_file f =
  try let oc = open_out f in close_out oc
  with Sys_error s -> prerr_endline s

let rc_file_types = 
  let f = Filename.concat rc_dir "filetypes" in
  (
   try ignore (Unix.stat f)
   with Unix.Unix_error _ -> create_file f
  );
  f

let rc_tools = 
  let f = Filename.concat rc_dir "toolbar" in
  (
   try ignore (Unix.stat f)
   with Unix.Unix_error _ -> create_file f
  );
  f

let rc_doc_bookmarks = 
  let f = Filename.concat rc_dir "doc_bookmarks" in
  (
   try ignore (Unix.stat f)
   with Unix.Unix_error _ -> create_file f
  );
  f

let rc_gui = Filename.concat rc_dir "gui"
let rc_core = Filename.concat rc_dir "core"

(** {2 Command line options messages} *)

let usage ="Usage : "^Sys.argv.(0)^" [options] [dir1 dir2 ...]\nwhere options are :"
let usage_browser ="Usage : "^Sys.argv.(0)^" <file1.odoc> [<file2.odoc> ...]"
let opt_version = " display version and exits."
let opt_no_rep = " no repository available, do not execute cvs commands"
let opt_check_edited_files_delay = " delay (in ms) used to check if files are still edited (in efuns of xemacs)"
let opt_init_commands = "commands to execute at launch"

(** {2 Strings used in config files} *)

let conf_color = "color"
let conf_editor = "edit"
let conf_templates = "templates"
let conf_binary = "binary"

(** {3 Actions for key bindings} *)

let a_next_element = "next_element"
let a_prev_element = "previous_element"
let a_follow_link = "follow_link"
let a_follow_link_in_new = "follow_link_in_new"
let a_close = "close"
let a_search = "search"
let a_search_backward = "search_back"
let a_back = "back"
let a_add_bookmark = "add_bookmark"
let a_home = "home"
let a_end = "end"
let a_menu = "menu"

let doc_browser_actions = [
  a_next_element ; a_prev_element ;
  a_follow_link_in_new ; a_follow_link ;
  a_close ; a_search ; a_search_backward ;
  a_back ; a_add_bookmark ; a_home ; a_end ;
  a_menu ;
] 


let a_new_file = "new_file"

(** Update the files view. *)
let a_update_files_view = "update_files_view"

(** Edit the selected files with their associated editor(s). @command edit *)
let a_edit = "edit"

(** Edit the selected files with an editor chossen among the vailable ones.
   @command edit_with *)
let a_edit_with = "edit_with"

(** Open the configuration window. @command config *)
let a_config = "config"

(** Quit Cameleon. @command quit *)
let a_quit = "quit"

(** Prompt to add a directory to the selected one. Then perform the [cvs add] command. 
   @command add_dir *)
let a_add_dir = "add_dir"

(** [cvs update] the selected directory. @command update_dir *)
let a_update_dir = "update_dir"

(** Update the directory view. @command update_dir_view *)
let a_update_dir_view = "update_dir_view"

(** [cvs commit] the selected directory. @command commit_dir *)
let a_commit_dir = "commit_dir"

(** [cvs log] the selected file. @comand log_file *)
let a_log = "log_file"

(** Prompt for a tag and tag all files under the selected directory.
   Before, it checks whether one or more files already have the given tag, and
   ask for confirmation if is the case. 
   @command tag_dir *)
let a_tag_dir = "tag_dir"

(** Prompt for a file name to add in the selected directory. Then perform
   the [cvs add] command. @command add_file.*)
let a_add_file = "add_file"

(** Prompt for a binary file name to add in the selected directory. Then perform
   the [cvs add] command. @command add_binary_file.*)
let a_add_binary_file = "add_binary_file"

(** Prompt for a comment, then perform a [cvs commit] on the selected files. 
   @command commit_files *)
let a_commit_files = "commit_files"

(** Prompt for a tag and tag the selected files.
   Before, it checks whether one or more files already have the given tag, and
   ask for confirmation if is the case. 
   @command tag_files *)
let a_tag_file = "tag_files"

(** Show the list of tags of the first selected file. @command tags_of_file *)
let a_tags_of_file = "tags_of_file"

(** Ask for confirmation then performs a [cvs remove] on the selected files. 
   @command remove_files *)
let a_remove_file = "remove_files"

(** Show the differences between the first selected file and its original
   version in the repository. @command last_diff *)
let a_last_differences = "last_diff"

(** Ask for a version of the first selected file, and show differences between
   the current version and the selected version. @command diff_with *)
let a_diff_with = "diff_with"

(** Show the differences between two versions of the first selected file.
   The user is promped to select the two versions to compare. 
   @command diff_between *)
let a_diff_between = "diff_between"

(** Launch the conflict resolving assistant on the first selected file. 
   @command resolve_conflicts *)
let a_resolve_conflicts = "resolve_conflicts"

(** Make the user select a loaded plug-in and reload it.
   @command reload_plugin *)
let a_reload_plugin = "reload_plugin"

(** Display or update the box with the list of top modules whose documentation
   is available.@command display_modules_box *)
let a_display_doc_box = "display_modules_box"

(** Display the "about..." box. @command about_box *)
let a_about_box = "about_box"

(** Display the list of available internal commands, with
   their description. @command list_commands *)
let a_list_commands = "list_commands"

let h_reload_plugin = "Select a loaded plug-in and reload it"
let h_list_commands = 
  "Display the list of available internal commands, with their description."

(** {2 Messages} *)

let mYes = "Yes"
let mNo = "No"
let mOk = "Ok"
let mCancel = "Cancel"
let mQuestion = "Question"

let error = "Error"
let error_exec com = "Error while executing command\n"^com
let error_syntax f n= "File "^f^" syntax error line "^(string_of_int n)
let error_not_found ele name = ele^" "^name^" not found."
let error_not_found_module n = error_not_found "Module" n
let error_not_found_module_type n = error_not_found "Module type" n
let error_not_found_mmt n = error_not_found "Module or module type" n
let error_not_found_class n = error_not_found "Class" n
let error_not_found_class_type n = error_not_found "Class type" n
let error_not_found_cct n = error_not_found "Class or class type" n
let error_not_found_exception n = error_not_found "Exception" n
let error_not_found_type n  = error_not_found "Type" n
let error_not_found_value n = error_not_found "Value" n
let error_not_found_attribute n = error_not_found "Attribute" n
let error_not_found_method n = error_not_found "Method" n
let error_file_exists f = "File "^f^" exists."
let error_cvs_add f = "CVS Error : file "^f^" could not be added."
let error_file_info f = "Information on file \n"^f^" could not be obtained."
let error_unknown_action a = "Unknown action "^a^"."
let error_load_file f s = Printf.sprintf "Error while loading %s: %s" f s
let error_unknown_editor s = "Unknown editor "^s^"."

let select_a_directory_first = "Select a directory first."
let back = "Back"
let authors = "Authors"
let version = "Version"
let since = "Since"
let raises = "Raise"
let see_also = "See also"
let returns = "Return"
let deprecated = "Deprecated"
let parameters = "Parameters"
let inherits = "Inherits"
let save_changed_file_before f = 
  "File "^f^" has been changed.\n"^
  "Save this file and continue, skip this file or stop ?"
let skip = "Skip"
let continue = "Continue"
let stop = "Stop"
let nothing_found s = "Nothing found for "^s^"."
let close = "Close"
let kind = "Kind"
let name = "Name"
let file = "File"
let date = "Date"
let status = "Status"
let working_rev = "Working rev."
let rep_rev = "Repository rev."
let file_type = "File type"
let add = "Add"
let remove = "Remove"
let pattern = "Pattern"
let color = "Color"
let editor = "Editor"
let default_editor = "Default editor"
let edit = "Edit"
let up = "Up"
let file_types = "File types"
let configuration = "Configuration"
let doc_file = "Documentation file"
let doc_files = "Documentation files"
let label = "Label"
let command = "Command"
let templates = "Templates"
let binary = "Binary"
let icon = "Icon"
let icon_file = "Icon file (xpm)"
let custom_toolbar = "Custom toolbar"
let search = "Search"
let menus = "Menus"
let copy = "Copy"
let cut = "Cut"
let paste = "Paste"
let add_menu = "Add menu"
let add_command = "Add command"
let separator = "Separator"
let menu = "Menu"
let doc_flag =  "Use this menu as doc menu"
let running = "Running ..."
let return_code n = "Exited with code "^(string_of_int n)
let kill_code n = "Killed with signal "^(string_of_int n)
let stop_code n = "Stopped with signal "^(string_of_int n)

let kill = "Kill"

let types_color = "Types"
let keywords_color = "Keywords"
let constructors_color = "Constructors"
let code_color = "Code"
let exec_stdout_color = "Command stdout"
let exec_stderr_color = "Command stderr"
let doc_code_font = "Code font"
let doc_code_bold_font = "Bold code font"
let doc_bold_font = "Bold font"
let doc_normal_font = "Normal font"
let exec_font = "Command output font"
let colors_and_fonts = "Colors / fonts"
let commands = "Commands"
let description = "Description"

let color_user_code = "User code"
let color_ocaml_output = "OCaml output"
let color_error_background = "Error background"
let font_code = "Code font"

let key_bindings = "Key bindings"
let binding = "Binding"
let edit_binding = "Edit binding"
let doc_browser_bindings = "Doc browser bindings"
let main_window_bindings = "Main window bindings"
let main_window = "Main window"

let execute = "Execute"

let plugins = "Plug-ins"

let no_plugin_loaded = "No plug-in loaded."
let plugin_to_reload = "Plug-in to reload"

let shared_plugins_to_load = 
  "The shared plugins to load (from "^Cam_installation.plugins_dir^")"
let personal_plugins_to_load = 
  "The personal plugins to load (from "^plugins_dir^")"
let already_loaded = "Already loaded"

let files = "Files"
let modules = "Modules"
let refresh = "Refresh"
let implementation = "Implementation"
let interface = "Interface"

let view_module_color = "Module and module types"
let view_class_color = "Class and class types"
let view_type_color = "Types"
let view_value_color = "Values, attributes and methods"
let view_exception_color = "Exceptions"

let doc_browser = "Doc browser"
let command_execution = "Command execution"
let modules_view = "Modules view"

let auto_expand = "Auto expand"

let kind = "Kind"
let typ = "Type"
let elements = "Elements"
let value = "value"

let welcome = "Welcome to "^software^" version "^software_version

let analyzing_dir d = "Analyzing directory "^d^" ..."
let loading_file f = "Loading file "^f^" ..."
let running_com com = "Running "^com^" ..."

let auto_update_file_view = "Auto update file view"
let misc_options = "Misc"
let file_double_click_command = "File double click command"



(** {2 Menu labels} *)

let m_file = "File"
let m_cvs = "CVS"
let m_add_dir = "Add directory"
let m_add_binary_files = "Add binary file"
let m_update_dir = "Update selected directory"
let m_update_dir_view = "Update directory view"
let m_commit_dir = "Commit selected directory"
let m_add_files = "Add file"
let m_commit_files = "Commit selected files"
let m_remove_files = "Remove selected files"
let m_last_diff = "Last differences"
let m_diff_with = "Differences with ..."
let m_diff_between = "Differences between ..."
let m_quit = "Quit"
let m_doc = "Doc"
let m_edit = "Edit"
let m_edit_with = "Edit with..."
let m_search_exact = "Exact search"
let m_search_regexp = "Regexp search"
let m_display = "Display"
let m_modules_box = "Doc box"
let m_configuration = configuration
let m_new_dots = "New..."
let m_new = "New"
let m_tag_dir = "Tag selected directory"
let m_tag_files = "Tag selected files"
let m_tags_of_file = "List tags of the selected file"
let m_resolve_conflicts = "Resolve merge conflicts"
let m_question_mark = "?"
let m_about = "About "^software^"..."
let m_about_top = "About "^software_top^"..."
let m_auto_expand = "Auto expand"
let m_make = "Make"
let m_list_commands = "List of internal commands"
let m_save = "Save"
let m_save_as = "Save as ..."
let m_load_file = "Load file..."
let m_log_file = "Show log"
