(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

type command = string

type menu =
    { mutable mn_label : string ;
      mutable mn_children : menu_item list;
      mutable mn_doc : bool ;
    } 

and menu_item_info =
    { mutable mii_label : string ;
      mutable mii_command : command ;
    } 

and menu_item = 
    Submenu of menu
  | Command of menu_item_info
  | Separator of string 
     (* to be able to make a physic difference between two separators *)

let string_of_menu m =
  let f = Format.str_formatter in
  Format.pp_open_box f 0;
  xprint_menu f m; 
  Format.pp_close_box f ();
  Format.flush_str_formatter ()

let menu_of_string s =
  try
    let tree = IoXML.parse_xml (Stream.of_string s) in
    xparse_menu tree
  with
    IoXML.ExcLoc ((bp,ep), e) ->
      prerr_endline ("Error at location "^(string_of_int bp)^" -> "^(string_of_int ep));
      { mn_label = "error";
	mn_children = [] ;
	mn_doc = false
      }	

let doc_menu = ref (GMenu.menu ())

