(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Icons for graphical interface. *)

let new_file = [|
"24 24 89 1";
" 	c None";
".	c #000000";
"+	c #ADAD9C";
"@	c #959585";
"#	c #DCDCC5";
"$	c #DFDFC8";
"%	c #242424";
"&	c #A7A796";
"*	c #D7D7C1";
"=	c #D9D9C3";
"-	c #DCDCC4";
";	c #DDDDC7";
">	c #E1E1CA";
",	c #A6A694";
"'	c #D6D6BF";
")	c #D8D8C2";
"!	c #DBDBC4";
"~	c #DFDFC7";
"{	c #E3E3CB";
"]	c #B2B29F";
"^	c #7C7C7C";
"/	c #646464";
"(	c #D5D5BD";
"_	c #D5D5BF";
":	c #D7D7C0";
"<	c #DADAC3";
"[	c #DEDEC6";
"}	c #E1E1C9";
"|	c #E5E5CD";
"1	c #E9E9D1";
"2	c #343434";
"3	c #E7E7E7";
"4	c #373736";
"5	c #B8B8A6";
"6	c #D3D3BC";
"7	c #D9D9C2";
"8	c #DDDDC5";
"9	c #E0E0C8";
"0	c #E8E8D0";
"a	c #ECECD4";
"b	c #EEEED5";
"c	c #ECECEC";
"d	c #EDEDED";
"e	c #3D3D37";
"f	c #CECEB7";
"g	c #E6E6CE";
"h	c #EAEAD2";
"i	c #F1F1D8";
"j	c #A5A594";
"k	c #EEEEE5";
"l	c #3C3C3C";
"m	c #8F8F80";
"n	c #D0D0B9";
"o	c #E4E4CB";
"p	c #EAEAD1";
"q	c #ECECD3";
"r	c #EFEFD6";
"s	c #F2F2D9";
"t	c #F3F3DA";
"u	c #EEEEE6";
"v	c #505050";
"w	c #929282";
"x	c #D1D1B9";
"y	c #E7E7CF";
"z	c #EBEBD2";
"A	c #F4F4DB";
"B	c #F5F5DC";
"C	c #969686";
"D	c #D2D2BC";
"E	c #E0E0C9";
"F	c #E9E9D0";
"G	c #EDEDD4";
"H	c #F0F0D7";
"I	c #BEBEAB";
"J	c #797973";
"K	c #D8D8C1";
"L	c #DDDDC6";
"M	c #98988F";
"N	c #E4E4CC";
"O	c #818174";
"P	c #E2E2CA";
"Q	c #BEBEAE";
"R	c #4E4E4E";
"S	c #828274";
"T	c #EBEBD3";
"U	c #BBBBA8";
"V	c #CDCDB8";
"W	c #4D4D45";
"X	c #A6A696";
"                        ";
"                        ";
"             .          ";
"           ..+.         ";
"         ..@#$%         ";
"       ..&*=-;>.        ";
"     ..,'**)!~{].       ";
"    .^/'(_:<[}|12       ";
"    .3456*789|0ab.      ";
"    .cdef_!9g0hbij.     ";
"    .kklmn9opqrist.     ";
"    .uvwx-}yzbittAB.    ";
"    ..CD!E{FGHtAABBI.   ";
"    .JK7L>ypbitBBBBB).  ";
"    .M!#$NyzbitBBBBBO.  ";
"     .~9P|1qrsABBBB..   ";
"     .Q||0hGHtABB<.     ";
"      R01hGrstAsS.      ";
"      .TaGriss<.        ";
"       .rHis1j.         ";
"       .UstVW.          ";
"        .tX.            ";
"         ..             ";
"                        "
|]

let edit = [|
"24 24 5 1";
" 	c None";
".	c #000000";
"+	c #99907B";
"@	c #FFFEF7";
"#	c #FFFFFF";
"                        ";
"                        ";
"                        ";
"                        ";
"                        ";
"              ..        ";
"           ...++.       ";
"    ..  ...++++@@#...   ";
"   .++..++++@@@@..++.   ";
"   .+++++@@@@@..++++.   ";
"    .++@@@@@..++++++.   ";
"    .++@@@..++++++++.   ";
"     .+@@.++++++++++.   ";
"     .++@.++++++++++.   ";
"      .+@.++++++++++.   ";
"      .++.++++++++..    ";
"       .+.++++++..      ";
"       .+.+++++.        ";
"        ..+++..         ";
"        ..+..           ";
"         ..             ";
"                        ";
"                        ";
"                        "
|]

let options = [|
"24 24 113 2";
"  	c None";
". 	c #000000";
"+ 	c #ADAD9C";
"@ 	c #959585";
"# 	c #DCDCC5";
"$ 	c #DFDFC8";
"% 	c #242424";
"& 	c #A7A796";
"* 	c #D7D7C1";
"= 	c #D9D9C3";
"- 	c #DCDCC4";
", 	c #DDDDC7";
"> 	c #E1E1CA";
"; 	c #D8BE6A";
"' 	c #A6A694";
") 	c #D6D6BF";
"! 	c #D8D8C2";
"~ 	c #DBDBC4";
"{ 	c #A2A291";
"] 	c #E3E3CB";
"^ 	c #B2B29F";
"/ 	c #8E7D45";
"( 	c #7C7C7C";
"_ 	c #646464";
": 	c #D5D5BD";
"< 	c #D5D5BF";
"[ 	c #D7D7C0";
"} 	c #9E9E8D";
"| 	c #ABAB98";
"1 	c #E1E1C9";
"2 	c #E5E5CD";
"3 	c #E9E9D1";
"4 	c #343434";
"5 	c #E7E7E7";
"6 	c #373736";
"7 	c #B8B8A6";
"8 	c #D3D3BC";
"9 	c #909081";
"0 	c #9F9F8E";
"a 	c #DDDDC5";
"b 	c #E0E0C8";
"c 	c #A2A292";
"d 	c #ECECD4";
"e 	c #EEEED5";
"f 	c #ECECEC";
"g 	c #EDEDED";
"h 	c #3D3D37";
"i 	c #8A8A7A";
"j 	c #E6E6CE";
"k 	c #9A9A8A";
"l 	c #EAEAD2";
"m 	c #EEEEE5";
"n 	c #3C3C3C";
"o 	c #8F8F80";
"p 	c #D0D0B9";
"q 	c #999988";
"r 	c #ECECD3";
"s 	c #EFEFD6";
"t 	c #EEEEE6";
"u 	c #505050";
"v 	c #929282";
"w 	c #D1D1B9";
"x 	c #969686";
"y 	c #E7E7CF";
"z 	c #EBEBD2";
"A 	c #F5F5DC";
"B 	c #D2D2BC";
"C 	c #E9E9D0";
"D 	c #EDEDD4";
"E 	c #E3E3DC";
"F 	c #797973";
"G 	c #D8D8C1";
"H 	c #919182";
"I 	c #949484";
"J 	c #EAEAD1";
"K 	c #D9D9CC";
"L 	c #BFBFB0";
"M 	c #ACACA5";
"N 	c #9F9F93";
"O 	c #98988F";
"P 	c #E4E4CC";
"Q 	c #AD8E30";
"R 	c #756020";
"S 	c #C4C4B0";
"T 	c #9D9D8D";
"U 	c #818174";
"V 	c #DFDFC7";
"W 	c #E2E2CA";
"X 	c #060605";
"Y 	c #9B9B8B";
"Z 	c #9C9C8C";
"` 	c #BEBEAE";
" .	c #8B8B7D";
"..	c #7E7E71";
"+.	c #C0C0AC";
"@.	c #C2C2AE";
"#.	c #C3C3AF";
"$.	c #DADAC3";
"%.	c #4E4E4E";
"&.	c #E8E8D0";
"*.	c #A0A090";
"=.	c #F2F2D9";
"-.	c #F3F3DA";
",.	c #F4F4DB";
">.	c #828274";
";.	c #EBEBD3";
"'.	c #F1F1D8";
").	c #F0F0D7";
"!.	c #A5A594";
"~.	c #BBBBA8";
"{.	c #CDCDB8";
"].	c #4D4D45";
"^.	c #A6A696";
"                                                ";
"                                                ";
"                          .                     ";
"                      . . + .                   ";
"                  . . @ # $ %             .     ";
"              . . & * = - , > .         . ; .   ";
"          . . ' ) * * ! ~ { ] ^ .     . ; / .   ";
"        . ( _ ) : < [ } | 1 2 3 4   . ; / .     ";
"        . 5 6 7 8 9 0 a b 2 c d e . ; / .       ";
"        . f g h i < ~ b j k l e . ; / .         ";
"        . m m n o p b q q r s . ; / .           ";
"        . t u v w - x y z e . ; / . A .         ";
"        . . x B ~ x ] C D . ; / . A A E .       ";
"        . F G H I > y J . ; / . A K L M N .     ";
"        . O ~ # $ P y Q R . . S T T T T U .     ";
"          . V b W 2 3 X . Y Z T T T T . .       ";
"          . ` 2 2 T  ...+.@.#.S A $..           ";
"            %.&.*.l D s =.-.,.=.>..             ";
"            . ;.d D s '.=.=.$..                 ";
"              . s ).'.=.3 !..                   ";
"              . ~.=.-.{.]..                     ";
"                . -.^..                         ";
"                  . .                           ";
"                                                "
|] 

let create_pixmap i =
  let gdk_pix = GDraw.pixmap_from_xpm_d ~data: i 
      ~colormap: (Gdk.Color.get_system_colormap ())
      () 
  in
  let pix = GMisc.pixmap gdk_pix () in
  pix
