(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(* File edition management. *)

open Cam_data
open Cam_types



let internal_editors = 
  [ (Cam_types.Dbforge, fun f -> new Dbforge.dbforge_app f) ;
    (Cam_types.Report, fun f -> new Report_gui.report_app f) ;
    (Cam_types.Zoggy, fun f -> new Zoggy.zoggy_app f) ;
  ]

let use_custom_editor com ?char file =
  try
    let f = List.assoc com !Cam_global.custom_editors in
    f ?char file
  with
    Not_found ->
      raise (Failure (Cam_messages.error_unknown_editor com))

let edit data ?editor ?char file =
  let ed = 
    match editor with
      None -> file.f_type.ft_edit
    | Some e -> e
  in
  match ed with
    Cam_types.Emacs ->
      (
       try Cam_emacs.edit ?char file
       with Failure s ->
	 GToolbox.message_box Cam_messages.error s
      )
  | Cam_types.XEmacs ->
      (
       try 
	 let editor = Cam_xemacs.edit ?char file in
	 data#edit_file file editor
       with Failure s ->
	 GToolbox.message_box Cam_messages.error s
      )
  | Cam_types.Efuns ->
      (
       try 
	 let editor = Cam_efuns.edit data ?char file in
	 data#edit_file file editor
       with Failure s ->
	 GToolbox.message_box Cam_messages.error s
      )
  | Cam_types.Custom_editor com ->
      (
      if data#is_edited file then
	()
      else
	try 
	  match use_custom_editor com ?char file with
	    None -> ()
	  | Some editor ->
	      data#edit_file file editor
	with Failure  s ->
	  GToolbox.message_box Cam_messages.error s
      )
  | edit_method ->
      if data#is_edited file then
	()
      else
	try 
	  let f = List.assoc edit_method internal_editors in
	  let window = GWindow.window
	      ~width: 500 ~height: 400 
	      ~title: ((Cam_types.string_of_editor edit_method)^" : "^file.f_name)
	      ()
	  in
	  let _ = window#connect#destroy (fun () -> data#close_file file) in
	  let box = f file.f_name in
	  let _ = window#add box#box#coerce in
	  let _ = box#init_window window in
	  let _ = box#box#connect#destroy window#destroy in
	  let _ = window#show () in
	  data#edit_file file (box :> Cam_types.editor_app)
	with
	  _ ->
	    ()
    
